/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.ModTextures;
import net.mehvahdjukaar.supplementaries.common.events.ItemsOverrideHandler;
import net.mehvahdjukaar.supplementaries.common.items.loot.CurseLootFunction;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.common.world.data.map.WeatheredMap;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.CauldronRegistry;
import net.mehvahdjukaar.supplementaries.reg.DispenserRegistry;
import net.mehvahdjukaar.supplementaries.reg.LootTablesInjects;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.PresentRegistry;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;

public class ModSetup {
    private static boolean hasFinishedSetup = false;
    private static int setupStage = 0;
    public static boolean firstTagLoad = false;
    private static final List<Runnable> MOD_SETUP_WORK = List.of(ModTextures::setup, CurseLootFunction::setup, CompatHandler::setup, FlowerPotHandler::setup, WeatheredMap::setup, NetworkHandler::registerMessages, LootTablesInjects::init, ModSetup::registerCompostables, ModSetup::registerMobFoods, CauldronRegistry::registerInteractions, PresentRegistry::registerBehaviors);

    public static void setup() {
        try {
            Stopwatch watch = Stopwatch.createStarted();
            for (int i = 0; i < MOD_SETUP_WORK.size(); ++i) {
                setupStage = i;
                MOD_SETUP_WORK.get(i).run();
            }
            hasFinishedSetup = true;
            Supplementaries.LOGGER.info("Finished mod setup in: {} ms", (Object)watch.elapsed().toMillis());
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error((Object)e);
            ModSetup.terminateWhenSetupFails();
        }
    }

    private static void terminateWhenSetupFails() {
        throw new IllegalStateException("Mod setup has failed to complete (" + setupStage + ").\n This might be due to some mod incompatibility or outdated dependencies (check if everything is up to date).\n Refusing to continue loading with a broken modstate. Next step: crashing this game, no survivors");
    }

    private static void registerMobFoods() {
        ArrayList<ItemStack> chickenFood = new ArrayList<ItemStack>(List.of(Chicken.f_28233_.m_43908_()));
        chickenFood.add(new ItemStack((ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get()));
        Chicken.f_28233_ = Ingredient.m_43921_(chickenFood.stream());
        ArrayList<ItemStack> horseFood = new ArrayList<ItemStack>(List.of(new ItemStack((ItemLike)ModRegistry.FLAX_ITEM.get()), new ItemStack((ItemLike)ModRegistry.FLAX_BLOCK.get())));
        horseFood.addAll(List.of(AbstractHorse.f_30527_.m_43908_()));
        AbstractHorse.f_30527_ = Ingredient.m_43921_(horseFood.stream());
    }

    private static void registerCompostables() {
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModRegistry.FLAX_ITEM.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModRegistry.FLAX_WILD.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModRegistry.FLAX_BLOCK.get()), 1.0f);
    }

    public static void tagDependantSetup() {
        if (!firstTagLoad) {
            firstTagLoad = true;
            if (!hasFinishedSetup) {
                try {
                    Supplementaries.LOGGER.error("Something went wrong during mod setup, exiting");
                    MOD_SETUP_WORK.get(setupStage).run();
                    Supplementaries.LOGGER.error("No error found. Weird");
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error((Object)e);
                }
                ModSetup.terminateWhenSetupFails();
            }
            Stopwatch watch = Stopwatch.createStarted();
            DispenserRegistry.registerBehaviors();
            ItemsOverrideHandler.registerOverrides();
            Supplementaries.LOGGER.info("Finished additional setup in {} seconds", (Object)watch.elapsed().toSeconds());
        }
    }
}

