/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private int ropeTicks = 0;
    @Unique
    private double lastY = 0.0;

    public LivingEntityMixin(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Shadow
    public abstract boolean m_6147_();

    @Shadow
    public abstract boolean m_5791_();

    @Shadow
    @Nullable
    public abstract MobEffectInstance m_21124_(MobEffect var1);

    @Inject(method={"getJumpBoostPower"}, at={@At(value="RETURN")}, cancellable=true)
    private void getJumpBoostPower(CallbackInfoReturnable<Double> cir) {
        MobEffectInstance effect = this.m_21124_(ModRegistry.OVERENCUMBERED.get());
        if (effect != null && effect.m_19564_() > 0) {
            cir.setReturnValue((Object)((Double)cir.getReturnValue() - 0.1));
        }
    }

    @Inject(method={"handleOnClimbable"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleOnClimbable(Vec3 motion, CallbackInfoReturnable<Vec3> info) {
        if (this.m_6147_() && CommonConfigs.Blocks.ROPE_SLIDE.get().booleanValue()) {
            BlockState b2 = this.m_146900_();
            if (b2.m_60713_(ModRegistry.ROPE.get())) {
                this.f_19789_ = 0.0f;
                double x = Mth.m_14008_((double)motion.f_82479_, (double)-0.15f, (double)0.15f);
                double z = Mth.m_14008_((double)motion.f_82481_, (double)-0.15f, (double)0.15f);
                double y = motion.m_7098_();
                if (this.m_5791_()) {
                    if (y < 0.0 && this instanceof Player) {
                        y = 0.0;
                    }
                    if (this.ropeTicks > 0) {
                        --this.ropeTicks;
                    }
                } else if (this.f_19853_.f_46443_ && this.m_20186_() < this.lastY && y < -0.05) {
                    this.ropeTicks = RopeBlock.playEntitySlideSound((LivingEntity)this, this.ropeTicks) && this.ropeTicks != 0 ? 1 : ++this.ropeTicks;
                }
                info.setReturnValue((Object)new Vec3(x, y, z));
            }
        } else if (this.ropeTicks > 0) {
            --this.ropeTicks;
        }
        this.lastY = this.m_20186_();
    }
}

