/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.JarItem;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import vazkii.quark.addons.oddities.item.BackpackItem;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.automation.module.PistonsMoveTileEntitiesModule;
import vazkii.quark.content.building.block.WoodPostBlock;
import vazkii.quark.content.building.module.VerticalSlabsModule;
import vazkii.quark.content.tweaks.module.DoubleDoorOpeningModule;

public class QuarkCompatImpl {
    private static Field MOVEMENTS = null;

    @Nullable
    public static BlockState updateWoodPostShape(BlockState post, Direction facing, BlockState facingState) {
        if (post.m_60734_() instanceof WoodPostBlock) {
            Direction.Axis axis = (Direction.Axis)post.m_61143_((Property)WoodPostBlock.AXIS);
            if (facing.m_122434_() != axis) {
                boolean chain = facingState.m_60734_() instanceof ChainBlock && facingState.m_61143_((Property)BlockStateProperties.f_61365_) == facing.m_122434_();
                return (BlockState)post.m_61124_((Property)WoodPostBlock.CHAINED[facing.ordinal()], (Comparable)Boolean.valueOf(chain));
            }
        }
        return null;
    }

    public static InteractionResult tryCaptureTater(JarItem jarItem, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public static boolean isDoubleDoorEnabled() {
        return ModuleLoader.INSTANCE.isModuleEnabled(DoubleDoorOpeningModule.class);
    }

    public static boolean canMoveBlockEntity(BlockState state) {
        return !PistonsMoveTileEntitiesModule.shouldMoveTE((boolean)true, (BlockState)state);
    }

    public static int getSacksInBackpack(ItemStack stack) {
        LazyOptional handlerOpt;
        int j = 0;
        if (stack.m_41720_() instanceof BackpackItem && (handlerOpt = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).isPresent()) {
            IItemHandler handler = (IItemHandler)handlerOpt.orElse(null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                CompoundTag tag;
                ItemStack slotItem = handler.getStackInSlot(i);
                if (!(slotItem.m_41720_() instanceof SackItem) || (tag = stack.m_41783_()) == null || !tag.m_128441_("BlockEntityTag")) continue;
                ++j;
            }
        }
        return j;
    }

    public static boolean isVerticalSlabEnabled() {
        return ModuleLoader.INSTANCE.isModuleEnabled(VerticalSlabsModule.class);
    }

    public static void tickPiston(Level level, BlockPos pos, AABB pistonBB, boolean sameDir, BlockEntity movingTile) {
        List list = level.m_45933_(null, pistonBB);
        for (Entity entity : list) {
            BlockEntity blockEntity;
            AABB entityBB;
            Player player;
            if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
                return;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!entity.m_6084_() || !pistonBB.m_82381_(entityBB = entity.m_20191_())) continue;
            if (CompatHandler.quark && (blockEntity = QuarkCompatImpl.getMovingBlockEntity(pos, level)) instanceof BambooSpikesBlockTile) {
                IBlockHolder te;
                BlockState state;
                BambooSpikesBlockTile tile = (BambooSpikesBlockTile)blockEntity;
                if (tile.interactWithEntity(livingEntity, level) && movingTile instanceof IBlockHolder && (state = (te = (IBlockHolder)movingTile).getHeldBlock()).m_60734_() instanceof BambooSpikesBlock) {
                    te.setHeldBlock((BlockState)state.m_61124_((Property)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
                }
                QuarkCompatImpl.updateMovingTile(pos, level, tile);
            }
            entity.m_6469_(ModDamageSources.SPIKE_DAMAGE, sameDir ? 3.0f : 1.0f);
        }
    }

    private static void updateMovingTile(BlockPos pos, Level world, BlockEntity tile) {
        try {
            Map worldMovements;
            WeakHashMap movements;
            Object o;
            if (MOVEMENTS == null) {
                MOVEMENTS = ObfuscationReflectionHelper.findField(PistonsMoveTileEntitiesModule.class, (String)"movements");
            }
            if ((o = MOVEMENTS.get(null)) instanceof WeakHashMap && (movements = (WeakHashMap)o).containsKey(world) && (worldMovements = (Map)movements.get(world)).containsKey(pos)) {
                worldMovements.remove(pos);
                worldMovements.put(pos, tile.m_187480_());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BlockEntity getMovingBlockEntity(BlockPos pos, Level level) {
        return PistonsMoveTileEntitiesModule.getMovement((Level)level, (BlockPos)pos);
    }
}

