/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.gson.JsonObject;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;

public class ServerDynamicResourcesHandler
extends DynServerResourcesProvider {
    public static final ServerDynamicResourcesHandler INSTANCE = new ServerDynamicResourcesHandler();
    private IRecipeTemplate<?> signPostTemplate2;

    public ServerDynamicResourcesHandler() {
        super(new DynamicDataPack(Supplementaries.res("generated_pack")));
        ((DynamicDataPack)this.dynamicPack).generateDebugResources = PlatformHelper.isDev() || RegistryConfigs.DEBUG_RESOURCES.get() != false;
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return RegistryConfigs.PACK_DEPENDANT_ASSETS.get();
    }

    public void regenerateDynamicAssets(ResourceManager resourceManager) {
        Holder holder;
        if (RegistryConfigs.SIGN_POST_ENABLED.get().booleanValue()) {
            this.addSignPostRecipes(resourceManager);
        }
        if (RegistryConfigs.HANGING_SIGN_ENABLED.get().booleanValue()) {
            this.addHangingSignRecipes(resourceManager);
        }
        SimpleTagBuilder builder = SimpleTagBuilder.of(ModTags.HAS_WAY_SIGNS);
        if (CommonConfigs.Spawns.WAY_SIGN_ENABLED.get().booleanValue()) {
            for (ResourceLocation id : BuiltinRegistries.f_123865_.m_6566_()) {
                holder = BuiltinRegistries.f_123865_.m_206081_(ResourceKey.m_135785_((ResourceKey)BuiltinRegistries.f_123865_.m_123023_(), (ResourceLocation)id));
                if (holder.m_203656_(BiomeTags.f_207603_) || holder.m_203656_(BiomeTags.f_207612_) || holder.m_203656_(BiomeTags.f_215818_) || holder.m_203656_(BiomeTags.f_207605_) || holder.m_203656_(BiomeTags.f_207610_) || holder.m_203565_(Biomes.f_48215_)) continue;
                builder.add(id);
            }
        }
        ((DynamicDataPack)this.dynamicPack).addTag(builder, Registry.f_122885_);
        builder = SimpleTagBuilder.of(ModTags.HAS_CAVE_URNS);
        if (CommonConfigs.Spawns.URN_PILE_ENABLED.get().booleanValue()) {
            for (ResourceLocation id : BuiltinRegistries.f_123865_.m_6566_()) {
                holder = BuiltinRegistries.f_123865_.m_206081_(ResourceKey.m_135785_((ResourceKey)BuiltinRegistries.f_123865_.m_123023_(), (ResourceLocation)id));
                if (holder.m_203656_(BiomeTags.f_215818_) || holder.m_203656_(BiomeTags.f_207612_) || CommonConfigs.Spawns.URN_BIOME_BLACKLIST.get().contains(id.toString())) continue;
                builder.add(id);
            }
        }
        ((DynamicDataPack)this.dynamicPack).addTag(builder, Registry.f_122885_);
        builder = SimpleTagBuilder.of(ModTags.HAS_WILD_FLAX);
        if (CommonConfigs.Spawns.WILD_FLAX_ENABLED.get().booleanValue()) {
            for (ResourceLocation id : BuiltinRegistries.f_123865_.m_6566_()) {
                holder = BuiltinRegistries.f_123865_.m_206081_(ResourceKey.m_135785_((ResourceKey)BuiltinRegistries.f_123865_.m_123023_(), (ResourceLocation)id));
                if (holder.m_203656_(BiomeTags.f_215818_) || holder.m_203656_(BiomeTags.f_207612_) || !holder.m_203656_(BiomeTags.f_207604_) && !holder.m_203656_(BiomeTags.f_207605_) && !holder.m_203656_(BiomeTags.f_207607_) && !holder.m_203656_(BiomeTags.f_207590_)) continue;
                builder.add(id);
            }
        }
        ((DynamicDataPack)this.dynamicPack).addTag(builder, Registry.f_122885_);
    }

    public void generateStaticAssetsOnStartup(ResourceManager manager) {
        SimpleTagBuilder builder = SimpleTagBuilder.of((ResourceLocation)Supplementaries.res("hanging_signs"));
        ModRegistry.HANGING_SIGNS.forEach((wood, sign) -> {
            ((DynamicDataPack)this.dynamicPack).addSimpleBlockLootTable((Block)sign);
            builder.addEntry((Object)sign);
        });
        ((DynamicDataPack)this.dynamicPack).addTag(builder, Registry.f_122901_);
        ((DynamicDataPack)this.dynamicPack).addTag(builder, Registry.f_122904_);
        builder = SimpleTagBuilder.of((ResourceLocation)Supplementaries.res("sign_posts"));
        builder.addEntries(ModRegistry.SIGN_POST_ITEMS.values());
        ((DynamicDataPack)this.dynamicPack).addTag(builder, Registry.f_122904_);
    }

    private void addHangingSignRecipes(ResourceManager manager) {
        IRecipeTemplate template = RPUtils.readRecipeAsTemplate((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(Supplementaries.res("hanging_sign_oak")));
        ModRegistry.HANGING_SIGNS.forEach((w, b2) -> {
            Item i;
            if (w != WoodTypeRegistry.OAK_TYPE && (i = b2.m_5456_()).m_41471_() != null) {
                FinishedRecipe newR = template.createSimilar((BlockType)WoodTypeRegistry.OAK_TYPE, (BlockType)w, w.mainChild().m_5456_());
                if (newR == null) {
                    return;
                }
                newR = ForgeHelper.addRecipeConditions((FinishedRecipe)newR, (List)template.getConditions());
                ((DynamicDataPack)this.dynamicPack).addRecipe(newR);
            }
        });
    }

    private void addSignPostRecipes(ResourceManager manager) {
        IRecipeTemplate template = RPUtils.readRecipeAsTemplate((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(Supplementaries.res("sign_post_oak")));
        WoodType oak = WoodTypeRegistry.OAK_TYPE;
        if (this.signPostTemplate2 == null) {
            ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(oak)), (int)3).m_126130_("   ").m_126130_("222").m_126130_(" 1 ").m_126127_(Character.valueOf('1'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('2'), (ItemLike)oak.planks).m_126145_("sign_post").m_126132_("has_plank", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{oak.planks})).m_176498_(s -> {
                this.signPostTemplate2 = TemplateRecipeManager.read((JsonObject)s.m_125966_());
            });
        }
        ModRegistry.SIGN_POST_ITEMS.forEach((w, i) -> {
            if (w != oak && i.m_41471_() != null) {
                IRecipeTemplate<?> recipeTemplate = w.getChild("sign") == null ? this.signPostTemplate2 : template;
                FinishedRecipe newR = recipeTemplate.createSimilar((BlockType)WoodTypeRegistry.OAK_TYPE, (BlockType)w, w.mainChild().m_5456_());
                if (newR == null) {
                    return;
                }
                newR = ForgeHelper.addRecipeConditions((FinishedRecipe)newR, (List)template.getConditions());
                ((DynamicDataPack)this.dynamicPack).addRecipe(newR);
            }
        });
    }
}

