/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.WallLanternTexturesRegistry;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientDynamicResourcesHandler
extends DynClientResourcesProvider {
    public static final ClientDynamicResourcesHandler INSTANCE = new ClientDynamicResourcesHandler();

    public ClientDynamicResourcesHandler() {
        super(new DynamicTexturePack(Supplementaries.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).generateDebugResources = PlatformHelper.isDev() || RegistryConfigs.DEBUG_RESOURCES.get() != false;
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return RegistryConfigs.PACK_DEPENDANT_ASSETS.get();
    }

    public void generateStaticAssetsOnStartup(ResourceManager manager) {
        WallLanternTexturesRegistry.reloadTextures(manager);
        StaticResource hsBlockState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(Supplementaries.res("hanging_sign_oak")));
        StaticResource hsModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Supplementaries.res("hanging_signs/hanging_sign_oak")));
        StaticResource hsLoader = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Supplementaries.res("hanging_signs/loader_template")));
        StaticResource hsItemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Supplementaries.res("hanging_sign_oak")));
        ModRegistry.HANGING_SIGNS.forEach((wood, sign) -> {
            String id = Utils.getID((Block)sign).m_135815_();
            try {
                ((DynamicTexturePack)this.dynamicPack).addSimilarJsonResource(hsBlockState, "hanging_sign_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Hanging Sign blockstate definition for {} : {}", (Object)sign, (Object)ex);
            }
            try {
                ((DynamicTexturePack)this.dynamicPack).addSimilarJsonResource(hsModel, "hanging_sign_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Hanging Sign block model for {} : {}", (Object)sign, (Object)ex);
            }
            try {
                ((DynamicTexturePack)this.dynamicPack).addSimilarJsonResource(hsItemModel, "hanging_sign_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Hanging Sign item model for {} : {}", (Object)sign, (Object)ex);
            }
            try {
                ResourceLocation logTexture;
                try {
                    logTexture = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.log, s -> !s.contains("top"));
                }
                catch (Exception e1) {
                    logTexture = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks, s -> true);
                    this.getLogger().error("Could not properly generate Hanging Sign model for {}. Falling back to planks texture : {}", (Object)sign, (Object)e1);
                }
                this.addHangingSignLoaderModel(Objects.requireNonNull(hsLoader), id, logTexture.toString());
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Hanging Sign loader model for {} : {}", (Object)sign, (Object)ex);
            }
        });
        StaticResource spItemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Supplementaries.res("sign_post_oak")));
        ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
            String id = Utils.getID((Item)sign).m_135815_();
            try {
                ((DynamicTexturePack)this.dynamicPack).addSimilarJsonResource(spItemModel, "sign_post_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Sign Post item model for {} : {}", (Object)sign, (Object)ex);
            }
        });
    }

    public void addHangingSignLoaderModel(StaticResource resource, String woodTextPath, String logTexture) {
        String string = new String(resource.data, StandardCharsets.UTF_8);
        string = string.replace("wood_type", woodTextPath);
        string = string.replace("log_texture", logTexture);
        ResourceLocation newRes = Supplementaries.res("hanging_signs/" + woodTextPath + "_loader");
        ((DynamicTexturePack)this.dynamicPack).addBytes(newRes, string.getBytes(), ResType.BLOCK_MODELS);
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        Respriter respriter;
        TextureImage template;
        RPUtils.addCrossbowModel((ResourceManager)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), e -> e.add(new ItemOverride(new ResourceLocation("item/crossbow_rope_arrow"), List.of(new ItemOverride.Predicate(new ResourceLocation("charged"), 1.0f), new ItemOverride.Predicate(Supplementaries.res("rope_arrow"), 1.0f)))));
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("blocks/hanging_signs/hanging_sign_oak"));
            try (TextureImage mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("blocks/hanging_signs/board_mask"));){
                Respriter respriter2 = Respriter.masked((TextureImage)template, (TextureImage)mask);
                ModRegistry.HANGING_SIGNS.forEach((wood, sign) -> {
                    ResourceLocation textureRes = Supplementaries.res("blocks/hanging_signs/" + Utils.getID((Block)sign).m_135815_());
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        List targetPalette = SpriteUtils.extrapolateSignBlockPalette((TextureImage)plankTexture);
                        TextureImage newImage = respriter2.recolorWithAnimation(targetPalette, plankTexture.getMetadata());
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Hanging Sign block texture for for {} : {}", (Object)sign, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Hanging Sign block texture : ", (Throwable)ex);
        }
        try (TextureImage boardTemplate = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("items/hanging_signs/template"));
             TextureImage boardMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("items/hanging_signs/board_mask"));
             TextureImage signMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("items/hanging_signs/sign_board_mask"));){
            Respriter respriter3 = Respriter.masked((TextureImage)boardTemplate, (TextureImage)boardMask);
            ModRegistry.HANGING_SIGNS.forEach((wood, sign) -> {
                Palette targetPalette;
                ResourceLocation textureRes = Supplementaries.res("items/hanging_signs/" + Utils.getID((Block)sign).m_135815_());
                if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                    return;
                }
                TextureImage newImage = null;
                Item vanillaSign = wood.getItemOfThis("sign");
                if (vanillaSign != null) {
                    try (TextureImage vanillaSignTexture2 = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)vanillaSign));){
                        targetPalette = Palette.fromImage((TextureImage)vanillaSignTexture2, (TextureImage)signMask);
                        newImage = respriter3.recolor(targetPalette);
                        try (TextureImage scribbles = ClientDynamicResourcesHandler.recolorFromVanilla(manager, vanillaSignTexture2, Supplementaries.res("items/hanging_signs/sign_scribbles_mask"), Supplementaries.res("items/hanging_signs/scribbles_template"));){
                            newImage.applyOverlay(new TextureImage[]{scribbles});
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Could not properly color Hanging Sign texture for {} : {}", (Object)sign, (Object)ex);
                        }
                        try (TextureImage stick = ClientDynamicResourcesHandler.recolorFromVanilla(manager, vanillaSignTexture2, Supplementaries.res("items/hanging_signs/sign_stick_mask"), Supplementaries.res("items/hanging_signs/stick_template"));){
                            newImage.applyOverlay(new TextureImage[]{stick});
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Could not properly color Hanging Sign item texture for {} : {}", (Object)sign, (Object)ex);
                        }
                    }
                    catch (Exception vanillaSignTexture2) {
                        // empty catch block
                    }
                }
                if (newImage == null) {
                    try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                        newImage = respriter3.recolor(targetPalette);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Hanging Sign item texture for for {} : {}", (Object)sign, (Object)ex);
                    }
                }
                if (newImage != null) {
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                }
            });
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Hanging Sign item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("items/sign_posts/template"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
                    ResourceLocation textureRes = Supplementaries.res("items/sign_posts/" + Utils.getID((Item)sign).m_135815_());
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    TextureImage newImage = null;
                    Item signItem = wood.getItemOfThis("sign");
                    if (signItem != null) {
                        try (TextureImage vanillaSign2 = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)signItem));
                             TextureImage signMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("items/hanging_signs/sign_board_mask"));){
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign2, (TextureImage)signMask);
                            newImage = respriter.recolor(targetPalette);
                            try (TextureImage scribbles = ClientDynamicResourcesHandler.recolorFromVanilla(manager, vanillaSign2, Supplementaries.res("items/hanging_signs/sign_scribbles_mask"), Supplementaries.res("items/sign_posts/scribbles_template"));){
                                newImage.applyOverlay(new TextureImage[]{scribbles});
                            }
                            catch (Exception ex) {
                                this.getLogger().error("Could not properly color Sign Post item texture for {} : {}", (Object)sign, (Object)ex);
                            }
                        }
                        catch (Exception vanillaSign2) {
                            // empty catch block
                        }
                    }
                    if (newImage == null) {
                        try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                            Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to generate Sign Post item texture for for {} : {}", (Object)sign, (Object)ex);
                        }
                    }
                    if (newImage != null) {
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("entity/sign_posts/sign_post_oak"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
                    ResourceLocation textureRes = Supplementaries.res("entity/sign_posts/" + Utils.getID((Item)sign).m_135815_());
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        Palette palette = Palette.fromImage((TextureImage)plankTexture);
                        TextureImage newImage = respriter.recolor(palette);
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Sign Post block texture for for {} : {}", (Object)sign, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post block texture : ", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static TextureImage recolorFromVanilla(ResourceManager manager, TextureImage vanillaTexture, ResourceLocation vanillaMask, ResourceLocation templateTexture) {
        try (TextureImage scribbleMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)vanillaMask);){
            TextureImage textureImage;
            block14: {
                TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)templateTexture);
                try {
                    Respriter respriter = Respriter.of((TextureImage)template);
                    Palette palette = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)scribbleMask);
                    textureImage = respriter.recolor(palette);
                    if (template == null) break block14;
                }
                catch (Throwable throwable) {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                template.close();
            }
            return textureImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        ModRegistry.HANGING_SIGNS.forEach((type, block) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"block.supplementaries.hanging_sign", (BlockType)type, (Block)block));
        ModRegistry.SIGN_POST_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.sign_post", (BlockType)type, (Item)item));
    }
}

