/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.songs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.world.songs.Song;
import net.mehvahdjukaar.supplementaries.common.world.songs.SongsManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class FluteSongsReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final FluteSongsReloadListener RELOAD_INSTANCE = new FluteSongsReloadListener();

    public FluteSongsReloadListener() {
        super(GSON, "flute_songs");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller profile) {
        ArrayList temp = new ArrayList();
        jsons.forEach((key, input) -> {
            try {
                Song song = (Song)GSON.fromJson(input, Song.class);
                if (song.getNotes().length == 0) {
                    Supplementaries.LOGGER.error("Failed to parse JSON object for song " + key + ": a song can't have 0 notes!");
                } else {
                    temp.add(song);
                    SongsManager.addSong(key, song);
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for song " + key);
            }
        });
        if (temp.size() != 0) {
            Supplementaries.LOGGER.info("Loaded  " + temp.size() + " flute songs");
        }
        temp.forEach(Song::processForPlaying);
    }

    public static void saveRecordedSong(Song song) {
        File folder = PlatformHelper.getGamePath().resolve("recorded_songs").toFile();
        if (!folder.exists()) {
            folder.mkdir();
        }
        File exportPath = new File(folder, song.getTranslationKey() + ".json");
        try (FileWriter writer = new FileWriter(exportPath);){
            GSON.toJson((Object)song, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

