/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.explosion;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.mehvahdjukaar.supplementaries.ForgeHelper;
import net.mehvahdjukaar.supplementaries.api.ILightable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BellowsBlock;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.DecoBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class GunpowderExplosion
extends Explosion {
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    private float radius;
    private final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();

    public GunpowderExplosion(Level world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, null, null, x, y, z, size, false, Explosion.BlockInteraction.DESTROY);
        this.level = world;
        this.radius = size;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void m_46061_() {
        int x = Mth.m_14107_((double)this.x);
        int y = Mth.m_14107_((double)this.y);
        int z = Mth.m_14107_((double)this.z);
        this.radius *= 2.0f;
        ForgeHelper.onExplosionDetonate(this.level, this, new ArrayList<Entity>(), this.radius);
        this.explodeBlock(x + 1, y, z);
        this.explodeBlock(x - 1, y, z);
        this.explodeBlock(x, y + 1, z);
        this.explodeBlock(x, y - 1, z);
        this.explodeBlock(x, y, z + 1);
        this.explodeBlock(x, y, z - 1);
        BlockPos pos = new BlockPos(x, y, z);
        BlockState newFire = BaseFireBlock.m_49245_((BlockGetter)this.level, (BlockPos)pos);
        BlockState s = this.level.m_8055_(pos);
        if ((s.m_60767_().m_76336_() || s.m_60713_(ModRegistry.GUNPOWDER_BLOCK.get())) && (this.hasFlammableNeighbours(pos) || ForgeHelper.isFireSource(this.level.m_8055_(pos.m_7495_()), this.level, pos, Direction.UP) || newFire.m_60734_() != Blocks.f_50083_)) {
            this.level.m_46597_(pos, newFire);
        }
    }

    private boolean hasFlammableNeighbours(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockState state = this.level.m_8055_(pos.m_121945_(direction));
            if (!state.m_60767_().m_76335_() && (state.m_60734_() != ModRegistry.BELLOWS.get() || (Integer)state.m_61143_((Property)BellowsBlock.POWER) == 0 || state.m_61143_((Property)BellowsBlock.FACING) != direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private void explodeBlock(int i, int j, int k) {
        BlockPos pos = new BlockPos(i, j, k);
        FluidState fluidstate = this.level.m_6425_(pos);
        if (fluidstate.m_76152_() == Fluids.f_76191_) {
            BlockState state = this.level.m_8055_(pos);
            Block block = state.m_60734_();
            if (ForgeHelper.getExplosionResistance(state, this.level, pos, this) == 0.0f && block instanceof TntBlock) {
                this.toBlow.add((Object)pos);
            }
            if (block instanceof ILightable) {
                ILightable lightable = (ILightable)block;
                lightable.lightUp(null, state, pos, (LevelAccessor)this.level, ILightable.FireSound.FLAMING_ARROW);
            } else if (state.m_204336_(BlockTags.f_13087_) && CampfireBlock.m_51321_((BlockState)state) || state.m_60734_() instanceof AbstractCandleBlock && !AbstractCandleBlock.m_151933_((BlockState)state) || CompatHandler.deco_blocks && DecoBlocksCompat.canLightBrazier(state)) {
                this.level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                ILightable.FireSound.FLAMING_ARROW.play((LevelAccessor)this.level, pos);
            }
        }
    }

    public void m_46075_(boolean spawnFire) {
        BlockPos pos;
        ObjectArrayList drops = new ObjectArrayList();
        Util.m_214673_(this.toBlow, (RandomSource)this.level.f_46441_);
        for (BlockPos blockpos : this.toBlow) {
            BlockState blockstate = this.level.m_8055_(blockpos);
            BlockPos immutable = blockpos.m_7949_();
            this.level.m_46473_().m_6180_("explosion_blocks");
            if (ForgeHelper.canDropFromExplosion(blockstate, this.level, blockpos, this) && this.level instanceof ServerLevel) {
                BlockEntity blockEntity = blockstate.m_155947_() ? this.level.m_7702_(blockpos) : null;
                LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.level).m_230911_(this.level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)blockEntity).m_78984_(LootContextParams.f_81455_, null);
                builder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius));
                blockstate.m_60724_(builder).forEach(d -> this.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)drops, (ItemStack)d, immutable));
            }
            ForgeHelper.onBlockExploded(blockstate, this.level, blockpos, this);
            this.level.m_46473_().m_7238_();
        }
        for (Pair pair : drops) {
            Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
        if (spawnFire && this.level.m_8055_(pos = new BlockPos(this.x, this.y, this.z)).m_60795_() && this.level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)this.level, pos.m_7495_())) {
            this.level.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)this.level, (BlockPos)pos));
        }
    }

    private void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> drops, ItemStack stack, BlockPos pos) {
        int i = drops.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)drops.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)stack)) continue;
            ItemStack merge = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)stack, (int)16);
            drops.set(j, (Object)Pair.of((Object)merge, (Object)((BlockPos)pair.getSecond())));
            if (!stack.m_41619_()) continue;
            return;
        }
        drops.add((Object)Pair.of((Object)stack, (Object)pos));
    }
}

