/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.data.map.markers;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.supplementaries.common.world.data.map.CMDreg;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BedMarker
extends MapBlockMarker<CustomMapDecoration> {
    private DyeColor color;

    public BedMarker() {
        super(CMDreg.BED_DECORATION_TYPE);
    }

    public BedMarker(BlockPos pos, DyeColor color) {
        super(CMDreg.BED_DECORATION_TYPE, pos);
        this.color = color;
    }

    public CompoundTag saveToNBT(CompoundTag compoundnbt) {
        super.saveToNBT(compoundnbt);
        compoundnbt.m_128359_("Color", this.color.m_41065_());
        return compoundnbt;
    }

    public void loadFromNBT(CompoundTag compound) {
        super.loadFromNBT(compound);
        this.color = DyeColor.m_41057_((String)compound.m_128461_("Color"), (DyeColor)DyeColor.WHITE);
    }

    @Nullable
    public static BedMarker getFromWorld(BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BedBlockEntity) {
            BedBlockEntity tile = (BedBlockEntity)blockEntity;
            DyeColor dyecolor = tile.m_58731_();
            return new BedMarker(pos, dyecolor);
        }
        return null;
    }

    @Nullable
    public CustomMapDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new CustomMapDecoration(this.getType(), mapX, mapY, rot, null);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && ((Object)((Object)this)).getClass() == other.getClass()) {
            BedMarker marker = (BedMarker)((Object)other);
            return Objects.equals(this.getPos(), marker.getPos()) && this.color == marker.color;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPos(), this.color);
    }
}

