/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.api.AdditionalPlacement;
import net.mehvahdjukaar.supplementaries.api.IExtendedItem;
import net.mehvahdjukaar.supplementaries.common.block.tiles.KeyLockableTile;
import net.mehvahdjukaar.supplementaries.common.items.additional_behaviors.SimplePlacement;
import net.mehvahdjukaar.supplementaries.common.utils.forge.ItemsUtilImpl;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ItemsUtil {
    @Nullable
    public static BlockState getPlacementState(BlockPlaceContext context, Block block) {
        return ModRegistry.BLOCK_PLACER.get().mimicGetPlacementState(context, block);
    }

    public static InteractionResult place(BlockPlaceContext context, Block blockToPlace) {
        return ItemsUtil.place(context, blockToPlace, null);
    }

    public static InteractionResult place(BlockPlaceContext context, Block blockToPlace, @Nullable SoundType placeSound) {
        return ModRegistry.BLOCK_PLACER.get().mimicPlace(context, blockToPlace, placeSound);
    }

    public static InteractionResult place(Item item, BlockPlaceContext pContext) {
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            return bi.m_40576_(pContext);
        }
        AdditionalPlacement additionalPlacement = ((IExtendedItem)item).getAdditionalBehavior();
        if (additionalPlacement instanceof SimplePlacement) {
            SimplePlacement si = (SimplePlacement)additionalPlacement;
            return si.overridePlace(pContext);
        }
        return InteractionResult.PASS;
    }

    public static boolean tryInteractingWithContainerItem(ItemStack containerStack, ItemStack incoming, Slot slot, ClickAction action, Player player, boolean inSlot) {
        if (action != ClickAction.PRIMARY) {
            if (incoming.m_41619_()) {
                if (!inSlot) {
                    return ItemsUtil.extractFromContainerItemIntoSlot(player, containerStack, slot);
                }
            } else if (ItemsUtil.addToContainerItem(player, containerStack, incoming, slot, true, inSlot)) {
                return ItemsUtil.addToContainerItem(player, containerStack, incoming, slot, false, inSlot);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean addToContainerItem(Player player, ItemStack containerStack, ItemStack stack, Slot slot, boolean simulate, boolean inSlot) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.addToContainerItem(player, (ItemStack)var1_1, (ItemStack)var2_2, (Slot)var3_3, (boolean)var4_4, (boolean)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean extractFromContainerItemIntoSlot(Player player, ItemStack containerStack, Slot slot) {
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.extractFromContainerItemIntoSlot(player, (ItemStack)var1_1, (Slot)var2_2);
    }

    @Nullable
    public static BlockEntity loadBlockEntityFromItem(CompoundTag tag, Item item) {
        BlockItem blockItem;
        Block block;
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            BlockEntity te = entityBlock.m_142194_(BlockPos.f_121853_, block.m_49966_());
            if (te != null) {
                te.m_142466_(tag);
            }
            return te;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getAllSacksInInventory(ItemStack stack, ServerPlayer player, int amount) {
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.getAllSacksInInventory(stack, (ServerPlayer)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static KeyLockableTile.KeyStatus hasKeyInInventory(Player player, String key) {
        void var1_1;
        return ItemsUtilImpl.hasKeyInInventory(player, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean faucetSpillItems(Level level, BlockPos pos, Direction dir, BlockEntity tile) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.faucetSpillItems(level, (BlockPos)var1_1, (Direction)var2_2, (BlockEntity)var3_3);
    }

    public record InventoryTooltip(CompoundTag tag, Item item, int size) implements TooltipComponent
    {
    }
}

