/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.mojang.authlib.GameProfile;
import java.util.Calendar;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.ForgeHelper;
import net.mehvahdjukaar.supplementaries.client.ClientAccess;
import net.mehvahdjukaar.supplementaries.common.block.blocks.LightableLanternBlock;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CommonUtil {
    public static Festivity FESTIVITY = Festivity.get();
    private static final ShulkerBoxBlockEntity SHULKER_TILE = new ShulkerBoxBlockEntity(BlockPos.f_121853_, Blocks.f_50456_.m_49966_());
    public static final GameProfile DUMMY_PROFILE = new GameProfile(UUID.fromString("9bf808b4-d64a-47f0-9220-e3849f80f35b"), "[player_stando]");

    public static boolean isLanternBlock(Block b2) {
        String namespace = Utils.getID((Block)b2).m_135827_();
        if (namespace.equals("skinnedlanterns")) {
            return true;
        }
        if (b2 instanceof LanternBlock) {
            return !b2.m_49966_().m_155947_() || b2 instanceof LightableLanternBlock;
        }
        return false;
    }

    public static boolean isSword(Item i) {
        if (i.m_204114_().m_203656_(ModTags.STATUE_SWORDS)) {
            return true;
        }
        return i instanceof SwordItem;
    }

    public static boolean isTool(Item i) {
        if (i.m_204114_().m_203656_(ModTags.STATUE_TOOLS)) {
            return true;
        }
        return i instanceof DiggerItem || i instanceof TridentItem;
    }

    public static boolean isLantern(Item i) {
        if (i instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)i;
            Block b2 = blockItem.m_40614_();
            String namespace = Utils.getID((Block)b2).m_135827_();
            if (namespace.equals("skinnedlanterns")) {
                return true;
            }
            if (b2 instanceof LanternBlock && !CommonConfigs.Tweaks.WALL_LANTERN_BLACKLIST.get().contains(namespace)) {
                return !b2.m_49966_().m_155947_() || b2 instanceof LightableLanternBlock;
            }
        }
        return false;
    }

    public static boolean isCookie(Item i) {
        return i.m_204114_().m_203656_(ModTags.COOKIES);
    }

    public static boolean isBrick(Item i) {
        return i.m_204114_().m_203656_(ModTags.BRICKS);
    }

    public static boolean isCake(Item i) {
        return i == Items.f_42502_;
    }

    public static boolean isPot(Item i) {
        if (i instanceof BlockItem) {
            Block b2 = ((BlockItem)i).m_40614_();
            return b2 instanceof FlowerPotBlock;
        }
        return false;
    }

    public static AABB getDirectionBB(BlockPos pos, Direction facing, int offset) {
        BlockPos endPos = pos.m_5484_(facing, offset);
        switch (facing) {
            case NORTH: {
                endPos = endPos.m_7918_(1, 1, 0);
                break;
            }
            case SOUTH: {
                endPos = endPos.m_7918_(1, 1, 1);
                pos = pos.m_7918_(0, 0, 1);
                break;
            }
            case UP: {
                endPos = endPos.m_7918_(1, 1, 1);
                pos = pos.m_7918_(0, 1, 0);
                break;
            }
            case EAST: {
                endPos = endPos.m_7918_(1, 1, 1);
                pos = pos.m_7918_(1, 0, 0);
                break;
            }
            case WEST: {
                endPos = endPos.m_7918_(0, 1, 1);
                break;
            }
            case DOWN: {
                endPos = endPos.m_7918_(1, 0, 1);
            }
        }
        return new AABB(pos, endPos);
    }

    public static boolean isAllowedInShulker(ItemStack stack) {
        return SHULKER_TILE.m_7155_(0, stack, null);
    }

    public static boolean withinDistanceDown(BlockPos pos, Vec3 vector, double distW, double distDown) {
        double dx = vector.m_7096_() - ((double)pos.m_123341_() + 0.5);
        double dy = vector.m_7098_() - ((double)pos.m_123342_() + 0.5);
        double dz = vector.m_7094_() - ((double)pos.m_123343_() + 0.5);
        double mydistW = dx * dx + dz * dz;
        return mydistW < distW * distW && dy < distW && dy > -distDown;
    }

    public static HitResult rayTrace(LivingEntity entity, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return CommonUtil.rayTrace((Entity)entity, world, blockMode, fluidMode, ForgeHelper.getReachDistance(entity));
    }

    public static HitResult rayTrace(Entity entity, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, double range) {
        Vec3 startPos = entity.m_146892_();
        Vec3 ray = entity.m_20252_(1.0f).m_82490_(range);
        Vec3 endPos = startPos.m_82549_(ray);
        ClipContext context = new ClipContext(startPos, endPos, blockMode, fluidMode, entity);
        return world.m_45547_(context);
    }

    public static Player getEntityStand(Entity copyFrom) {
        return CommonUtil.getEntityStand(copyFrom, copyFrom);
    }

    public static Player getEntityStand(Entity copyPosFrom, Entity copyRotFrom) {
        Level level = copyPosFrom.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return null;
        }
        Player p = ClientAccess.getFakeClientPlayer(level, DUMMY_PROFILE);
        p.m_6034_(copyPosFrom.m_20185_(), copyPosFrom.m_20186_(), copyPosFrom.m_20189_());
        p.m_5616_(copyRotFrom.m_6080_());
        p.m_146926_(copyRotFrom.m_146909_());
        p.m_146922_(copyRotFrom.m_146908_());
        p.m_146867_();
        return p;
    }

    public static enum Festivity {
        NONE,
        HALLOWEEN,
        APRILS_FOOL,
        CHRISTMAS,
        EARTH_DAY,
        ST_VALENTINE,
        MY_BIRTHDAY,
        MOD_BIRTHDAY;


        public boolean isHalloween() {
            return this == HALLOWEEN;
        }

        public boolean isAprilsFool() {
            return this == APRILS_FOOL;
        }

        public boolean isStValentine() {
            return this == ST_VALENTINE;
        }

        public boolean isChristmas() {
            return this == CHRISTMAS;
        }

        public boolean isEarthDay() {
            return this == EARTH_DAY;
        }

        public boolean isBirthday() {
            return this == MOD_BIRTHDAY || this == MY_BIRTHDAY;
        }

        public int getCandyWrappingIndex() {
            return switch (this) {
                default -> 0;
                case HALLOWEEN -> 1;
                case CHRISTMAS -> 2;
            };
        }

        private static Festivity get() {
            Calendar calendar = Calendar.getInstance();
            int month = calendar.get(2);
            int date = calendar.get(5);
            if (month == 9 && date >= 29 || month == 10 && date <= 1) {
                return HALLOWEEN;
            }
            if (month == 3 && date == 1) {
                return APRILS_FOOL;
            }
            if (month == 1 && date == 14) {
                return ST_VALENTINE;
            }
            if (month == 3 && date == 22) {
                return EARTH_DAY;
            }
            if (month == 11 && date >= 23 && date <= 27) {
                return CHRISTMAS;
            }
            if (month == 1 && date == 7) {
                return MY_BIRTHDAY;
            }
            if (month == 9 && date == 9) {
                return MOD_BIRTHDAY;
            }
            return NONE;
        }
    }
}

