/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ServerBoundSetTextHolderPacket
implements Message {
    private final BlockPos pos;
    public final Component[] signText;
    public final int size;

    public ServerBoundSetTextHolderPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.size = buf.readInt();
        this.signText = new Component[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.signText[i] = buf.m_130238_();
        }
    }

    public ServerBoundSetTextHolderPacket(BlockPos pos, TextHolder textHolder) {
        this.pos = pos;
        this.size = textHolder.size();
        this.signText = textHolder.getSignText();
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            buf.m_130083_(this.signText[i]);
        }
    }

    public void handle(ChannelHandler.Context context) {
        Level world = Objects.requireNonNull(context.getSender()).f_19853_;
        BlockPos pos = this.pos;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ITextHolderProvider) {
            ITextHolderProvider te = (ITextHolderProvider)tile;
            if (te.getTextHolder().size() == this.size) {
                for (int i = 0; i < this.size; ++i) {
                    te.getTextHolder().setLine(i, this.signText[i]);
                }
            }
            BlockState state = world.m_8055_(pos);
            world.m_7260_(pos, state, state, 3);
            tile.m_6596_();
        }
    }
}

