/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.world.songs.Song;
import net.mehvahdjukaar.supplementaries.common.world.songs.SongsManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ClientBoundSyncSongsPacket
implements Message {
    protected final Map<ResourceLocation, Song> songs;

    public ClientBoundSyncSongsPacket(Map<ResourceLocation, Song> songs) {
        this.songs = songs;
    }

    public ClientBoundSyncSongsPacket(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.songs = new HashMap<ResourceLocation, Song>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation name = buf.m_130281_();
            CompoundTag tag = buf.m_130260_();
            if (tag == null) continue;
            Song song = Song.loadFromTag(tag);
            this.songs.put(name, song);
        }
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeInt(this.songs.size());
        for (Map.Entry<ResourceLocation, Song> entry : this.songs.entrySet()) {
            buf.m_130085_(entry.getKey());
            buf.m_130079_(Song.saveToTag(entry.getValue()));
        }
    }

    public void handle(ChannelHandler.Context context) {
        SongsManager.clearSongs();
        this.songs.keySet().forEach(k -> {
            Song s = this.songs.get(k);
            s.processForPlaying();
            SongsManager.addSong(k, s);
        });
    }
}

