/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import java.util.Optional;
import net.mehvahdjukaar.supplementaries.ForgeHelper;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class BlackboardDuplicateRecipe
extends CustomRecipe {
    public BlackboardDuplicateRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    private boolean isDrawnBlackboard(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        return tag != null && tag.m_128441_("Pixels");
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack itemstack = null;
        ItemStack itemstack1 = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Item item = stack.m_41720_();
            if (item == ModRegistry.BLACKBOARD_ITEM.get()) {
                if (this.isDrawnBlackboard(stack)) {
                    if (itemstack != null) {
                        return false;
                    }
                    itemstack = stack;
                    continue;
                }
                if (itemstack1 != null) {
                    return false;
                }
                itemstack1 = stack;
                continue;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return itemstack != null && itemstack1 != null;
    }

    public ItemStack assemble(CraftingContainer inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!this.isDrawnBlackboard(stack)) continue;
            ItemStack s = stack.m_41777_();
            s.m_41764_(1);
            return s;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList stacks = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            Optional<ItemStack> container = ForgeHelper.getCraftingRemainingItem(itemstack);
            if (container.isPresent()) {
                stacks.set(i, (Object)container.get());
                continue;
            }
            if (!itemstack.m_41782_() || !this.isDrawnBlackboard(itemstack)) continue;
            ItemStack copy = itemstack.m_41777_();
            copy.m_41764_(1);
            stacks.set(i, (Object)copy);
        }
        return stacks;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.BLACKBOARD_DUPLICATE_RECIPE.get();
    }
}

