/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.ForgeHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.capabilities.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.capabilities.mob_container.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.common.capabilities.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractMobContainerItem
extends BlockItem {
    private final float mobContainerHeight;
    private final float mobContainerWidth;
    private final boolean isAquarium;

    public AbstractMobContainerItem(Block block, Item.Properties properties, float width, float height, boolean aquarium) {
        super(block, properties);
        this.mobContainerWidth = width;
        this.mobContainerHeight = height;
        this.isAquarium = aquarium;
    }

    public float getMobContainerHeight() {
        return this.mobContainerHeight;
    }

    public float getMobContainerWidth() {
        return this.mobContainerWidth;
    }

    protected boolean canFitEntity(Entity e) {
        float margin = 0.125f;
        float h = e.m_20206_() - margin;
        float w = e.m_20205_() - margin;
        return w < this.mobContainerWidth && h < this.mobContainerHeight;
    }

    public void playCatchSound(Player player) {
    }

    public void playFailSound(Player player) {
    }

    public void playReleaseSound(Level world, Vec3 v) {
    }

    @PlatformOnly(value={"forge"})
    public int getMaxStackSize(ItemStack stack) {
        return this.isFull(stack) ? 1 : 64;
    }

    public boolean isFull(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("BlockEntityTag");
    }

    @PlatformOnly(value={"forge"})
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (this.isFull(stack)) {
            return false;
        }
        InteractionHand hand = player.m_7655_();
        if (hand == InteractionHand.OFF_HAND) {
            return false;
        }
        return this.doInteract(stack, player, entity, player.m_7655_()).m_19077_();
    }

    protected final boolean isEntityValid(Entity e, Player player) {
        if (!e.m_6084_() || ForgeHelper.isMultipartEntity(e) || e instanceof Player) {
            return false;
        }
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            if (living.m_21224_()) {
                return false;
            }
            if (e instanceof TamableAnimal) {
                TamableAnimal pet = (TamableAnimal)e;
                return !pet.m_21824_() || pet.m_21830_((LivingEntity)player);
            }
            int p = CommonConfigs.Blocks.CAGE_HEALTH_THRESHOLD.get();
            if (p != 100) {
                return living.m_21223_() <= living.m_21233_() * ((float)p / 100.0f);
            }
        }
        return true;
    }

    private <T extends Entity> boolean canCatch(T e) {
        String name = Utils.getID((EntityType)e.m_6095_()).toString();
        if (name.contains("alexmobs") && name.contains("centipede")) {
            return false;
        }
        if (CommonConfigs.Blocks.CAGE_ALL_MOBS.get().booleanValue() || CapturedMobsHelper.COMMAND_MOBS.contains(name)) {
            return true;
        }
        ICatchableMob cap = MobContainer.getCap(e);
        return cap.canBeCaughtWithItem((Item)this);
    }

    public abstract boolean canItemCatch(Entity var1);

    public ItemStack saveEntityInItem(Entity entity, ItemStack currentStack, ItemStack bucketStack) {
        CompoundTag cmp;
        ItemStack returnStack = new ItemStack((ItemLike)this);
        if (currentStack.m_41788_()) {
            returnStack.m_41714_(currentStack.m_41786_());
        }
        if ((cmp = MobContainer.createMobHolderItemTag(entity, this.getMobContainerWidth(), this.getMobContainerHeight(), bucketStack, this.isAquarium)) != null) {
            returnStack.m_41700_("BlockEntityTag", (Tag)cmp);
        }
        return returnStack;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        CompoundTag com = stack.m_41737_("BlockEntityTag");
        Player player = context.m_43723_();
        if (!context.m_43723_().m_6144_() && com != null) {
            CompoundTag nbt;
            Entity entity;
            boolean success = false;
            Level world = context.m_43725_();
            Vec3 v = context.m_43720_();
            if (com.m_128441_("BucketHolder")) {
                ItemStack bucketStack = ItemStack.m_41712_((CompoundTag)com.m_128469_("BucketHolder").m_128469_("Bucket"));
                if (bucketStack.m_41720_() instanceof BucketItem) {
                    ((BucketItem)bucketStack.m_41720_()).m_142131_(player, world, bucketStack, context.m_8083_());
                    success = true;
                }
            } else if (com.m_128441_("MobHolder") && (entity = EntityType.m_20645_((CompoundTag)(nbt = com.m_128469_("MobHolder")).m_128469_("EntityData"), (Level)world, o -> o)) != null) {
                success = true;
                if (!world.f_46443_) {
                    if (!player.m_7500_() && entity instanceof NeutralMob) {
                        NeutralMob ang = (NeutralMob)entity;
                        ang.m_21661_();
                        ang.m_6925_(player.m_20148_());
                        ang.m_6703_((LivingEntity)player);
                    }
                    entity.m_19890_(v.m_7096_(), v.m_7098_(), v.m_7094_(), context.m_7074_(), 0.0f);
                    if (CommonConfigs.Blocks.CAGE_PERSISTENT_MOBS.get().booleanValue() && entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        mob.m_21530_();
                    }
                    UUID temp = entity.m_20148_();
                    if (nbt.m_128441_("UUID")) {
                        UUID id = nbt.m_128342_("UUID");
                        entity.m_20084_(id);
                    }
                    if (!world.m_7967_(entity)) {
                        entity.m_20084_(temp);
                        success = world.m_7967_(entity);
                        if (!success) {
                            Supplementaries.LOGGER.warn("Failed to release caged mob");
                        }
                    }
                }
                if (player.m_7500_() && nbt.m_128441_("UUID")) {
                    nbt.m_128362_("UUID", Mth.m_216261_((RandomSource)world.f_46441_));
                }
            }
            if (success) {
                if (!world.f_46443_) {
                    this.playReleaseSound(world, v);
                    if (!player.m_7500_()) {
                        ItemStack returnItem = new ItemStack((ItemLike)this);
                        if (stack.m_41788_()) {
                            returnItem.m_41714_(stack.m_41786_());
                        }
                        Utils.swapItemNBT((Player)player, (InteractionHand)context.m_43724_(), (ItemStack)stack, (ItemStack)returnItem);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        }
        return super.m_6225_(context);
    }

    public boolean blocksPlacement() {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            CompoundTag com = tag.m_128469_("MobHolder");
            if (com.m_128456_()) {
                com = tag.m_128469_("BucketHolder");
            }
            if (com.m_128441_("Name")) {
                tooltip.add((Component)Component.m_237115_((String)com.m_128461_("Name")).m_130940_(ChatFormatting.GRAY));
            }
        }
        this.addPlacementTooltip(tooltip);
    }

    public void addPlacementTooltip(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"message.supplementaries.cage").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
    }

    private void angerNearbyEntities(Entity entity, Player player) {
        if (entity instanceof NeutralMob && entity instanceof Mob) {
            AbstractMobContainerItem.getEntitiesInRange((Mob)entity).stream().filter(mob -> mob != entity).map(mob -> (NeutralMob)mob).forEach(mob -> {
                mob.m_21661_();
                mob.m_6925_(player.m_20148_());
                mob.m_6703_((LivingEntity)player);
            });
        }
        if (entity instanceof Piglin) {
            entity.m_6469_(DamageSource.m_19344_((Player)player), 0.0f);
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            Level level = player.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Optional optional = villager.m_6274_().m_21952_(MemoryModuleType.f_148205_);
                optional.ifPresent(entities -> entities.m_186123_(ReputationEventHandler.class::isInstance).forEach(e -> serverLevel.m_8670_(ReputationEventType.f_26987_, (Entity)player, (ReputationEventHandler)e)));
            }
        }
    }

    private static List<?> getEntitiesInRange(Mob e) {
        double d0 = e.m_21133_(Attributes.f_22277_);
        AABB aabb = AABB.m_82333_((Vec3)e.m_20182_()).m_82377_(d0, 10.0, d0);
        return e.f_19853_.m_6443_(e.getClass(), aabb, EntitySelector.f_20408_);
    }

    public InteractionResult doInteract(ItemStack stack, Player player, Entity entity, InteractionHand hand) {
        if (hand == null) {
            return InteractionResult.PASS;
        }
        if (this.isEntityValid(entity, player)) {
            ItemStack bucket = ItemStack.f_41583_;
            boolean canCatch = this.canCatch(entity);
            if (this.isAquarium || canCatch) {
                if (entity instanceof Bucketable) {
                    Bucketable bucketable = (Bucketable)entity;
                    bucket = bucketable.m_28282_();
                } else if (entity instanceof WaterAnimal) {
                    bucket = this.tryGettingFishBucketHackery(player, entity, hand);
                }
            }
            if (bucket == null || bucket.m_41619_()) {
                bucket = ItemStack.f_41583_;
            } else {
                BucketHelper.associateMobToBucketIfAbsent(entity.m_6095_(), bucket.m_41720_());
            }
            if (!bucket.m_41619_() || canCatch) {
                Mob mob;
                ForgeHelper.reviveEntity(entity);
                if (player.f_19853_.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                this.playCatchSound(player);
                this.angerNearbyEntities(entity, player);
                if (CommonConfigs.Blocks.CAGE_PERSISTENT_MOBS.get().booleanValue() && entity instanceof Mob) {
                    mob = (Mob)entity;
                    mob.m_21530_();
                }
                if (entity instanceof Mob) {
                    mob = (Mob)entity;
                    mob.m_21455_(true, !player.m_150110_().f_35937_);
                }
                Utils.swapItemNBT((Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)this.saveEntityInItem(entity, stack, bucket));
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                return InteractionResult.CONSUME;
            }
            if (player.m_9236_().f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"message.supplementaries.cage.fail"), true);
            }
        }
        this.playFailSound(player);
        return InteractionResult.PASS;
    }

    private ItemStack tryGettingFishBucketHackery(Player player, Entity entity, InteractionHand hand) {
        ItemStack filledBucket;
        ItemStack heldItem = player.m_21120_(hand).m_41777_();
        ItemStack bucket = ItemStack.f_41583_;
        player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42447_));
        InteractionResult result = entity.m_6096_(player, hand);
        if (!result.m_19077_()) {
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
            result = entity.m_6096_(player, hand);
        }
        if (result.m_19077_() && (filledBucket = player.m_21120_(hand)) != heldItem && !entity.m_6084_()) {
            bucket = filledBucket;
        }
        player.m_21008_(hand, heldItem);
        player.m_6672_(hand);
        return bucket;
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        if (player != null && !player.m_6144_() && this.blocksPlacement()) {
            return InteractionResult.PASS;
        }
        return super.m_40576_(context);
    }
}

