/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.misc.ModItemListing;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapsHandler;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class VillagerTradesHandler {
    private static final float BUY = 0.05f;
    private static final float SELL = 0.2f;
    private static VillagerTrades.ItemListing[] RED_MERCHANT_TRADES = null;
    private static VillagerTrades.ItemListing[] CHRISTMAS_SALES = null;
    private static final DyeColor[] VIBRANT_COLORS = new DyeColor[]{DyeColor.WHITE, DyeColor.ORANGE, DyeColor.MAGENTA, DyeColor.LIGHT_BLUE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.PINK, DyeColor.CYAN, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.GREEN, DyeColor.RED};

    private static void makeRedMerchantTrades() {
        ArrayList<Object> trades = new ArrayList<Object>();
        if (RegistryConfigs.ROPE_ENABLED.get().booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.ROPE.get(), 4, 1, 10));
        }
        trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)Items.f_42403_, 2, 1, 8));
        if (RegistryConfigs.COPPER_LANTERN_ENABLED.get().booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.COPPER_LANTERN.get(), 1, 1, 12));
        }
        if (RegistryConfigs.BOMB_ENABLED.get().booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.BOMB_ITEM.get(), 1, 3, 8));
            if (CompatHandler.oreganized) {
                trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.BOMB_SPIKY_ITEM.get(), 1, 4, 8));
            }
        }
        trades.add(new StarForEmeraldTrade(2, 8));
        trades.add(new RocketForEmeraldTrade(3, 1, 3, 8));
        trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)Items.f_41996_, 1, 4, 8));
        if (RegistryConfigs.ROPE_ARROW_ENABLED.get().booleanValue()) {
            Item i = ModRegistry.ROPE_ARROW_ITEM.get();
            ItemStack stack = new ItemStack((ItemLike)i);
            stack.m_41721_(Math.max(0, stack.m_41776_() - 16));
            trades.add(VillagerTradesHandler.itemForEmeraldTrade(stack, 4, 6));
        }
        if (RegistryConfigs.BOMB_ENABLED.get().booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.BOMB_BLUE_ITEM.get(), 1, (ItemLike)ModRegistry.BOMB_ITEM.get(), 1, 40, 3));
        }
        RED_MERCHANT_TRADES = trades.toArray(new VillagerTrades.ItemListing[0]);
    }

    public static VillagerTrades.ItemListing[] getRedMerchantTrades() {
        if (RED_MERCHANT_TRADES == null) {
            VillagerTradesHandler.makeRedMerchantTrades();
        }
        if (CommonUtil.FESTIVITY.isChristmas()) {
            if (CHRISTMAS_SALES == null) {
                CHRISTMAS_SALES = Arrays.stream(RED_MERCHANT_TRADES).map(WrappedListing::new).toList().toArray(new VillagerTrades.ItemListing[0]);
            }
            return CHRISTMAS_SALES;
        }
        return RED_MERCHANT_TRADES;
    }

    static ModItemListing itemForEmeraldTrade(ItemLike item, int quantity, int price, int maxTrades) {
        return VillagerTradesHandler.itemForEmeraldTrade(new ItemStack(item, quantity), price, maxTrades);
    }

    static ModItemListing itemForEmeraldTrade(ItemStack itemStack, int price, int maxTrades) {
        return new ModItemListing(new ItemStack((ItemLike)Items.f_42616_, price), itemStack, maxTrades, 1, 0.05f);
    }

    static ModItemListing itemForEmeraldTrade(ItemLike item, int quantity, ItemLike additional, int addQuantity, int price, int maxTrades) {
        return new ModItemListing(new ItemStack((ItemLike)Items.f_42616_, price), new ItemStack(additional, addQuantity), new ItemStack(item, quantity), maxTrades, 1, 0.05f);
    }

    private static CompoundTag createRandomFireworkStar(RandomSource random, List<FireworkRocketItem.Shape> usedShapes) {
        CompoundTag tag = new CompoundTag();
        ArrayList<FireworkRocketItem.Shape> possible = new ArrayList<FireworkRocketItem.Shape>(List.of(FireworkRocketItem.Shape.values()));
        possible.removeAll(usedShapes);
        if (possible.isEmpty()) {
            tag.m_128344_("Type", (byte)FireworkRocketItem.Shape.values()[random.m_188503_(FireworkRocketItem.Shape.values().length)].m_41236_());
        } else {
            tag.m_128344_("Type", (byte)possible.get(random.m_188503_(possible.size())).m_41236_());
        }
        tag.m_128379_("Flicker", random.m_188501_() < 0.42f);
        tag.m_128379_("Trail", random.m_188501_() < 0.42f);
        ArrayList list = Lists.newArrayList();
        int colors = 0;
        do {
            list.add(VIBRANT_COLORS[random.m_188503_(VIBRANT_COLORS.length)].m_41070_());
        } while (random.m_188501_() < 0.42f && ++colors < 9);
        tag.m_128408_("Colors", (List)list);
        if (random.m_188499_()) {
            ArrayList fadeList = Lists.newArrayList();
            colors = 0;
            do {
                fadeList.add(VIBRANT_COLORS[random.m_188503_(VIBRANT_COLORS.length)].m_41070_());
            } while (random.m_188501_() < 0.42f && ++colors < 9);
            tag.m_128408_("FadeColors", (List)fadeList);
        }
        return tag;
    }

    public static void addTradesRegistration() {
        RegHelper.registerWanderingTraderTrades((int)2, listings -> {
            if (RegistryConfigs.GLOBE_ENABLED.get().booleanValue()) {
                for (int i = 0; i < CommonConfigs.Blocks.GLOBE_TRADES.get(); ++i) {
                    listings.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.GLOBE_ITEM.get(), 1, 10, 3));
                }
            }
        });
        RegHelper.registerWanderingTraderTrades((int)1, listings -> {
            if (RegistryConfigs.FLAX_ENABLED.get().booleanValue()) {
                for (int i = 0; i < 2; ++i) {
                    listings.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get(), 1, 6, 8));
                }
            }
        });
        RegHelper.registerVillagerTrades((VillagerProfession)VillagerProfession.f_35590_, (int)3, itemListings -> {
            if (RegistryConfigs.FLAX_ENABLED.get().booleanValue()) {
                itemListings.add(new ModItemListing(new ItemStack((ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get(), 15), new ItemStack((ItemLike)Items.f_42616_), 16, 2, 0.05f));
            }
        });
        AdventurerMapsHandler.addTradesCallback();
    }

    record StarForEmeraldTrade(int price, int maxTrades) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42689_);
            itemstack.m_41700_("Explosion", (Tag)VillagerTradesHandler.createRandomFireworkStar(random, List.of()));
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.price), itemstack, this.maxTrades, 1, 0.05f);
        }
    }

    record RocketForEmeraldTrade(int price, int paper, int rockets, int maxTrades) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42688_, this.rockets);
            CompoundTag tag = itemstack.m_41698_("Fireworks");
            ListTag listTag = new ListTag();
            int stars = 0;
            ArrayList<FireworkRocketItem.Shape> usedShapes = new ArrayList<FireworkRocketItem.Shape>();
            do {
                listTag.add((Object)VillagerTradesHandler.createRandomFireworkStar(random, usedShapes));
            } while (random.m_188501_() < 0.42f && ++stars < 7);
            tag.m_128344_("Flight", (byte)(random.m_188503_(3) + 1));
            tag.m_128365_("Explosions", (Tag)listTag);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.price), new ItemStack((ItemLike)Items.f_42516_, this.paper), itemstack, this.maxTrades, 1, 0.05f);
        }
    }

    private record WrappedListing(VillagerTrades.ItemListing original) implements VillagerTrades.ItemListing
    {
        private static final PresentBlockTile DUMMY = new PresentBlockTile(BlockPos.f_121853_, ModRegistry.PRESENTS.get(null).get().m_49966_());

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            MerchantOffer internal = this.original.m_213663_(entity, random);
            if (internal == null) {
                return null;
            }
            DUMMY.m_6836_(0, internal.m_45368_());
            DUMMY.setSender(entity.m_7755_().getString());
            DUMMY.setPublic();
            ItemStack stack = DUMMY.getPresentItem((ItemLike)ModRegistry.PRESENTS.get(DyeColor.values()[random.m_188503_(DyeColor.values().length)]).get());
            return new MerchantOffer(internal.m_45352_(), internal.m_45364_(), stack, internal.m_45371_(), internal.m_45373_(), internal.m_45379_(), internal.m_45378_(), internal.m_45375_());
        }
    }
}

