/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapsHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public record AdventurerMapTrade(ResourceLocation structure, int villagerLevel, int minPrice, int maxPrice, String mapName, int mapColor, ResourceLocation mapMarker) implements VillagerTrades.ItemListing
{
    public static final Codec<AdventurerMapTrade> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.f_135803_.fieldOf("structure").forGetter(p -> p.structure), (App)Codec.intRange((int)0, (int)5).optionalFieldOf("villagerLevel", (Object)2).forGetter(p -> p.villagerLevel), (App)Codec.INT.optionalFieldOf("minPrice", (Object)7).forGetter(p -> p.minPrice), (App)Codec.INT.optionalFieldOf("maxPrice", (Object)13).forGetter(p -> p.maxPrice), (App)Codec.STRING.optionalFieldOf("mapName", (Object)"").forGetter(p -> p.mapName), (App)BaseColor.CODEC.optionalFieldOf("mapColor", (Object)0xFFFFFF).forGetter(p -> p.mapColor), (App)ResourceLocation.f_135803_.optionalFieldOf("mapMarker", (Object)new ResourceLocation("")).forGetter(p -> p.mapMarker)).apply((Applicative)i, AdventurerMapTrade::new)).comapFlatMap(trade -> {
        if (trade.maxPrice < trade.minPrice) {
            return DataResult.error((String)("Max price must be larger than min price: [" + trade.minPrice + ", " + trade.maxPrice + "]"));
        }
        return DataResult.success((Object)trade);
    }, Function.identity());

    public MerchantOffer m_213663_(@Nonnull Entity entity, @Nonnull RandomSource random) {
        int i = Math.max(1, random.m_188503_(Math.max(1, this.maxPrice - this.minPrice)) + this.minPrice);
        ItemStack itemstack = AdventurerMapsHandler.createStructureMap(entity.f_19853_, entity.m_20183_(), this.structure, this.mapName.isEmpty() ? null : this.mapName, this.mapColor, this.mapMarker.m_135815_().isEmpty() ? null : this.mapMarker);
        if (itemstack.m_41619_()) {
            return null;
        }
        return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, i), new ItemStack((ItemLike)Items.f_42522_), itemstack, 12, Math.max(1, 5 * (this.villagerLevel - 1)), 0.2f);
    }
}

