/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.capabilities.mob_container;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.capabilities.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.capabilities.mob_container.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.common.capabilities.mob_container.forge.MobContainerImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class MobContainer {
    private final float width;
    private final float height;
    @Nullable
    private MobData data;
    @Nullable
    private ICatchableMob mobDisplayCapInstance;
    private boolean needsInitialization = false;

    public MobContainer(float width, float height) {
        this.width = width;
        this.height = height;
    }

    @Nonnull
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends Entity> ICatchableMob getCap(E entity) {
        return MobContainerImpl.getCap(entity);
    }

    public CompoundTag save(CompoundTag tag) {
        if (!this.isEmpty()) {
            this.data.saveToTag(tag);
        }
        return tag;
    }

    public void load(CompoundTag tag) {
        MobData data = MobData.loadFromTag(tag);
        this.setData(data);
    }

    private void setData(@Nullable MobData data) {
        this.data = data;
        this.mobDisplayCapInstance = null;
        this.needsInitialization = true;
    }

    private void initializeEntity(Level level, BlockPos pos) {
        Entity entity;
        this.needsInitialization = false;
        if (this.data != null && level != null && pos != null && !this.data.isAquarium && (entity = MobContainer.createStaticMob(this.data, level, pos)) != null) {
            this.mobDisplayCapInstance = MobContainer.getCap(entity);
            this.mobDisplayCapInstance.setContainerDimensions(this.width, this.height);
            this.mobDisplayCapInstance.onContainerWaterlogged(level.m_6425_(pos).m_76152_() != Fluids.f_76191_);
            this.updateLightLevel(level, pos);
        }
    }

    public void updateLightLevel(Level level, BlockPos pos) {
        if (level != null && !level.f_46443_) {
            int light = this.hasDisplayMob() ? this.mobDisplayCapInstance.getLightLevel() : CapturedMobsHelper.getTypeFromBucket(this.data.filledBucket.m_41720_()).getLightLevel();
            BlockState state = level.m_8055_(pos);
            if ((Integer)state.m_61143_((Property)ModBlockProperties.LIGHT_LEVEL_0_15) != light) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 22);
            }
        }
    }

    @Nullable
    public static Entity createStaticMob(MobData data, @Nonnull Level world, BlockPos pos) {
        Entity entity = null;
        if (data != null && !data.isAquarium && data.mobTag != null) {
            entity = MobContainer.createEntityFromNBT(data.mobTag, data.uuid, world);
            if (entity == null) {
                return null;
            }
            double px = (double)pos.m_123341_() + entity.m_20185_();
            double py = (double)pos.m_123342_() + entity.m_20186_();
            double pz = (double)pos.m_123343_() + entity.m_20189_();
            entity.m_6034_(px, py, pz);
            entity.f_19790_ = px;
            entity.f_19791_ = py;
            entity.f_19792_ = pz;
            entity.f_19854_ = px;
            entity.f_19855_ = py;
            entity.f_19856_ = pz;
        }
        return entity;
    }

    @Nullable
    public static Entity createEntityFromNBT(CompoundTag tag, @Nullable UUID id, Level world) {
        if (tag != null && tag.m_128441_("id")) {
            Entity entity = EntityType.m_20645_((CompoundTag)tag, (Level)world, o -> o);
            if (id != null && entity != null) {
                entity.m_20084_(id);
                if (entity.m_8077_()) {
                    entity.m_6593_(entity.m_7770_());
                }
            }
            return entity;
        }
        return null;
    }

    public boolean interactWithBucket(ItemStack stack, Level world, BlockPos pos, @Nullable Player player, InteractionHand hand) {
        Item item = stack.m_41720_();
        ItemStack returnStack = ItemStack.f_41583_;
        if (this.isEmpty()) {
            if (BucketHelper.isFishBucket(item)) {
                world.m_5594_(null, pos, SoundEvents.f_11779_, SoundSource.BLOCKS, 1.0f, 1.0f);
                returnStack = new ItemStack((ItemLike)Items.f_42446_);
                MobData data = new MobData(stack.m_41777_());
                this.setData(data);
            }
        } else if (!this.data.filledBucket.m_41619_() && item == Items.f_42446_) {
            world.m_5594_(null, pos, SoundEvents.f_11782_, SoundSource.BLOCKS, 1.0f, 1.0f);
            returnStack = this.data.filledBucket.m_41777_();
            this.setData(null);
        }
        if (!returnStack.m_41619_()) {
            if (player != null) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                if (!player.m_7500_()) {
                    Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)returnStack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public boolean hasDisplayMob() {
        return this.mobDisplayCapInstance != null;
    }

    public void tick(Level pLevel, BlockPos pPos) {
        if (this.needsInitialization) {
            this.initializeEntity(pLevel, pPos);
        }
        if (this.hasDisplayMob() && !this.isEmpty()) {
            ++this.mobDisplayCapInstance.getEntity().f_19797_;
            this.mobDisplayCapInstance.tickInsideContainer(pLevel, pPos, this.data.scale, this.data.mobTag);
        }
    }

    public InteractionResult onInteract(Level world, BlockPos pos, Player player, InteractionHand hand) {
        if (this.hasDisplayMob()) {
            return this.mobDisplayCapInstance.onPlayerInteract(world, pos, player, hand, this.data.mobTag);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public MobData getData() {
        return this.data;
    }

    @Nullable
    public Entity getDisplayedMob() {
        if (this.hasDisplayMob()) {
            return this.mobDisplayCapInstance.getEntity();
        }
        return null;
    }

    public boolean shouldHaveWater() {
        return this.data != null && this.data.isAquarium || this.hasDisplayMob() && this.mobDisplayCapInstance.shouldHaveWater();
    }

    @Nullable
    public static CompoundTag createMobHolderItemTag(@Nonnull Entity mob, float blockW, float blockH, ItemStack bucketStack, boolean isAquarium) {
        MobData data;
        String name = mob.m_7755_().getString();
        if (isAquarium && !bucketStack.m_41619_() && CapturedMobsHelper.getType(mob).canBe2dFish()) {
            data = new MobData(name, bucketStack);
        } else {
            Pair<Float, Float> dimensions = MobContainer.calculateMobDimensionsForContainer(MobContainer.getCap(mob), blockW, blockH, false);
            float scale = ((Float)dimensions.getLeft()).floatValue();
            float yOffset = ((Float)dimensions.getRight()).floatValue();
            double px = 0.5;
            double py = (double)yOffset + 1.0E-4;
            double pz = 0.5;
            mob.m_6034_(px, py, pz);
            mob.f_19790_ = px;
            mob.f_19791_ = py;
            mob.f_19792_ = pz;
            CompoundTag mobTag = MobContainer.prepareMobTagForContainer(mob);
            if (mobTag == null) {
                return null;
            }
            UUID id = mob.m_20148_();
            data = new MobData(name, mobTag, scale, id, bucketStack);
        }
        CompoundTag cmp = new CompoundTag();
        data.saveToTag(cmp);
        return cmp;
    }

    @Nullable
    private static CompoundTag prepareMobTagForContainer(Entity entity) {
        if (entity.m_20159_()) {
            entity.m_20202_().m_20153_();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21530_();
        }
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            bucketable.m_27497_(true);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            le.f_20886_ = 0.0f;
            le.f_20885_ = 0.0f;
            le.f_20924_ = 0.0f;
            le.f_20923_ = 0.0f;
            le.f_20925_ = 0.0f;
            le.f_20917_ = 0;
            le.f_20916_ = 0;
            le.f_20921_ = 0.0f;
        }
        entity.m_146922_(0.0f);
        entity.f_19859_ = 0.0f;
        entity.f_19860_ = 0.0f;
        entity.m_146926_(0.0f);
        entity.m_20095_();
        entity.f_19802_ = 0;
        if (entity instanceof Bat) {
            ((Bat)entity).m_27456_(true);
        }
        if (entity instanceof Fox) {
            ((Fox)entity).m_28626_(true);
        }
        if (entity instanceof AbstractFish) {
            ((AbstractFish)entity).m_27497_(true);
        }
        CompoundTag mobTag = new CompoundTag();
        entity.m_20223_(mobTag);
        if (mobTag.m_128456_()) {
            Supplementaries.LOGGER.error("failed to capture entity " + entity + "Something went wrong :/");
            return null;
        }
        mobTag.m_128473_("Passengers");
        mobTag.m_128473_("Leash");
        mobTag.m_128473_("UUID");
        if (mobTag.m_128441_("FromBucket")) {
            mobTag.m_128379_("FromBucket", true);
        }
        if (mobTag.m_128441_("FromPot")) {
            mobTag.m_128379_("FromPot", true);
        }
        return mobTag;
    }

    public static Pair<Float, Float> calculateMobDimensionsForContainer(ICatchableMob cap, float blockW, float blockH, boolean waterlogged) {
        float yOffset;
        String name;
        Entity mob = cap.getEntity();
        float babyScale = 1.0f;
        if (mob instanceof LivingEntity && ((LivingEntity)mob).m_6162_()) {
            babyScale = mob instanceof Villager ? 1.125f : (mob instanceof AgeableMob ? 2.0f : 1.125f);
        }
        float scale = 1.0f;
        float w = mob.m_20205_() * babyScale;
        float h = mob.m_20206_() * babyScale;
        cap.getHitBoxHeightIncrement();
        boolean isAir = cap.isFlyingMob(waterlogged);
        float aW = w + cap.getHitBoxWidthIncrement();
        float aH = h + cap.getHitBoxHeightIncrement();
        float margin = 0.125f;
        float yMargin = 0.0625f;
        float maxH = blockH - 2.0f * (isAir ? margin : yMargin);
        float maxW = blockW - 2.0f * margin;
        if (aW > maxW || aH > maxH) {
            scale = aW - maxW > aH - maxH ? maxW / aW : maxH / aH;
        }
        if ((name = Utils.getID((EntityType)mob.m_6095_()).toString()).equals("iceandfire:fire_dragon") || name.equals("iceandfire:ice_dragon") || name.equals("iceandfire:lightning_dragon")) {
            scale = (float)((double)scale * 0.45);
        }
        float f = yOffset = isAir ? blockH / 2.0f - aH * scale / 2.0f : yMargin;
        if (mob instanceof Bat) {
            yOffset *= 1.5f;
        }
        return new ImmutablePair((Object)Float.valueOf(scale), (Object)Float.valueOf(yOffset));
    }

    public void clear() {
        this.setData(null);
    }

    public static class MobData {
        public final String name;
        public final boolean isAquarium;
        private final ItemStack filledBucket;
        public final CompoundTag mobTag;
        private final float scale;
        @Nullable
        private final UUID uuid;
        private final int fishIndex;

        public MobData(String name, CompoundTag mobTag, float scale, @Nullable UUID id, ItemStack filledBucket) {
            this.isAquarium = false;
            this.name = name;
            this.mobTag = mobTag;
            this.scale = scale;
            this.uuid = id;
            this.filledBucket = filledBucket;
            this.fishIndex = 0;
        }

        public MobData(ItemStack filledBucket) {
            this(null, filledBucket);
        }

        public MobData(String name, ItemStack filledBucket) {
            this(name, 0, filledBucket);
        }

        public MobData(@Nullable String name, @Nullable int fishIndex, @Nonnull ItemStack filledBucket) {
            EntityType<?> type = null;
            if (name == null) {
                type = BucketHelper.getEntityType(filledBucket.m_41720_());
                String string = name = type == null ? "Mob" : type.m_20675_();
            }
            if (fishIndex == 0) {
                CapturedMobsHelper.CapturedMobConfigProperties t;
                if (type == null) {
                    type = BucketHelper.getEntityType(filledBucket.m_41720_());
                }
                fishIndex = 0;
                if (type != null && (t = CapturedMobsHelper.getType(type)).is2DFish()) {
                    fishIndex = t.getFishTexture();
                }
            }
            this.isAquarium = true;
            this.fishIndex = fishIndex;
            this.filledBucket = filledBucket;
            this.name = name;
            this.uuid = null;
            this.scale = 1.0f;
            this.mobTag = null;
        }

        @Nullable
        public static MobData loadFromTag(CompoundTag tag) {
            if (tag.m_128441_("MobHolder")) {
                CompoundTag cmp = tag.m_128469_("MobHolder");
                CompoundTag entityData = cmp.m_128469_("EntityData");
                float scale = cmp.m_128457_("Scale");
                UUID uuid = cmp.m_128441_("UUID") ? cmp.m_128342_("UUID") : null;
                ItemStack bucket = cmp.m_128441_("Bucket") ? ItemStack.m_41712_((CompoundTag)cmp.m_128469_("Bucket")) : ItemStack.f_41583_;
                String name = cmp.m_128461_("Name");
                if (cmp.m_128441_("YOffset")) {
                    float y = cmp.m_128457_("YOffset");
                    ListTag listnbt = new ListTag();
                    listnbt.add((Object)DoubleTag.m_128500_((double)0.5));
                    listnbt.add((Object)DoubleTag.m_128500_((double)y));
                    listnbt.add((Object)DoubleTag.m_128500_((double)0.5));
                    if (entityData.m_128441_("Pos")) {
                        entityData.m_128473_("Pos");
                    }
                    entityData.m_128365_("Pos", (Tag)listnbt);
                }
                return new MobData(name, entityData, scale, uuid, bucket);
            }
            if (tag.m_128441_("BucketHolder")) {
                CompoundTag cmp = tag.m_128469_("BucketHolder");
                ItemStack bucket = ItemStack.m_41712_((CompoundTag)cmp.m_128469_("Bucket"));
                int fish = cmp.m_128451_("FishTexture");
                String name = cmp.m_128461_("Name");
                return new MobData(name, fish, bucket);
            }
            return null;
        }

        public void saveToTag(CompoundTag tag) {
            CompoundTag cmp = new CompoundTag();
            cmp.m_128359_("Name", this.name);
            if (!this.filledBucket.m_41619_() || this.isAquarium) {
                CompoundTag bucketTag = new CompoundTag();
                this.filledBucket.m_41739_(bucketTag);
                cmp.m_128365_("Bucket", (Tag)bucketTag);
            }
            if (this.isAquarium) {
                cmp.m_128405_("FishTexture", this.fishIndex);
                tag.m_128365_("BucketHolder", (Tag)cmp);
            } else {
                cmp.m_128365_("EntityData", (Tag)this.mobTag);
                cmp.m_128350_("Scale", this.scale);
                if (this.uuid != null) {
                    cmp.m_128362_("UUID", this.uuid);
                }
                tag.m_128365_("MobHolder", (Tag)cmp);
            }
        }

        public float getScale() {
            return this.scale;
        }

        public int getFishIndex() {
            return this.fishIndex;
        }
    }
}

