/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.capabilities.mob_container;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.ForgeHelper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;

public class BucketHelper {
    private static final BiMap<Item, String> BUCKET_TO_MOB_MAP = HashBiMap.create();

    @Nullable
    public static EntityType<?> getEntityType(Item bucket) {
        if (BUCKET_TO_MOB_MAP.containsKey((Object)bucket)) {
            String mobId = (String)BUCKET_TO_MOB_MAP.get((Object)bucket);
            ResourceLocation res = new ResourceLocation(mobId);
            Optional opt = Registry.f_122826_.m_6612_(res);
            if (opt.isPresent()) {
                return (EntityType)opt.get();
            }
            return (EntityType)Registry.f_122826_.m_7745_(new ResourceLocation(mobId));
        }
        if (bucket instanceof MobBucketItem) {
            MobBucketItem bucketItem = (MobBucketItem)bucket;
            EntityType<?> en = ForgeHelper.getFishType(bucketItem);
            if (en != null) {
                BUCKET_TO_MOB_MAP.putIfAbsent((Object)bucket, (Object)Utils.getID(en).toString());
                return en;
            }
        } else {
            ResourceLocation res;
            Optional opt;
            String mobId = null;
            String itemName = Utils.getID((Item)bucket).toString();
            if (itemName.contains("_bucket")) {
                mobId = itemName.replace("_bucket", "");
            } else if (itemName.contains("bucket_of_")) {
                mobId = itemName.replace("_bucket", "");
            } else if (itemName.contains("bucket_")) {
                mobId = itemName.replace("bucket_", "");
            }
            if (mobId != null && (opt = Registry.f_122826_.m_6612_(res = new ResourceLocation(mobId))).isPresent()) {
                EntityType en = (EntityType)opt.get();
                BUCKET_TO_MOB_MAP.putIfAbsent((Object)bucket, (Object)Utils.getID((EntityType)en).toString());
                return en;
            }
        }
        return null;
    }

    public static void tryAddingFromEntityId(String id) {
    }

    public static Collection<Item> getValidBuckets() {
        return BUCKET_TO_MOB_MAP.keySet();
    }

    public static boolean isFishBucket(Item item) {
        return BucketHelper.getEntityType(item) != null;
    }

    public static boolean isBucketableEntity(String mobId) {
        return BUCKET_TO_MOB_MAP.containsValue((Object)mobId);
    }

    public static void associateMobToBucketIfAbsent(EntityType<?> entity, Item item) {
        if (!BUCKET_TO_MOB_MAP.containsKey((Object)item)) {
            String name = Utils.getID(entity).toString();
            if (!BUCKET_TO_MOB_MAP.inverse().containsKey((Object)name)) {
                BUCKET_TO_MOB_MAP.putIfAbsent((Object)item, (Object)name);
            }
        }
    }
}

