/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.capabilities.antique_ink.forge;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.api.IAntiqueTextProvider;
import net.mehvahdjukaar.supplementaries.common.capabilities.forge.CapabilityHandler;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class AntiqueInkProviderImpl
implements IAntiqueTextProvider,
ICapabilitySerializable<CompoundTag> {
    private boolean hasAntiqueInk = false;

    public static boolean toggleAntiqueInkOnSigns(Level world, Player player, ItemStack stack, boolean newState, BlockPos pos, BlockEntity tile) {
        LazyOptional cap = tile.getCapability(CapabilityHandler.ANTIQUE_TEXT_CAP);
        AtomicBoolean success = new AtomicBoolean(false);
        cap.ifPresent(c -> {
            if (c.hasAntiqueInk() != newState) {
                c.setAntiqueInk(newState);
                tile.m_6596_();
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    NetworkHandler.CHANNEL.sendToAllClientPlayersInRange((Level)serverLevel, pos, 256.0, (Message)new ClientBoundSyncAntiqueInk(pos, newState));
                }
                success.set(true);
            }
        });
        if (success.get()) {
            if (newState) {
                world.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.m_5594_(null, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public static void setAntiqueInk(BlockEntity tile, boolean ink) {
        tile.getCapability(CapabilityHandler.ANTIQUE_TEXT_CAP).ifPresent(c -> c.setAntiqueInk(ink));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        return capability == CapabilityHandler.ANTIQUE_TEXT_CAP ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("ink", this.hasAntiqueInk);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.hasAntiqueInk = tag.m_128471_("ink");
    }

    @Override
    public boolean hasAntiqueInk() {
        return this.hasAntiqueInk;
    }

    @Override
    public void setAntiqueInk(boolean hasInk) {
        this.hasAntiqueInk = hasInk;
    }
}

