/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidConsumer;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidProvider;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.fluids.ISoftFluidTank;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.VanillaSoftFluids;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FaucetBlock;
import net.mehvahdjukaar.supplementaries.common.utils.FluidsUtil;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.InspirationCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSoftFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.PowderSnowCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class FaucetBlockTile
extends BlockEntity {
    private static final int COOLDOWN = 20;
    private int transferCooldown = 0;
    public final ISoftFluidTank tempFluidHolder = ISoftFluidTank.create((int)5);

    public FaucetBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.FAUCET_TILE.get(), pos, state);
    }

    public void updateLight() {
        if (this.f_58857_ == null) {
            return;
        }
        int light = this.tempFluidHolder.getFluid().getLuminosity();
        if (light != 0) {
            light = (int)Mth.m_14036_((float)((float)light / 2.0f), (float)1.0f, (float)7.0f);
        }
        if (light != (Integer)this.m_58900_().m_61143_((Property)FaucetBlock.LIGHT_LEVEL)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FaucetBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    @PlatformOnly(value={"forge"})
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_7918_(0, -1, 0), this.m_58899_().m_7918_(1, 1, 1));
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, FaucetBlockTile tile) {
        boolean flag;
        if (tile.transferCooldown > 0) {
            --tile.transferCooldown;
        } else if (tile.isOpen() && (flag = tile.tryExtract(pLevel, pPos, pState, true))) {
            tile.transferCooldown += 20;
        }
    }

    public boolean updateContainedFluidVisuals(Level level, BlockPos pos, BlockState state) {
        FluidState fluidState = level.m_6425_(pos.m_121945_(((Direction)state.m_61143_((Property)FaucetBlock.FACING)).m_122424_()));
        if (!fluidState.m_76178_()) {
            this.tempFluidHolder.fill(SoftFluidRegistry.fromForgeFluid((Fluid)fluidState.m_76152_()));
            this.updateLight();
            return true;
        }
        boolean r = this.tryExtract(level, pos, state, false);
        this.updateLight();
        return r;
    }

    private boolean tryExtract(Level level, BlockPos pos, BlockState state, boolean doTransfer) {
        BlockEntity tileBack;
        Direction dir = (Direction)state.m_61143_((Property)FaucetBlock.FACING);
        BlockPos behind = pos.m_121945_(dir.m_122424_());
        BlockState backState = level.m_8055_(behind);
        Block backBlock = backState.m_60734_();
        this.tempFluidHolder.clear();
        if (backState.m_60795_()) {
            return false;
        }
        if (backBlock instanceof ISoftFluidProvider) {
            ISoftFluidProvider provider = (ISoftFluidProvider)backBlock;
            Pair stack = provider.getProvidedFluid(level, backState, behind);
            this.prepareToTransferBottle((SoftFluid)stack.getLeft(), (CompoundTag)stack.getRight());
            if (doTransfer && this.tryFillingBlockBelow(level, pos)) {
                provider.consumeProvidedFluid(level, backState, behind, this.tempFluidHolder.getFluid(), this.tempFluidHolder.getNbt(), 1);
                return true;
            }
        } else {
            int waterLevel;
            if (backState.m_61138_((Property)BlockStateProperties.f_61421_)) {
                if ((Integer)backState.m_61143_((Property)BlockStateProperties.f_61421_) == 5) {
                    this.prepareToTransferBottle((SoftFluid)VanillaSoftFluids.HONEY.get());
                    if (doTransfer && this.tryFillingBlockBelow(level, pos)) {
                        level.m_7731_(behind, (BlockState)backState.m_61124_((Property)BlockStateProperties.f_61421_, (Comparable)Integer.valueOf((Integer)backState.m_61143_((Property)BlockStateProperties.f_61421_) - 1)), 3);
                        return true;
                    }
                }
                return false;
            }
            if (CompatHandler.buzzier_bees && backState.m_61138_((Property)ModBlockProperties.HONEY_LEVEL_POT)) {
                if ((Integer)backState.m_61143_((Property)ModBlockProperties.HONEY_LEVEL_POT) > 0) {
                    this.prepareToTransferBottle((SoftFluid)VanillaSoftFluids.HONEY.get());
                    if (doTransfer && this.tryFillingBlockBelow(level, pos)) {
                        level.m_7731_(behind, (BlockState)backState.m_61124_((Property)ModBlockProperties.HONEY_LEVEL_POT, (Comparable)Integer.valueOf((Integer)backState.m_61143_((Property)ModBlockProperties.HONEY_LEVEL_POT) - 1)), 3);
                        return true;
                    }
                }
                return false;
            }
            if (CompatHandler.autumnity && (backBlock == CompatObjects.SAPPY_MAPLE_LOG.get() || backBlock == CompatObjects.SAPPY_MAPLE_WOOD.get())) {
                this.prepareToTransferBottle((SoftFluid)ModSoftFluids.SAP.get());
                if (doTransfer && this.tryFillingBlockBelow(level, pos)) {
                    Optional log = Registry.f_122824_.m_6612_(new ResourceLocation(Utils.getID((Block)backBlock).toString().replace("sappy", "stripped")));
                    log.ifPresent(block -> level.m_7731_(behind, block.m_152465_(backState), 3));
                    return true;
                }
            } else if (backBlock == Blocks.f_152476_) {
                int waterLevel2 = (Integer)backState.m_61143_((Property)BlockStateProperties.f_61418_);
                if (waterLevel2 > 0) {
                    if (CompatHandler.inspirations) {
                        return InspirationCompat.doCauldronStuff(level.m_7702_(behind), this.tempFluidHolder, doTransfer, () -> this.tryFillingBlockBelow(level, pos));
                    }
                    this.prepareToTransferBottle((SoftFluid)VanillaSoftFluids.WATER.get());
                    if (doTransfer && this.tryFillingBlockBelow(level, pos)) {
                        if (waterLevel2 > 1) {
                            level.m_7731_(behind, (BlockState)backState.m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(waterLevel2 - 1)), 3);
                        } else {
                            level.m_7731_(behind, Blocks.f_50256_.m_49966_(), 3);
                        }
                        return true;
                    }
                }
            } else if (backBlock == Blocks.f_152477_) {
                this.prepareToTransferBucket((SoftFluid)VanillaSoftFluids.LAVA.get());
                if (doTransfer && this.tryFillingBlockBelow(level, pos)) {
                    level.m_7731_(behind, Blocks.f_50256_.m_49966_(), 3);
                    this.transferCooldown += 60;
                    return true;
                }
            } else if (backBlock == Blocks.f_152478_ && (waterLevel = ((Integer)backState.m_61143_((Property)BlockStateProperties.f_61418_)).intValue()) == 3) {
                this.prepareToTransferBucket((SoftFluid)VanillaSoftFluids.POWDERED_SNOW.get());
                if (doTransfer && this.tryFillingBlockBelow(level, pos)) {
                    level.m_7731_(behind, Blocks.f_50256_.m_49966_(), 3);
                    this.transferCooldown += 60;
                    return true;
                }
            }
        }
        if ((tileBack = level.m_7702_(behind)) != null) {
            ISoftFluidTankProvider holder;
            if (tileBack instanceof ISoftFluidTankProvider && (holder = (ISoftFluidTankProvider)tileBack).canInteractWithSoftFluidTank()) {
                ISoftFluidTank fluidHolder = holder.getSoftFluidTank();
                this.tempFluidHolder.copy(fluidHolder);
                this.tempFluidHolder.setCount(2);
                if (doTransfer && this.tryFillingBlockBelow(level, pos)) {
                    fluidHolder.shrink(1);
                    tileBack.m_6596_();
                    return true;
                }
            } else if (FluidsUtil.tryExtractFromFluidHandler(tileBack, backBlock, dir, this.tempFluidHolder, doTransfer, () -> this.tryFillingBlockBelow(level, pos))) {
                return true;
            }
            if (!doTransfer) {
                return !this.tempFluidHolder.isEmpty();
            }
            return this.spillItemsFromInventory(level, pos, dir, tileBack);
        }
        if (level.m_6425_(behind).m_76152_() == Fluids.f_76193_) {
            this.prepareToTransferBottle((SoftFluid)VanillaSoftFluids.WATER.get());
            if (doTransfer && this.tryFillingBlockBelow(level, pos)) {
                return true;
            }
            return true;
        }
        if (!doTransfer) {
            return !this.tempFluidHolder.isEmpty();
        }
        return false;
    }

    private void prepareToTransferBottle(SoftFluid softFluid) {
        this.tempFluidHolder.fill(softFluid);
        this.tempFluidHolder.setCount(2);
    }

    private void prepareToTransferBottle(SoftFluid softFluid, CompoundTag tag) {
        this.tempFluidHolder.fill(softFluid, tag);
        this.tempFluidHolder.setCount(2);
    }

    private void prepareToTransferBucket(SoftFluid softFluid) {
        this.tempFluidHolder.fill(softFluid);
    }

    private boolean tryFillingBlockBelow(Level level, BlockPos pos) {
        BlockEntity tileBelow;
        SoftFluid softFluid = this.tempFluidHolder.getFluid();
        if (softFluid.isEmpty()) {
            return false;
        }
        BlockPos below = pos.m_7495_();
        BlockState belowState = level.m_8055_(below);
        Block belowBlock = belowState.m_60734_();
        if (belowBlock instanceof ISoftFluidConsumer) {
            ISoftFluidConsumer consumer = (ISoftFluidConsumer)belowBlock;
            return consumer.tryAcceptingFluid(level, belowState, below, softFluid, this.tempFluidHolder.getNbt(), 1);
        }
        if (belowBlock == Blocks.f_50056_) {
            return true;
        }
        if (softFluid == VanillaSoftFluids.HONEY.get()) {
            if (belowState.m_61138_((Property)BlockStateProperties.f_61421_)) {
                int h = (Integer)belowState.m_61143_((Property)BlockStateProperties.f_61421_);
                if (h == 0) {
                    level.m_7731_(below, (BlockState)belowState.m_61124_((Property)BlockStateProperties.f_61421_, (Comparable)Integer.valueOf(5)), 3);
                    return true;
                }
                return false;
            }
            if (CompatHandler.buzzier_bees && belowState.m_61138_((Property)ModBlockProperties.HONEY_LEVEL_POT)) {
                int h = (Integer)belowState.m_61143_((Property)ModBlockProperties.HONEY_LEVEL_POT);
                if (h < 4) {
                    level.m_7731_(below, (BlockState)belowState.m_61124_((Property)ModBlockProperties.HONEY_LEVEL_POT, (Comparable)Integer.valueOf(h + 1)), 3);
                    return true;
                }
                return false;
            }
        } else {
            if (softFluid == VanillaSoftFluids.XP.get() && belowState.m_60795_()) {
                this.dropXP(level, pos);
                return true;
            }
            if (belowBlock instanceof AbstractCauldronBlock) {
                if (CompatHandler.inspirations) {
                    return InspirationCompat.tryAddFluid(level.m_7702_(below), this.tempFluidHolder);
                }
                if (softFluid == VanillaSoftFluids.WATER.get()) {
                    if (belowBlock == Blocks.f_152476_) {
                        int levels = (Integer)belowState.m_61143_((Property)BlockStateProperties.f_61418_);
                        if (levels < 3) {
                            level.m_7731_(below, (BlockState)belowState.m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(levels + 1)), 3);
                            return true;
                        }
                        return false;
                    }
                    if (belowBlock instanceof CauldronBlock) {
                        level.m_7731_(below, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(1)), 3);
                        return true;
                    }
                } else if (softFluid == VanillaSoftFluids.LAVA.get()) {
                    if (belowBlock instanceof CauldronBlock && this.tempFluidHolder.getCount() == 5) {
                        level.m_7731_(below, Blocks.f_152477_.m_49966_(), 3);
                        return true;
                    }
                } else if (softFluid == VanillaSoftFluids.POWDERED_SNOW.get() && belowBlock instanceof CauldronBlock && this.tempFluidHolder.getCount() == 5) {
                    level.m_7731_(below, (BlockState)Blocks.f_152478_.m_49966_().m_61124_((Property)PowderSnowCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 3);
                    return true;
                }
                return false;
            }
        }
        if ((tileBelow = level.m_7702_(below)) instanceof ISoftFluidTankProvider) {
            ISoftFluidTankProvider holder = (ISoftFluidTankProvider)tileBelow;
            ISoftFluidTank fluidHolder = holder.getSoftFluidTank();
            boolean result = this.tempFluidHolder.tryTransferFluid(fluidHolder, this.tempFluidHolder.getCount() - 1);
            if (result) {
                tileBelow.m_6596_();
                this.tempFluidHolder.fillCount();
            }
            return result;
        }
        if (tileBelow != null) {
            return FluidsUtil.tryFillFluidTank(tileBelow, this.tempFluidHolder);
        }
        return false;
    }

    private void dropXP(Level level, BlockPos pos) {
        int xp;
        for (int i = 3 + level.f_46441_.m_188503_(5) + level.f_46441_.m_188503_(5); i > 0; i -= xp) {
            xp = ExperienceOrb.m_20782_((int)i);
            ExperienceOrb orb = new ExperienceOrb(level, (double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() - 0.125f), (double)pos.m_123343_() + 0.5, xp);
            orb.m_20256_(new Vec3(0.0, 0.0, 0.0));
            level.m_7967_((Entity)orb);
        }
        float f = (level.f_46441_.m_188501_() - 0.5f) / 4.0f;
        level.m_5594_(null, pos, SoundEvents.f_11752_, SoundSource.BLOCKS, 0.3f, 0.5f + f);
    }

    public boolean isOpen() {
        return (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_) ^ (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61431_);
    }

    public boolean hasWater() {
        return (Boolean)this.m_58900_().m_61143_((Property)FaucetBlock.HAS_WATER);
    }

    public boolean isConnectedBelow() {
        return (Boolean)this.m_58900_().m_61143_((Property)FaucetBlock.HAS_JAR);
    }

    public boolean spillItemsFromInventory(Level level, BlockPos pos, Direction dir, BlockEntity tile) {
        if (this.isConnectedBelow()) {
            return false;
        }
        return ItemsUtil.faucetSpillItems(level, pos, dir, tile);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.transferCooldown = compound.m_128451_("TransferCooldown");
        this.tempFluidHolder.load(compound);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("TransferCooldown", this.transferCooldown);
        this.tempFluidHolder.save(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

