/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.ModTextures;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CandleSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.EnhancedSkullBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;

public class DoubleSkullBlockTile
extends EnhancedSkullBlockTile {
    private static final List<ResourceLocation> TEXTURE_IND = new ArrayList<ResourceLocation>(ModTextures.SKULL_CANDLES_TEXTURES.values());
    @Nullable
    protected SkullBlockEntity innerTileUp = null;
    private ResourceLocation waxTexture = null;

    public DoubleSkullBlockTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModRegistry.SKULL_PILE_TILE.get(), pWorldPosition, pBlockState);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveInnerTile("SkullUp", this.innerTileUp, tag);
        if (this.waxTexture != null) {
            tag.m_128344_("WaxColor", (byte)TEXTURE_IND.indexOf(this.waxTexture));
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.innerTileUp = this.loadInnerTile("SkullUp", this.innerTileUp, tag);
        this.waxTexture = tag.m_128441_("WaxColor") ? TEXTURE_IND.get(tag.m_128445_("WaxColor")) : null;
    }

    public ItemStack getSkullItemUp() {
        if (this.innerTileUp != null) {
            return new ItemStack((ItemLike)this.innerTileUp.m_58900_().m_60734_());
        }
        return ItemStack.f_41583_;
    }

    public void rotateUp(Rotation rotation) {
        if (this.innerTileUp != null) {
            BlockState state = this.innerTileUp.m_58900_();
            int r = (Integer)this.innerTileUp.m_58900_().m_61143_((Property)SkullBlock.f_56314_);
            this.innerTileUp.m_155250_((BlockState)state.m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf(rotation.m_55949_(r, 16))));
        }
    }

    public void rotateUpStep(int step) {
        if (this.innerTileUp != null) {
            BlockState state = this.innerTileUp.m_58900_();
            int r = (Integer)this.innerTileUp.m_58900_().m_61143_((Property)SkullBlock.f_56314_);
            this.innerTileUp.m_155250_((BlockState)state.m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf((r - step + 16) % 16)));
        }
    }

    @Override
    public void initialize(SkullBlockEntity oldTile, SkullBlock skullBlock, ItemStack skullStack, Player player, InteractionHand hand) {
        BlockItem bi;
        Block block;
        super.initialize(oldTile, skullBlock, skullStack, player, hand);
        Item item = skullStack.m_41720_();
        if (item instanceof BlockItem && (block = (bi = (BlockItem)item).m_40614_()) instanceof SkullBlock) {
            BlockEntity entity;
            SkullBlock upSkull = (SkullBlock)block;
            BlockPlaceContext context = new BlockPlaceContext(player, hand, skullStack, new BlockHitResult(new Vec3(0.5, 0.5, 0.5), Direction.UP, this.m_58899_(), false));
            BlockState state = upSkull.m_5573_(context);
            if (state == null) {
                state = upSkull.m_49966_();
            }
            if ((entity = upSkull.m_142194_(this.m_58899_(), state)) instanceof SkullBlockEntity) {
                SkullBlockEntity blockEntity;
                this.innerTileUp = blockEntity = (SkullBlockEntity)entity;
                GameProfile gameprofile = null;
                if (skullStack.m_41782_()) {
                    CompoundTag compoundtag = skullStack.m_41783_();
                    if (compoundtag.m_128425_("SkullOwner", 10)) {
                        gameprofile = NbtUtils.m_129228_((CompoundTag)compoundtag.m_128469_("SkullOwner"));
                    } else if (compoundtag.m_128425_("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundtag.m_128461_("SkullOwner"))) {
                        gameprofile = new GameProfile(null, compoundtag.m_128461_("SkullOwner"));
                    }
                }
                this.innerTileUp.m_59769_(gameprofile);
            }
        }
    }

    public void updateWax(BlockState above) {
        ResourceLocation newTexture = null;
        Block block = above.m_60734_();
        if (block instanceof CandleBlock) {
            CandleBlock block2 = (CandleBlock)block;
            newTexture = CandleSkullBlockTile.getWaxColor(block2);
        }
        if (this.waxTexture != newTexture) {
            this.waxTexture = newTexture;
            if (this.f_58857_ instanceof ServerLevel) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            }
        }
    }

    public ResourceLocation getWaxTexture() {
        return this.waxTexture;
    }

    @Nullable
    public BlockState getSkullUp() {
        if (this.innerTileUp != null) {
            return this.innerTileUp.m_58900_();
        }
        return null;
    }

    @Nullable
    public BlockEntity getSkullTileUp() {
        return this.innerTileUp;
    }
}

