/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.ModTextures;
import net.mehvahdjukaar.supplementaries.common.block.tiles.EnhancedSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CandleSkullBlockTile
extends EnhancedSkullBlockTile {
    private BlockState candle = Blocks.f_50016_.m_49966_();
    private ResourceLocation waxTexture = null;

    public CandleSkullBlockTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModRegistry.SKULL_CANDLE_TILE.get(), pWorldPosition, pBlockState);
    }

    public ResourceLocation getWaxTexture() {
        return this.waxTexture;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Candle", (Tag)NbtUtils.m_129202_((BlockState)this.candle));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Candle", 10)) {
            this.candle = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("Candle"));
            Block block = this.candle.m_60734_();
            if (block instanceof CandleBlock) {
                CandleBlock candleBlock = (CandleBlock)block;
                this.waxTexture = CandleSkullBlockTile.getWaxColor(candleBlock);
            } else {
                this.waxTexture = ModTextures.SKULL_CANDLES_TEXTURES.get(Blocks.f_152482_);
            }
        }
    }

    public BlockState getCandle() {
        return this.candle;
    }

    public void setCandle(BlockState candle) {
        this.candle = candle;
    }

    public boolean tryAddingCandle(CandleBlock candle) {
        if (this.candle.m_60795_() || candle == this.candle.m_60734_() && (Integer)this.candle.m_61143_((Property)CandleBlock.f_152790_) != 4) {
            if (this.candle.m_60795_()) {
                this.candle = candle.m_49966_();
                this.waxTexture = CandleSkullBlockTile.getWaxColor(candle);
            } else {
                this.candle.m_61122_((Property)CandleBlock.f_152790_);
            }
            if (!this.f_58857_.f_46443_) {
                BlockState state = this.m_58900_();
                BlockState newState = BlockUtil.replaceProperty(this.candle, state, CandleBlock.f_152790_);
                this.f_58857_.m_46597_(this.f_58858_, newState);
                this.m_6596_();
            }
            return true;
        }
        return false;
    }

    @Override
    public void initialize(SkullBlockEntity oldTile, SkullBlock skullBlock, ItemStack stack, Player player, InteractionHand hand) {
        BlockItem blockItem;
        super.initialize(oldTile, skullBlock, stack, player, hand);
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof CandleBlock) {
            CandleBlock candleBlock = (CandleBlock)item;
            this.tryAddingCandle(candleBlock);
        }
    }

    @Nullable
    public static ResourceLocation getWaxColor(CandleBlock b2) {
        return ModTextures.SKULL_CANDLES_TEXTURES.get(b2);
    }
}

