/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.world.generation.RoadSignFeature;
import net.mehvahdjukaar.supplementaries.common.world.generation.StructureLocator;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;

public class BlockGeneratorBlockTile
extends BlockEntity {
    private static final ExecutorService EXECUTORS = Executors.newCachedThreadPool();
    private boolean firstTick = true;
    private volatile List<Pair<BlockPos, Holder<Structure>>> threadResult = null;

    public BlockGeneratorBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.BLOCK_GENERATOR_TILE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockGeneratorBlockTile tile) {
        if (tile.firstTick) {
            tile.firstTick = false;
            ServerLevel world = (ServerLevel)level;
            EXECUTORS.submit(() -> {
                try {
                    tile.threadResult = StructureLocator.findNearestMapFeatures(world, ModTags.WAY_SIGN_DESTINATIONS, pos, 250, false, 2);
                }
                catch (Exception e) {
                    tile.threadResult = null;
                }
            });
        }
        try {
            if (tile.threadResult != null) {
                RoadSignFeature.applyPostProcess((ServerLevel)level, pos, tile.threadResult);
            }
        }
        catch (Exception exception) {
            tile.failAndRemove(level, pos, exception);
        }
    }

    private void failAndRemove(Level level, BlockPos pos, Exception e) {
        level.m_7471_(pos, false);
        Supplementaries.LOGGER.warn("failed to generate road sign at " + pos + ": " + e);
    }
}

