/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TurnTableBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TurnTableBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty INVERTED = BlockStateProperties.f_61441_;
    public static final BooleanProperty ROTATING = ModBlockProperties.ROTATING;

    public TurnTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTATING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWER, INVERTED, ROTATING});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.updatePower(state, world, pos) && (Integer)world.m_8055_(pos).m_61143_((Property)POWER) != 0) {
            this.tryRotate(world, pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Direction myDir;
        Direction face = hit.m_82434_();
        if (face != (myDir = (Direction)state.m_61143_((Property)FACING)) && face != myDir.m_122424_()) {
            if (!player.m_150110_().f_35938_) {
                return InteractionResult.PASS;
            }
            float f = (Boolean)(state = (BlockState)state.m_61122_((Property)INVERTED)).m_61143_((Property)INVERTED) != false ? 0.55f : 0.5f;
            worldIn.m_5594_(player, pos, SoundEvents.f_11762_, SoundSource.BLOCKS, 0.3f, f);
            worldIn.m_7731_(pos, state, 6);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean updatePower(BlockState state, Level world, BlockPos pos) {
        int currentPower;
        int bestNeighborSignal = world.m_46755_(pos);
        if (bestNeighborSignal != (currentPower = ((Integer)state.m_61143_((Property)POWER)).intValue())) {
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(bestNeighborSignal))).m_61124_((Property)ROTATING, (Comparable)Boolean.valueOf(bestNeighborSignal != 0)), 6);
            return true;
        }
        return false;
    }

    private void tryRotate(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TurnTableBlockTile) {
            TurnTableBlockTile te = (TurnTableBlockTile)blockEntity;
            te.tryRotate();
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.m_6861_(state, world, pos, neighborBlock, fromPos, moving);
        boolean powerChanged = this.updatePower(state, world, pos);
        if ((Integer)world.m_8055_(pos).m_61143_((Property)POWER) != 0 && (powerChanged || fromPos.equals((Object)pos.m_121945_((Direction)state.m_61143_((Property)FACING))))) {
            this.tryRotate(world, pos);
        }
    }

    private static Vec3 rotateY(Vec3 vec, double deg) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vec3.f_82478_) {
            return vec;
        }
        double x = vec.f_82479_;
        double y = vec.f_82480_;
        double z = vec.f_82481_;
        float angle = (float)(deg / 180.0 * Math.PI);
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        return new Vec3(x * c + z * s, y, z * c - x * s);
    }

    public static int getPeriod(BlockState state) {
        return 60 - (Integer)state.m_61143_((Property)POWER) * 4 + 4;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity e) {
        super.m_141947_(world, pos, state, e);
        if (!CommonConfigs.Blocks.TURN_TABLE_ROTATE_ENTITIES.get().booleanValue()) {
            return;
        }
        if (!e.m_20096_()) {
            return;
        }
        if ((Integer)state.m_61143_((Property)POWER) != 0 && state.m_61143_((Property)FACING) == Direction.UP) {
            float period = TurnTableBlock.getPeriod(state) + 1;
            float ANGLE_INCREMENT = 90.0f / period;
            float increment = (Boolean)state.m_61143_((Property)INVERTED) != false ? ANGLE_INCREMENT : -1.0f * ANGLE_INCREMENT;
            Vec3 origin = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            Vec3 oldPos = e.m_20182_();
            Vec3 oldOffset = oldPos.m_82546_(origin);
            Vec3 newOffset = TurnTableBlock.rotateY(oldOffset, increment);
            Vec3 posDiff = origin.m_82549_(newOffset).m_82546_(oldPos);
            e.m_6478_(MoverType.SHULKER_BOX, posDiff);
            e.f_19864_ = true;
            if (e instanceof LivingEntity) {
                BlockEntity blockEntity;
                Cat cat;
                LivingEntity entity = (LivingEntity)e;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    Advancement advancement = world.m_7654_().m_129889_().m_136041_(new ResourceLocation("supplementaries", "story/turn_table"));
                    if (advancement != null) {
                        player.m_8960_().m_135988_(advancement, "unlock");
                    }
                }
                e.m_6853_(false);
                float diff = e.m_6080_() - increment;
                e.m_5618_(diff);
                e.m_5616_(diff);
                entity.f_20886_ = ((LivingEntity)e).f_20885_;
                entity.m_21310_(20);
                if (e instanceof Cat && (cat = (Cat)e).m_21827_() && !world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof TurnTableBlockTile) {
                    TurnTableBlockTile tile = (TurnTableBlockTile)blockEntity;
                    if (tile.cat == 0) {
                        tile.cat = 400;
                        world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, ModSounds.TOM.get(), SoundSource.BLOCKS, 0.85f, 1.0f);
                    }
                }
            }
            e.f_19859_ = e.m_146908_();
            e.m_146922_(e.m_146908_() - increment);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TurnTableBlockTile(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BlockUtil.getTicker(pBlockEntityType, ModRegistry.TURN_TABLE_TILE.get(), !pLevel.f_46443_ ? TurnTableBlockTile::tick : null);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        if (eventID == 0) {
            if (world.f_46443_ && ClientConfigs.Blocks.TURN_TABLE_PARTICLES.get().booleanValue()) {
                Direction dir = (Direction)state.m_61143_((Property)FACING);
                BlockPos front = pos.m_121945_(dir);
                world.m_7106_((ParticleOptions)ModParticles.ROTATION_TRAIL_EMITTER.get(), (double)front.m_123341_() + 0.5, (double)front.m_123342_() + 0.5, (double)front.m_123343_() + 0.5, (double)dir.m_122411_(), 0.71, (double)((Boolean)state.m_61143_((Property)INVERTED) != false ? 1 : -1));
            }
            return true;
        }
        return super.m_8133_(state, world, pos, eventID, eventParam);
    }
}

