/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Random;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.api.ILightable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SconceWallBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SconceLeverBlock
extends SconceWallBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public SconceLeverBlock(BlockBehaviour.Properties properties, Supplier<SimpleParticleType> particleData) {
        super(properties, particleData);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        InteractionResult result = super.m_6227_(state, worldIn, pos, player, handIn, hit);
        if (result.m_19077_()) {
            this.updateNeighbors(state, worldIn, pos);
            return result;
        }
        if (worldIn.f_46443_) {
            state.m_61122_((Property)POWERED);
            return InteractionResult.SUCCESS;
        }
        BlockState blockstate = this.setPowered(state, worldIn, pos);
        boolean enabled = (Boolean)blockstate.m_61143_((Property)POWERED);
        float f = enabled ? 0.6f : 0.5f;
        worldIn.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, f);
        worldIn.m_142346_((Entity)player, enabled ? GameEvent.f_223702_ : GameEvent.f_223703_, pos);
        return InteractionResult.CONSUME;
    }

    public BlockState setPowered(BlockState state, Level world, BlockPos pos) {
        state = (BlockState)state.m_61122_((Property)POWERED);
        world.m_7731_(pos, state, 3);
        this.updateNeighbors(state, world, pos);
        return state;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.m_60713_(newState.m_60734_()) && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            this.updateNeighbors(state, worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)POWERED) ^ (Boolean)blockState.m_61143_((Property)LIT) == false ? 15 : 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)POWERED) ^ (Boolean)blockState.m_61143_((Property)LIT) == false && SconceLeverBlock.getFacing(blockState) == side ? 15 : 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    private void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.m_46672_(pos, (Block)this);
        world.m_46672_(pos.m_121945_(SconceLeverBlock.getFacing(state).m_122424_()), (Block)this);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    protected static Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    @Override
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)stateIn.m_61143_((Property)POWERED)).booleanValue()) {
            super.animateTick(stateIn, worldIn, pos, rand);
        } else if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            Direction direction = (Direction)stateIn.m_61143_((Property)FACING);
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.65;
            double d2 = (double)pos.m_123343_() + 0.5;
            Direction direction1 = direction.m_122424_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + 0.125 * (double)direction1.m_122429_(), d1 + 0.15, d2 + 0.125 * (double)direction1.m_122431_(), 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)this.particleData.get(), d0 + 0.125 * (double)direction1.m_122429_(), d1 + 0.15, d2 + 0.125 * (double)direction1.m_122431_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean lightUp(Entity entity, BlockState state, BlockPos pos, LevelAccessor world, ILightable.FireSound sound) {
        boolean ret = super.lightUp(entity, state, pos, world, sound);
        if (ret && world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            this.updateNeighbors(state, (Level)level, pos);
        }
        return ret;
    }

    @Override
    public boolean extinguish(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world) {
        boolean ret = super.extinguish(player, state, pos, world);
        if (ret && world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            this.updateNeighbors(state, (Level)level, pos);
        }
        return ret;
    }
}

