/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MimicBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.RopeKnotBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RopeKnotBlock
extends MimicBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    private final Map<BlockState, VoxelShape> SHAPES_MAP = new HashMap<BlockState, VoxelShape>();
    private final Map<BlockState, VoxelShape> COLLISION_SHAPES_MAP = new HashMap<BlockState, VoxelShape>();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<ModBlockProperties.PostType> POST_TYPE = ModBlockProperties.POST_TYPE;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    protected static final Map<Direction, BooleanProperty> FENCE_PROPERTY = (Map)PipeBlock.f_55154_.entrySet().stream().filter(d -> ((Direction)d.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    protected static final Map<Direction, EnumProperty<WallSide>> WALL_PROPERTY = ImmutableMap.of((Object)Direction.NORTH, (Object)WallBlock.f_57951_, (Object)Direction.SOUTH, (Object)WallBlock.f_57952_, (Object)Direction.WEST, (Object)WallBlock.f_57953_, (Object)Direction.EAST, (Object)WallBlock.f_57950_);

    public RopeKnotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.makeShapes();
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(POST_TYPE, (Comparable)((Object)ModBlockProperties.PostType.POST))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, POST_TYPE, AXIS, NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new RopeKnotBlockTile(pPos, pState);
    }

    public boolean m_49967_() {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            return tile.getShape();
        }
        return super.m_5940_(state, world, pos, context);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.SHAPES_MAP.getOrDefault(state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), Shapes.m_83144_());
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.SHAPES_MAP.getOrDefault(state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), Shapes.m_83144_());
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            return tile.getCollisionShape();
        }
        return super.m_5939_(state, world, pos, context);
    }

    protected void makeShapes() {
        VoxelShape down = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape up = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = Block.m_49796_((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape south = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)16.0);
        VoxelShape west = Block.m_49796_((double)0.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape east = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
        for (BlockState state : this.f_49792_.m_61056_()) {
            VoxelShape v;
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) continue;
            int w = ((ModBlockProperties.PostType)((Object)state.m_61143_(POST_TYPE))).getWidth();
            int o = (16 - w) / 2;
            VoxelShape c = switch ((Direction.Axis)state.m_61143_(AXIS)) {
                default -> {
                    v = Block.m_49796_((double)o, (double)0.0, (double)o, (double)(o + w), (double)16.0, (double)(o + w));
                    yield Block.m_49796_((double)o, (double)0.0, (double)o, (double)(o + w), (double)24.0, (double)(o + w));
                }
                case Direction.Axis.X -> v = Block.m_49796_((double)0.0, (double)o, (double)o, (double)16.0, (double)(o + w), (double)(o + w));
                case Direction.Axis.Z -> v = Block.m_49796_((double)o, (double)o, (double)0.0, (double)(o + w), (double)(o + w), (double)16.0);
            };
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)down);
            }
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)up);
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)north);
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)south);
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)west);
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)east);
            }
            c = Shapes.m_83110_((VoxelShape)c, (VoxelShape)v);
            c = c.m_83296_();
            v = v.m_83296_();
            boolean flag = true;
            for (VoxelShape existing : this.SHAPES_MAP.values()) {
                if (!existing.equals(v)) continue;
                this.SHAPES_MAP.put(state, existing);
                flag = false;
                break;
            }
            if (flag) {
                this.SHAPES_MAP.put(state, v);
            }
            boolean flag2 = true;
            for (VoxelShape existing : this.COLLISION_SHAPES_MAP.values()) {
                if (!existing.equals(c)) continue;
                this.COLLISION_SHAPES_MAP.put(state, existing);
                flag2 = false;
                break;
            }
            if (!flag2) continue;
            this.COLLISION_SHAPES_MAP.put(state, c);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        BlockState newState = (BlockState)state.m_61124_((Property)RopeBlock.FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(RopeBlock.shouldConnectToFace(state, facingState, facingPos, facing, (LevelReader)world)));
        BlockEntity blockEntity = world.m_7702_(currentPos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            BlockState newFacing;
            BlockEntity blockEntity2;
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            BlockState oldHeld = tile.getHeldBlock();
            RopeKnotBlockTile otherTile = null;
            if (facingState.m_60713_(ModRegistry.ROPE_KNOT.get()) && (blockEntity2 = world.m_7702_(facingPos)) instanceof RopeKnotBlockTile) {
                RopeKnotBlockTile te2;
                otherTile = te2 = (RopeKnotBlockTile)blockEntity2;
                facingState = otherTile.getHeldBlock();
            }
            BlockState newHeld = null;
            if (CompatHandler.quark) {
                newHeld = QuarkCompat.updateWoodPostShape(oldHeld, facing, facingState);
            }
            if (newHeld == null) {
                newHeld = oldHeld.m_60728_(facing, facingState, world, currentPos, facingPos);
            }
            if ((newFacing = facingState.m_60728_(facing.m_122424_(), newHeld, world, facingPos, currentPos)) != facingState) {
                if (otherTile != null) {
                    otherTile.setHeldBlock(newFacing);
                    otherTile.m_6596_();
                } else {
                    world.m_7731_(facingPos, newFacing, 2);
                }
            }
            ModBlockProperties.PostType type = ModBlockProperties.PostType.get(newHeld);
            if (newHeld != oldHeld) {
                tile.setHeldBlock(newHeld);
                tile.m_6596_();
            }
            if (newState != state) {
                tile.recalculateShapes(newState);
            }
            if (type != null) {
                newState = (BlockState)newState.m_61124_(POST_TYPE, (Comparable)((Object)type));
            }
        }
        return newState;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (rotation == Rotation.CLOCKWISE_180) {
            return state;
        }
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Direction.Axis.X -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
            case Direction.Axis.Z -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
            default -> state;
        };
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        if (player.m_21120_(hand).m_41720_() instanceof ShearsItem) {
            BlockEntity blockEntity;
            if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof RopeKnotBlockTile) {
                RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
                RopeKnotBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModRegistry.ROPE.get()));
                world.m_5594_(null, pos, SoundEvents.f_12480_, SoundSource.PLAYERS, 0.8f, 1.3f);
                world.m_7731_(pos, tile.getHeldBlock(), 3);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            return mimic.m_60734_().m_7397_(level, pos, state);
        }
        return super.m_7397_(level, pos, state);
    }

    @Nullable
    public static BlockState convertToRopeKnot(ModBlockProperties.PostType type, BlockState state, Level world, BlockPos pos) {
        Direction.Axis axis = Direction.Axis.Y;
        if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
        }
        BlockState newState = (BlockState)((BlockState)ModRegistry.ROPE_KNOT.get().m_49966_().m_61124_(AXIS, (Comparable)axis)).m_61124_(POST_TYPE, (Comparable)((Object)type));
        if (!world.m_7731_(pos, newState = Block.m_49931_((BlockState)newState, (LevelAccessor)world, (BlockPos)pos), 0)) {
            return null;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            tile.setHeldBlock(state);
            tile.m_6596_();
        }
        newState.m_60701_((LevelAccessor)world, pos, 6);
        return newState;
    }
}

