/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class JarBlock
extends WaterBlock
implements EntityBlock {
    public static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), (VoxelShape)Block.m_49796_((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL_0_15;

    public JarBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> (Integer)state.m_61143_((Property)LIGHT_LEVEL)));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public int getJarLiquidColor(BlockPos pos, LevelReader world) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof JarBlockTile) {
            JarBlockTile tile = (JarBlockTile)te;
            return tile.fluidHolder.getParticleColor(world, pos);
        }
        return 0xFFFFFF;
    }

    @PlatformOnly(value={"forge"})
    public float[] getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        int color = this.getJarLiquidColor(pos, world);
        if (color == -1) {
            return null;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b2};
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        JarBlockTile tile;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof JarBlockTile && (tile = (JarBlockTile)blockEntity).isAccessibleBy(player)) {
            if (tile.handleInteraction(player, handIn, worldIn, pos)) {
                if (!worldIn.m_5776_()) {
                    tile.m_6596_();
                }
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
            if (CommonConfigs.Blocks.JAR_CAPTURE.get().booleanValue()) {
                return tile.mobContainer.onInteract(worldIn, pos, player, handIn);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof JarBlockTile) {
            JarBlockTile tile = (JarBlockTile)blockEntity;
            if (stack.m_41788_()) {
                tile.m_58638_(stack.m_41786_());
            }
            BlockUtil.addOptionalOwnership(placer, tile);
        }
    }

    public ItemStack getJarItem(JarBlockTile te) {
        ItemStack returnStack = new ItemStack((ItemLike)this);
        if (te.hasContent()) {
            CompoundTag compoundTag = te.m_187482_();
            if (compoundTag.m_128441_("Owner")) {
                compoundTag.m_128473_("Owner");
            }
            if (!compoundTag.m_128456_()) {
                returnStack.m_41700_("BlockEntityTag", (Tag)compoundTag);
            }
        }
        if (te.m_8077_()) {
            returnStack.m_41714_(te.m_7770_());
        }
        return returnStack;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof JarBlockTile) {
            JarBlockTile tile = (JarBlockTile)object;
            ItemStack itemstack = this.getJarItem(tile);
            return Collections.singletonList(itemstack);
        }
        return super.m_7381_(state, builder);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof JarBlockTile) {
            JarBlockTile tile = (JarBlockTile)blockEntity;
            return this.getJarItem(tile);
        }
        return super.m_7397_(level, pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIGHT_LEVEL, FACING, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        return tileEntity instanceof MenuProvider ? (MenuProvider)tileEntity : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new JarBlockTile(pPos, pState);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof JarBlockTile) {
            JarBlockTile tile = (JarBlockTile)blockEntity;
            if (!tile.m_7983_()) {
                return AbstractContainerMenu.m_38938_((Container)tile);
            }
            if (!tile.fluidHolder.isEmpty()) {
                return tile.fluidHolder.getComparatorOutput();
            }
            if (!tile.mobContainer.isEmpty()) {
                return 15;
            }
        }
        return 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BlockUtil.getTicker(pBlockEntityType, ModRegistry.JAR_TILE.get(), JarBlockTile::tick);
    }
}

