/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.renderers.GlobeTextureManager;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class GlobeBlockTileRenderer
implements BlockEntityRenderer<GlobeBlockTile> {
    private final Map<GlobeBlockTile.GlobeModel, ModelPart> models = new HashMap<GlobeBlockTile.GlobeModel, ModelPart>();
    public static GlobeBlockTileRenderer INSTANCE = null;

    public static LayerDefinition createBaseMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("globe", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)16);
    }

    public static LayerDefinition createSpecialMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("flat", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -28.0f, -4.0f, 8.0f, 4.0f, 8.0f).m_171514_(0, 13).m_171481_(-4.0f, -24.0f, -4.0f, 8.0f, 2.0f, 8.0f).m_171514_(4, 23).m_171481_(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f).m_171514_(8, 24).m_171481_(-2.0f, -21.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        root.m_171599_("sheared", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 4.0f).m_171514_(0, 12).m_171481_(0.0f, -28.0f, 0.0f, 4.0f, 8.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition snow = root.m_171599_("snow", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -28.0f, -4.0f, 8.0f, 5.0f, 8.0f).m_171514_(0, 14).m_171481_(-4.0f, -23.0f, -4.0f, 8.0f, 1.0f, 8.0f).m_171514_(4, 16).m_171481_(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f).m_171514_(0, 17).m_171481_(-2.0f, -24.0f, -2.0f, 4.0f, 1.0f, 4.0f).m_171514_(0, 28).m_171481_(-1.0f, -25.975f, -1.0f, 2.0f, 2.0f, 2.0f).m_171514_(12, 20).m_171481_(-1.0f, -21.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        snow.m_171599_("roof_l", CubeListBuilder.m_171558_().m_171514_(11, 27).m_171481_(0.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-25.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        snow.m_171599_("roof_r", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(-2.0f, -1.0f, -1.0f, 3.0f, 1.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-25.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public GlobeBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart model = context.m_173582_(ClientRegistry.GLOBE_BASE_MODEL);
        this.models.put(GlobeBlockTile.GlobeModel.GLOBE, model.m_171324_("globe"));
        ModelPart special = context.m_173582_(ClientRegistry.GLOBE_SPECIAL_MODEL);
        this.models.put(GlobeBlockTile.GlobeModel.FLAT, special.m_171324_("flat"));
        this.models.put(GlobeBlockTile.GlobeModel.SNOW, special.m_171324_("snow"));
        this.models.put(GlobeBlockTile.GlobeModel.SHEARED, special.m_171324_("sheared"));
        INSTANCE = this;
    }

    public void render(GlobeBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        matrixStackIn.m_85845_(RotHlpr.rot((Direction)tile.getDirection()));
        matrixStackIn.m_85845_(RotHlpr.XN90);
        matrixStackIn.m_85837_(0.0, 0.0625, 0.0);
        matrixStackIn.m_85845_(RotHlpr.XN22);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)(tile.prevYaw + (float)tile.face), (float)(tile.yaw + (float)tile.face))));
        this.renderGlobe(tile.renderData, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, tile.isSepia(), tile.m_58904_());
        matrixStackIn.m_85849_();
    }

    public void renderGlobe(Pair<GlobeBlockTile.GlobeModel, ResourceLocation> data, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, boolean isSepia, Level level) {
        if (data == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85845_(RotHlpr.X180);
        ResourceLocation texture = ClientConfigs.Blocks.GLOBE_RANDOM.get() != false ? (ResourceLocation)data.getSecond() : GlobeBlockTile.GlobeType.EARTH.texture;
        ModelPart model = this.models.get(data.getFirst());
        VertexConsumer builder = texture == null ? buffer.m_6299_(GlobeTextureManager.getRenderType(level, isSepia)) : buffer.m_6299_(RenderType.m_110452_((ResourceLocation)texture));
        model.m_104306_(poseStack, builder, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

