/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.capabilities.mob_container.MobContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;

public class CapturedMobCache {
    public static LoadingCache<UUID, Entity> MOB_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<UUID, Entity>(){

        public Entity load(UUID key) {
            return null;
        }
    });
    public static final Supplier<EndCrystal> PEDESTAL_CRYSTAL = Suppliers.memoize(() -> {
        EndCrystal entity = new EndCrystal(EntityType.f_20564_, (Level)Minecraft.m_91087_().f_91073_);
        entity.m_31056_(false);
        return entity;
    });
    private static final Supplier<Entity> DEFAULT_PIG = Suppliers.memoize(() -> new Pig(EntityType.f_20510_, (Level)Minecraft.m_91087_().f_91073_));

    public static void addMob(Entity e) {
        if (e == null) {
            e = DEFAULT_PIG.get();
        }
        MOB_CACHE.put((Object)e.m_20148_(), (Object)e);
    }

    @Nullable
    public static Entity getOrCreateCachedMob(UUID id, CompoundTag tag) {
        ClientLevel world;
        Entity e = (Entity)MOB_CACHE.getIfPresent((Object)id);
        if (e == null && (world = Minecraft.m_91087_().f_91073_) != null) {
            CompoundTag mobData = tag.m_128469_("EntityData");
            e = MobContainer.createEntityFromNBT(mobData, id, (Level)world);
            CapturedMobCache.addMob(e);
        }
        return e;
    }

    public static void tickCrystal() {
        ++CapturedMobCache.PEDESTAL_CRYSTAL.get().f_31032_;
    }
}

