/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.supplementaries.common.ModTextures;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BlackboardTextureManager {
    private static final TextureManager TEXTURE_MANAGER = Minecraft.m_91087_().m_91097_();
    private static final LoadingCache<BlackboardKey, TextureInstance> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).removalListener(i -> {
        TextureInstance value = (TextureInstance)i.getValue();
        if (value != null) {
            value.close();
        }
    }).build((CacheLoader)new CacheLoader<BlackboardKey, TextureInstance>(){

        public TextureInstance load(BlackboardKey key) {
            return null;
        }
    });

    public static TextureInstance getBlackboardInstance(BlackboardKey key) {
        TextureInstance textureInstance = (TextureInstance)TEXTURE_CACHE.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new TextureInstance(BlackboardBlockTile.unpackPixels(key.values));
            TEXTURE_CACHE.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    public static TextureInstance getBlackboardInstance(long[] packed) {
        return BlackboardTextureManager.getBlackboardInstance(new BlackboardKey(packed));
    }

    public static TextureInstance getBlackboardInstance(BlackboardBlockTile tile) {
        return BlackboardTextureManager.getBlackboardInstance(tile.getTextureKey());
    }

    private static int getColoredPixel(byte i, int x, int y) {
        int offset = i > 0 ? 16 : 0;
        int tint = BlackboardBlock.colorFromByte(i);
        TextureAtlas textureMap = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_);
        TextureAtlasSprite sprite = textureMap.m_118316_(ModTextures.BLACKBOARD_TEXTURE);
        return BlackboardTextureManager.getTintedColor(sprite, x, y, offset, tint);
    }

    private static int getTintedColor(TextureAtlasSprite sprite, int x, int y, int offset, int tint) {
        if (sprite == null || sprite.m_118415_() == 0) {
            return -1;
        }
        int tintR = tint >> 16 & 0xFF;
        int tintG = tint >> 8 & 0xFF;
        int tintB = tint & 0xFF;
        int pixel = ClientPlatformHelper.getPixelRGBA((TextureAtlasSprite)sprite, (int)0, (int)Math.min(sprite.m_118405_() - 1, x + offset), (int)Math.min(sprite.m_118408_() - 1, y));
        int totalB = pixel >> 16 & 0xFF;
        int totalG = pixel >> 8 & 0xFF;
        int totalR = pixel & 0xFF;
        return NativeImage.m_84992_((int)255, (int)(totalB * tintB / 255), (int)(totalG * tintG / 255), (int)(totalR * tintR / 255));
    }

    public static class TextureInstance
    implements AutoCloseable {
        private static final int WIDTH = 16;
        private final Map<Direction, List<BakedQuad>> models = new HashMap<Direction, List<BakedQuad>>();
        private final byte[][] pixels;
        @Nullable
        private DynamicTexture texture;
        @Nullable
        private RenderType renderType;
        @Nullable
        private ResourceLocation textureLocation;

        private TextureInstance(byte[][] pixels) {
            this.pixels = pixels;
        }

        private void initializeTexture() {
            this.texture = new DynamicTexture(16, 16, false);
            for (int y = 0; y < this.pixels.length && y < 16; ++y) {
                for (int x = 0; x < this.pixels[y].length && x < 16; ++x) {
                    this.texture.m_117991_().m_84988_(x, y, BlackboardTextureManager.getColoredPixel(this.pixels[x][y], x, y));
                }
            }
            this.texture.m_117985_();
            this.textureLocation = TEXTURE_MANAGER.m_118490_("blackboard/", this.texture);
            this.renderType = RenderType.m_110446_((ResourceLocation)this.textureLocation);
        }

        @Nonnull
        public List<BakedQuad> getOrCreateModel(Direction dir, Function<byte[][], List<BakedQuad>> modelFactory) {
            if (!this.models.containsKey(dir)) {
                this.models.put(dir, modelFactory.apply(this.pixels));
            }
            return this.models.get(dir);
        }

        @Nonnull
        public ResourceLocation getTextureLocation() {
            if (this.textureLocation == null) {
                this.initializeTexture();
            }
            return this.textureLocation;
        }

        @Nonnull
        public RenderType getRenderType() {
            if (this.renderType == null) {
                this.initializeTexture();
            }
            return this.renderType;
        }

        @Override
        public void close() {
            if (this.texture != null) {
                this.texture.close();
            }
            if (this.textureLocation != null) {
                TEXTURE_MANAGER.m_118513_(this.textureLocation);
            }
        }
    }

    public static class BlackboardKey {
        private final long[] values;

        public BlackboardKey(long[] packed) {
            this.values = packed;
        }

        public BlackboardKey(byte[][] pixels) {
            this.values = BlackboardBlockTile.packPixels(pixels);
        }

        public byte[][] unpackValues() {
            return BlackboardBlockTile.unpackPixels(this.values);
        }

        public boolean equals(Object another) {
            if (another == this) {
                return true;
            }
            if (another == null) {
                return false;
            }
            if (another.getClass() != this.getClass()) {
                return false;
            }
            BlackboardKey key = (BlackboardKey)another;
            return Arrays.equals(this.values, key.values);
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }
}

