/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui.widgets;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.supplementaries.common.ModTextures;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class BlackBoardButton
extends GuiComponent
implements Widget,
GuiEventListener,
NarratableEntry {
    public int u;
    public int v;
    public int x;
    public int y;
    public static final int WIDTH = 6;
    private boolean wasHovered;
    protected boolean isHovered;
    public byte color = 0;
    private boolean focused;
    private final IDraggable onDragged;
    protected final IPressable onPress;

    public BlackBoardButton(int center_x, int center_y, int u, int v, IPressable pressedAction, IDraggable dragAction) {
        this.x = center_x - (8 - u) * 6;
        this.y = center_y - -v * 6;
        this.u = u;
        this.v = v;
        this.onPress = pressedAction;
        this.onDragged = dragAction;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.isHovered = this.m_5953_(mouseX, mouseY);
        this.renderButton(matrixStack);
        this.wasHovered = this.isHovered();
    }

    public void renderButton(PoseStack matrixStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ModTextures.BLACKBOARD_GUI_TEXTURE);
        int offset = this.color > 0 ? 16 : 0;
        int rgb = BlackboardBlock.colorFromByte(this.color);
        float b2 = (float)NativeImage.m_85085_((int)rgb) / 255.0f;
        float g = (float)NativeImage.m_85103_((int)rgb) / 255.0f;
        float r = (float)NativeImage.m_85119_((int)rgb) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b2, (float)1.0f);
        BlackBoardButton.m_93133_((PoseStack)matrixStack, (int)this.x, (int)this.y, (float)((this.u + offset) * 6), (float)(this.v * 6), (int)6, (int)6, (int)192, (int)96);
    }

    public void renderTooltip(PoseStack matrixStack) {
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        BlackBoardButton.m_93133_((PoseStack)matrixStack, (int)(this.x - 1), (int)(this.y - 1), (float)96.0f, (float)0.0f, (int)8, (int)8, (int)192, (int)96);
        this.renderButton(matrixStack);
    }

    public void onClick(double mouseX, double mouseY) {
        this.color = (byte)(this.color == 0 ? 1 : 0);
        this.onPress.onPress(this.u, this.v, this.color != 0);
    }

    public void onRelease(double mouseX, double mouseY) {
    }

    public void onDrag(double mouseX, double mouseY, boolean on) {
        this.color = (byte)(on ? 1 : 0);
        this.onPress.onPress(this.u, this.v, this.color != 0);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean flag;
        if (this.isValidClickButton(button) && (flag = this.m_5953_(mouseX, mouseY))) {
            this.playDownSound(Minecraft.m_91087_().m_91106_());
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClickButton(button)) {
            this.onDragged.onDragged(mouseX, mouseY, this.color != 0);
            return true;
        }
        return false;
    }

    public boolean isHovered() {
        return this.isHovered || this.focused;
    }

    public boolean m_5755_(boolean focus) {
        this.focused = !this.focused;
        return this.focused;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + 6) && mouseY < (double)(this.y + 6);
    }

    public void playDownSound(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    public static interface IPressable {
        public void onPress(int var1, int var2, boolean var3);
    }

    public static interface IDraggable {
        public void onDragged(double var1, double var3, boolean var5);
    }
}

