/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.gui.widgets.BlackBoardButton;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetBlackboardPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class BlackBoardGui
extends Screen {
    private final BlackboardBlockTile tileBoard;
    private final BlackBoardButton[][] buttons = new BlackBoardButton[16][16];

    private BlackBoardGui(BlackboardBlockTile teBoard) {
        super((Component)Component.m_237115_((String)"gui.supplementaries.blackboard.edit"));
        this.tileBoard = teBoard;
    }

    public static void open(BlackboardBlockTile sign) {
        Minecraft.m_91087_().m_91152_((Screen)new BlackBoardGui(sign));
    }

    public void m_86600_() {
        if (!this.tileBoard.m_58903_().m_155262_(this.tileBoard.m_58900_())) {
            this.close();
        }
    }

    public void m_7379_() {
        this.close();
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
        byte[][] pixels = new byte[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].color;
            }
        }
        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundSetBlackboardPacket(this.tileBoard.m_58899_(), pixels));
    }

    private void close() {
        this.tileBoard.m_6596_();
        this.f_96541_.m_91152_(null);
    }

    public void setPixel(int x, int y, boolean on) {
        this.tileBoard.setPixel(x, y, (byte)(on ? 1 : 0));
    }

    public void dragButtons(double mx, double my, boolean on) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (!this.buttons[xx][yy].m_5953_(mx, my)) continue;
                this.buttons[xx][yy].onDrag(mx, my, on);
            }
        }
    }

    private void clear() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.setPixel(xx, yy, false);
                this.buttons[xx][yy].color = 0;
            }
        }
    }

    protected void m_7856_() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy] = new BlackBoardButton(this.f_96543_ / 2, 65, xx, yy, this::setPixel, this::dragButtons);
                this.m_7787_(this.buttons[xx][yy]);
                this.buttons[xx][yy].color = this.tileBoard.getPixel(xx, yy);
            }
        }
        this.f_96541_.f_91068_.m_90926_(true);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120, 96, 20, (Component)Component.m_237115_((String)"gui.supplementaries.blackboard.clear"), b2 -> this.clear()));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 4, this.f_96544_ / 4 + 120, 96, 20, CommonComponents.f_130655_, p_238847_1_ -> this.close()));
    }

    public void m_6305_(PoseStack matrixstack, int mouseX, int mouseY, float partialTicks) {
        Lighting.m_84930_();
        this.m_7333_(matrixstack);
        BlackBoardGui.m_93215_((PoseStack)matrixstack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)40, (int)0xFFFFFF);
        matrixstack.m_85836_();
        int ut = -1;
        int vt = -1;
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (this.buttons[xx][yy].isHovered()) {
                    ut = xx;
                    vt = yy;
                }
                this.buttons[xx][yy].m_6305_(matrixstack, mouseX, mouseY, partialTicks);
            }
        }
        if (ut != -1) {
            this.buttons[ut][vt].renderTooltip(matrixstack);
        }
        matrixstack.m_85849_();
        Lighting.m_84931_();
        super.m_6305_(matrixstack, mouseX, mouseY, partialTicks);
    }
}

