/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.supplementaries.client.WallLanternTexturesRegistry;
import net.mehvahdjukaar.supplementaries.client.renderers.VertexUtils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MimicBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.WallLanternBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class WallLanternBakedModel
implements CustomBakedModel {
    private final BakedModel support;
    private final BlockModelShaper blockModelShaper;

    public WallLanternBakedModel(BakedModel support) {
        this.support = support;
        this.blockModelShaper = Minecraft.m_91087_().m_91289_().m_110907_();
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BlockState mimic = null;
        try {
            mimic = (BlockState)data.get(ModBlockProperties.MIMIC);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            List<BakedQuad> supportQuads = this.support.m_213637_(state, side, rand);
            if (!supportQuads.isEmpty()) {
                TextureAtlasSprite sprite;
                if (mimic != null && (sprite = WallLanternTexturesRegistry.getTextureForLantern(mimic.m_60734_())) != null) {
                    supportQuads = VertexUtils.swapSprite(supportQuads, sprite);
                }
                quads.addAll((Collection<BakedQuad>)supportQuads);
            }
        }
        catch (Exception supportQuads) {
            // empty catch block
        }
        try {
            boolean fancy = Boolean.TRUE.equals(data.get(ModBlockProperties.FANCY));
            if (!(fancy || mimic == null || mimic.m_60734_() instanceof MimicBlock || mimic.m_60795_() || state == null)) {
                Direction dir = (Direction)state.m_61143_((Property)WallLanternBlock.FACING);
                if (mimic.m_61138_((Property)BlockStateProperties.f_61372_)) {
                    mimic = (BlockState)mimic.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)dir);
                } else if (mimic.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    mimic = (BlockState)mimic.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)dir);
                }
                BakedModel model = this.blockModelShaper.m_110893_(mimic);
                List mimicQuads = model.m_213637_(mimic, side, rand);
                for (BakedQuad q : mimicQuads) {
                    int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
                    VertexUtils.moveVertices(v, Direction.UP, 0.125f);
                    VertexUtils.moveVertices(v, dir, -0.125f);
                    quads.add(new BakedQuad(v, q.m_111305_(), q.m_111306_(), q.m_173410_(), q.m_111307_()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return quads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        BlockState mimic = (BlockState)data.get(ModBlockProperties.MIMIC);
        if (mimic != null && !mimic.m_60795_()) {
            BakedModel model = this.blockModelShaper.m_110893_(mimic);
            try {
                return model.m_6160_();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.support.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }
}

