/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.supplementaries.client.renderers.VertexUtils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class HangingSignBakedModel
implements CustomBakedModel {
    private final EnumMap<ModBlockProperties.SignAttachment, ImmutableList<BakedModel>> attachmentMap;
    private final BakedModel particle;
    private final BlockModelShaper blockModelShaper;

    public HangingSignBakedModel(BakedModel stick, BakedModel leftPost, BakedModel leftPalisade, BakedModel leftWall, BakedModel leftBeam, BakedModel leftStick, BakedModel rightPost, BakedModel rightPalisade, BakedModel rightWall, BakedModel rightBeam, BakedModel rightStick) {
        HashMap<ModBlockProperties.SignAttachment, ImmutableList> temp = new HashMap<ModBlockProperties.SignAttachment, ImmutableList>();
        for (ModBlockProperties.SignAttachment a : ModBlockProperties.SignAttachment.values()) {
            ImmutableList.Builder b2 = ImmutableList.builder();
            if (a != ModBlockProperties.SignAttachment.CEILING) {
                b2.add((Object)stick);
                switch (a.left) {
                    case POST: {
                        b2.add((Object)leftPost);
                        break;
                    }
                    case PALISADE: {
                        b2.add((Object)leftPalisade);
                        break;
                    }
                    case WALL: {
                        b2.add((Object)leftWall);
                        break;
                    }
                    case BEAM: {
                        b2.add((Object)leftBeam);
                        break;
                    }
                    case STICK: {
                        b2.add((Object)leftStick);
                    }
                }
                switch (a.right) {
                    case POST: {
                        b2.add((Object)rightPost);
                        break;
                    }
                    case PALISADE: {
                        b2.add((Object)rightPalisade);
                        break;
                    }
                    case WALL: {
                        b2.add((Object)rightWall);
                        break;
                    }
                    case BEAM: {
                        b2.add((Object)rightBeam);
                        break;
                    }
                    case STICK: {
                        b2.add((Object)rightStick);
                    }
                }
            }
            temp.put(a, b2.build());
        }
        this.attachmentMap = Maps.newEnumMap(temp);
        this.particle = stick;
        this.blockModelShaper = Minecraft.m_91087_().m_91289_().m_110907_();
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        Block block;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (state != null && (block = state.m_60734_()) instanceof HangingSignBlock) {
            HangingSignBlock hs = (HangingSignBlock)block;
            try {
                ModBlockProperties.SignAttachment a = (ModBlockProperties.SignAttachment)((Object)state.m_61143_(HangingSignBlock.ATTACHMENT));
                this.attachmentMap.get((Object)a).forEach(b2 -> quads.addAll(b2.m_213637_(state, side, rand)));
            }
            catch (Exception a) {
                // empty catch block
            }
            try {
                boolean fancy = Boolean.TRUE.equals(data.get(ModBlockProperties.FANCY));
                if (!fancy) {
                    boolean ceiling;
                    BakedModel model = ClientPlatformHelper.getModel((ModelManager)this.blockModelShaper.m_110881_(), (ResourceLocation)ClientRegistry.HANGING_SIGNS_BLOCK_MODELS.get(hs.woodType));
                    if (model.m_6160_() instanceof MissingTextureAtlasSprite) {
                        return quads;
                    }
                    List signQuads = model.m_213637_(state, side, rand);
                    boolean flipped = state.m_61143_(HangingSignBlock.AXIS) == Direction.Axis.X;
                    boolean bl = ceiling = state.m_61143_(HangingSignBlock.ATTACHMENT) == ModBlockProperties.SignAttachment.CEILING;
                    if (flipped || ceiling) {
                        for (BakedQuad q : signQuads) {
                            int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
                            Direction dir = q.m_111306_();
                            if (flipped) {
                                VertexUtils.rotateVerticesY(v, q.m_173410_(), Rotation.CLOCKWISE_90);
                                if (dir.m_122434_() != Direction.Axis.Y) {
                                    dir = dir.m_122427_();
                                }
                            }
                            if (ceiling) {
                                VertexUtils.moveVertices(v, 0.0f, 0.125f, 0.0f);
                            }
                            quads.add(new BakedQuad(v, q.m_111305_(), dir, q.m_173410_(), q.m_111307_()));
                        }
                    } else {
                        quads.addAll(signQuads);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return quads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        return this.particle.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }
}

