/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.supplementaries.client.renderers.BlackboardTextureManager;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlackboardBakedModel
implements CustomBakedModel {
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelTransform;
    private final BakedModel back;
    private final BlockModel owner;

    public BlackboardBakedModel(BlockModel owner, BakedModel baked, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform) {
        this.back = baked;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.owner = owner;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        return this.back.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.back.m_213637_(state, side, rand));
        if (data != ExtraModelData.EMPTY && state != null && side == null) {
            Direction dir = (Direction)state.m_61143_((Property)BlackboardBlock.FACING);
            BlackboardTextureManager.BlackboardKey key = (BlackboardTextureManager.BlackboardKey)data.get(BlackboardBlockTile.BLACKBOARD);
            if (key != null) {
                BlackboardTextureManager.TextureInstance blackboard = BlackboardTextureManager.getBlackboardInstance(key);
                quads.addAll(blackboard.getOrCreateModel(dir, b2 -> this.generateQuads((byte[][])b2, this.modelTransform)));
            }
        }
        return quads;
    }

    private List<BakedQuad> generateQuads(byte[][] pixels, ModelState modelTransform) {
        ArrayList<BakedQuad> quads;
        try (TextureAtlasSprite black = this.spriteGetter.apply(this.owner.m_111480_("black"));
             TextureAtlasSprite white = this.spriteGetter.apply(this.owner.m_111480_("white"));){
            quads = new ArrayList<BakedQuad>();
            Transformation rotation = modelTransform.m_6189_();
            for (int x = 0; x < pixels.length; ++x) {
                int length = 0;
                int startY = 0;
                byte prevColor = pixels[0][x];
                for (int y = 0; y <= pixels[x].length; ++y) {
                    Byte current = null;
                    if (y < pixels[x].length) {
                        byte b2 = pixels[x][y];
                        if (prevColor == b2) {
                            ++length;
                            continue;
                        }
                        current = b2;
                    }
                    int tint = 0xFF000000 | BlackboardBlock.colorFromByte(prevColor);
                    TextureAtlasSprite sprite = prevColor == 0 ? black : white;
                    quads.add(BlackboardBakedModel.createPixelQuad((float)(15 - x) / 16.0f, (float)(16 - length - startY) / 16.0f, 0.6875f, 0.0625f, (float)length / 16.0f, sprite, tint, rotation));
                    startY = y;
                    if (current != null) {
                        prevColor = current;
                    }
                    length = 1;
                }
            }
        }
        return quads;
    }

    public static BakedQuad createPixelQuad(float x, float y, float z, float width, float height, TextureAtlasSprite sprite, int color, Transformation transform) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, -1.0f);
        BakedQuadBuilder builder = BakedQuadBuilder.create();
        BakedQuadBuilder.applyModelRotation((float)0.0f, (float)0.0f, (float)-1.0f, (Matrix4f)transform.m_121104_());
        float tu = (float)sprite.m_118405_() * width;
        float tv = (float)sprite.m_118408_() * height;
        float u0 = x * 16.0f;
        float v0 = y * 16.0f;
        color = -1;
        builder.setDirection(Direction.m_122372_((float)normal.m_122239_(), (float)normal.m_122260_(), (float)normal.m_122269_()));
        builder.setSprite(sprite);
        BlackboardBakedModel.putVertex(builder, normal, x + width, y + height, z, u0 + tu, v0 + tv, sprite, color, transform);
        BlackboardBakedModel.putVertex(builder, normal, x + width, y, z, u0 + tu, v0, sprite, color, transform);
        BlackboardBakedModel.putVertex(builder, normal, x, y, z, u0, v0, sprite, color, transform);
        BlackboardBakedModel.putVertex(builder, normal, x, y + height, z, u0, v0 + tv, sprite, color, transform);
        return builder.build();
    }

    private static void putVertex(BakedQuadBuilder builder, Vector3f normal, float x, float y, float z, float u, float v, TextureAtlasSprite sprite, int color, Transformation transformation) {
        Vector3f posV = BakedQuadBuilder.applyModelRotation((float)x, (float)y, (float)z, (Matrix4f)transformation.m_121104_());
        builder.pos(posV);
        builder.color(color);
        builder.uv(sprite.m_118367_((double)u), sprite.m_118393_((double)v));
        builder.normal(normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
        builder.endVertex();
    }
}

