/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.JarBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class WallLanternTexturesRegistry
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<Block, ResourceLocation> SPECIAL_TEXTURES = new HashMap<Block, ResourceLocation>();
    private static Set<Block> POSSIBLE_LANTERNS = null;
    public static final WallLanternTexturesRegistry RELOAD_INSTANCE = new WallLanternTexturesRegistry();

    private WallLanternTexturesRegistry() {
        super(GSON, "textures/blocks/wall_lanterns");
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager manager, ProfilerFiller pProfiler) {
        WallLanternTexturesRegistry.reloadTextures(manager);
    }

    public static void reloadTextures(ResourceManager manager) {
        if (POSSIBLE_LANTERNS == null) {
            WallLanternTexturesRegistry.initialize();
        }
        SPECIAL_TEXTURES.clear();
        for (Block i : POSSIBLE_LANTERNS) {
            ResourceLocation reg = Utils.getID((Block)i);
            Object namespace = reg.m_135827_().equals("minecraft") || reg.m_135827_().equals("supplementaries") ? "" : reg.m_135827_() + "/";
            String s = "textures/blocks/wall_lanterns/" + (String)namespace + reg.m_135815_() + ".json";
            ResourceLocation fullPath = Supplementaries.res(s);
            Optional resource = manager.m_213713_(fullPath);
            if (!resource.isPresent()) continue;
            try {
                InputStream stream = ((Resource)resource.get()).m_215507_();
                try {
                    JsonObject bsElement = RPUtils.deserializeJson((InputStream)stream);
                    String texture = RPUtils.findFirstResourceInJsonRecursive((JsonElement)bsElement);
                    if (texture.isEmpty()) continue;
                    SPECIAL_TEXTURES.put(i, new ResourceLocation(texture));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
        ResourceLocation fullPath = Supplementaries.res("textures/blocks/jar_fluid.json");
        Optional resource = manager.m_213713_(fullPath);
        if (resource.isPresent()) {
            try (InputStream stream = ((Resource)resource.get()).m_215507_();){
                JsonObject bsElement = RPUtils.deserializeJson((InputStream)stream);
                float width = GsonHelper.m_13915_((JsonObject)bsElement, (String)"width") / 16.0f;
                float height = GsonHelper.m_13915_((JsonObject)bsElement, (String)"height") / 16.0f;
                float y0 = GsonHelper.m_13915_((JsonObject)bsElement, (String)"y") / 16.0f;
                JarBlockTileRenderer.liquidParams.m_122245_(width, height, y0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void initialize() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Block i : Registry.f_122824_) {
            if (!CommonUtil.isLanternBlock(i)) continue;
            builder.add((Object)i);
        }
        POSSIBLE_LANTERNS = builder.build();
    }

    @Nullable
    public static TextureAtlasSprite getTextureForLantern(Block block) {
        ResourceLocation res = SPECIAL_TEXTURES.get(block);
        if (res == null) {
            return null;
        }
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(res);
    }
}

