/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.core.ModBlockEntities;
import com.mrcrayfish.furniture.core.ModRecipeTypes;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.item.crafting.GrillCookingRecipe;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.network.message.MessageFlipGrill;
import com.mrcrayfish.furniture.util.BlockEntityUtil;
import com.mrcrayfish.furniture.util.ItemStackHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.PacketDistributor;

public class GrillBlockEntity
extends BlockEntity
implements WorldlyContainer {
    public static final int MAX_FLIPPING_COUNTER = 15;
    public static final int[] ALL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final int[] GRILL_SLOTS = new int[]{9, 10, 11, 12};
    private final NonNullList<ItemStack> fuel = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> grill = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final int[] cookingTimes = new int[4];
    private final int[] cookingTotalTimes = new int[4];
    private final boolean[] flipped = new boolean[4];
    private final float[] experience = new float[4];
    private final byte[] rotations = new byte[4];
    private int remainingFuel = 0;
    private final boolean[] flipping = new boolean[4];
    private final int[] flippingCounter = new int[4];

    protected GrillBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public GrillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.GRILL.get(), pos, state);
    }

    public void setFlipping(int position) {
        this.flipping[position] = true;
        this.flippingCounter[position] = 0;
    }

    public boolean isFlipping(int position) {
        return this.flipping[position];
    }

    public int getFlippingCount(int position) {
        return this.flippingCounter[position];
    }

    public NonNullList<ItemStack> getGrill() {
        return this.grill;
    }

    public NonNullList<ItemStack> getFuel() {
        return this.fuel;
    }

    public byte[] getRotations() {
        return this.rotations;
    }

    public boolean isFlipped(int position) {
        return this.flipped[position];
    }

    public boolean addItem(ItemStack stack, int position, int cookTime, float experience, byte rotation) {
        if (((ItemStack)this.grill.get(position)).m_41619_()) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            this.grill.set(position, (Object)copy);
            this.resetPosition(position, cookTime, experience, rotation);
            Level level = this.m_58904_();
            if (level != null) {
                level.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, (SoundEvent)ModSounds.BLOCK_GRILL_PLACE.get(), SoundSource.BLOCKS, 0.75f, level.f_46441_.m_188501_() * 0.2f + 0.9f);
            }
            return true;
        }
        return false;
    }

    private void resetPosition(int position, int cookTime, float experience, byte rotation) {
        this.cookingTimes[position] = 0;
        this.cookingTotalTimes[position] = cookTime / 2;
        this.flipped[position] = false;
        this.experience[position] = experience;
        this.rotations[position] = rotation;
        CompoundTag compound = new CompoundTag();
        this.writeItems(compound);
        this.writeCookingTimes(compound);
        this.writeCookingTotalTimes(compound);
        this.writeFlipped(compound);
        this.writeRotations(compound);
        BlockEntityUtil.sendUpdatePacket(this, compound);
    }

    public boolean addFuel(ItemStack stack) {
        for (int i = 0; i < this.fuel.size(); ++i) {
            if (!((ItemStack)this.fuel.get(i)).m_41619_()) continue;
            ItemStack fuel = stack.m_41777_();
            fuel.m_41764_(1);
            this.fuel.set(i, (Object)fuel);
            CompoundTag compound = new CompoundTag();
            this.writeFuel(compound);
            BlockEntityUtil.sendUpdatePacket(this, compound);
            return true;
        }
        return false;
    }

    public void flipItem(int position) {
        if (!((ItemStack)this.grill.get(position)).m_41619_()) {
            if (!this.flipped[position] && this.cookingTimes[position] == this.cookingTotalTimes[position]) {
                this.flipped[position] = true;
                this.cookingTimes[position] = 0;
                PacketHandler.getPlayChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new MessageFlipGrill(this.f_58858_, position));
                CompoundTag compound = new CompoundTag();
                this.writeCookingTimes(compound);
                this.writeFlipped(compound);
                BlockEntityUtil.sendUpdatePacket(this, compound);
                Level level = this.m_58904_();
                if (level != null) {
                    level.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, (SoundEvent)ModSounds.BLOCK_GRILL_FLIP.get(), SoundSource.BLOCKS, 0.75f, 1.0f);
                }
            } else if (this.flipped[position] && this.cookingTimes[position] == this.cookingTotalTimes[position]) {
                this.removeItem(position);
            }
        }
    }

    public void flipItems() {
        for (int i = 0; i < 4; ++i) {
            if (((ItemStack)this.grill.get(i)).m_41619_() || this.flipped[i] || this.cookingTimes[i] != this.cookingTotalTimes[i]) continue;
            this.flipItem(i);
            return;
        }
    }

    public void removeItem(int position) {
        if (!((ItemStack)this.grill.get(position)).m_41619_()) {
            double posX = (double)this.f_58858_.m_123341_() + 0.3 + 0.4 * (double)(position % 2);
            double posY = (double)this.f_58858_.m_123342_() + 1.0;
            double posZ = (double)this.f_58858_.m_123343_() + 0.3 + 0.4 * (double)(position / 2);
            ItemEntity entity = new ItemEntity(this.f_58857_, posX, posY + 0.1, posZ, ((ItemStack)this.grill.get(position)).m_41777_());
            this.f_58857_.m_7967_((Entity)entity);
            this.grill.set(position, (Object)ItemStack.f_41583_);
            if (this.flipped[position] && this.cookingTimes[position] == this.cookingTotalTimes[position]) {
                int splitAmount;
                for (int amount = (int)this.experience[position]; amount > 0; amount -= splitAmount) {
                    splitAmount = ExperienceOrb.m_20782_((int)amount);
                    this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, posX, posY, posZ, splitAmount));
                }
            }
            CompoundTag compound = new CompoundTag();
            this.writeItems(compound);
            BlockEntityUtil.sendUpdatePacket(this, compound);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GrillBlockEntity blockEntity) {
        boolean canCook = blockEntity.canCook();
        if (blockEntity.remainingFuel == 0 && canCook) {
            for (int i = blockEntity.fuel.size() - 1; i >= 0; --i) {
                if (((ItemStack)blockEntity.fuel.get(i)).m_41619_()) continue;
                blockEntity.remainingFuel = ForgeHooks.getBurnTime((ItemStack)((ItemStack)blockEntity.fuel.get(i)), (RecipeType)RecipeType.f_44108_);
                blockEntity.fuel.set(i, (Object)ItemStack.f_41583_);
                CompoundTag compound = new CompoundTag();
                blockEntity.writeFuel(compound);
                blockEntity.writeRemainingFuel(compound);
                BlockEntityUtil.sendUpdatePacketSimple(blockEntity, compound);
                break;
            }
        }
        if (canCook && blockEntity.remainingFuel > 0) {
            blockEntity.cookItems();
            --blockEntity.remainingFuel;
            if (blockEntity.remainingFuel == 0) {
                CompoundTag compound = new CompoundTag();
                blockEntity.writeRemainingFuel(compound);
                BlockEntityUtil.sendUpdatePacketSimple(blockEntity, compound);
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, GrillBlockEntity blockEntity) {
        blockEntity.spawnParticles();
        for (int i = 0; i < blockEntity.flipping.length; ++i) {
            if (!blockEntity.flipping[i] || blockEntity.flippingCounter[i] >= 15) continue;
            int n = i;
            blockEntity.flippingCounter[n] = blockEntity.flippingCounter[n] + 1;
            if (blockEntity.flippingCounter[i] != 15) continue;
            blockEntity.flipping[i] = false;
        }
    }

    private boolean canCook() {
        for (int i = 0; i < this.grill.size(); ++i) {
            if (((ItemStack)this.grill.get(i)).m_41619_() || this.cookingTimes[i] == this.cookingTotalTimes[i]) continue;
            return true;
        }
        return false;
    }

    private void cookItems() {
        boolean itemsChanged = false;
        for (int i = 0; i < this.grill.size(); ++i) {
            Optional optional;
            if (((ItemStack)this.grill.get(i)).m_41619_() || this.cookingTimes[i] >= this.cookingTotalTimes[i]) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] != this.cookingTotalTimes[i]) continue;
            if (this.flipped[i] && (optional = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.GRILL_COOKING.get(), (Container)new SimpleContainer(new ItemStack[]{(ItemStack)this.grill.get(i)}), this.f_58857_)).isPresent()) {
                this.grill.set(i, (Object)((GrillCookingRecipe)((Object)optional.get())).m_8043_().m_41777_());
            }
            itemsChanged = true;
        }
        if (itemsChanged) {
            CompoundTag compound = new CompoundTag();
            this.writeItems(compound);
            this.writeCookingTimes(compound);
            BlockEntityUtil.sendUpdatePacket(this, compound);
        }
    }

    private void spawnParticles() {
        Level level = this.m_58904_();
        if (level != null) {
            if (this.isCooking() && this.remainingFuel > 0) {
                double posX = (double)this.f_58858_.m_123341_() + 0.2 + 0.6 * level.f_46441_.m_188500_();
                double posY = (double)this.f_58858_.m_123342_() + 0.85;
                double posZ = (double)this.f_58858_.m_123343_() + 0.2 + 0.6 * level.f_46441_.m_188500_();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
            BlockPos pos = this.m_58899_();
            for (int i = 0; i < this.grill.size(); ++i) {
                if (((ItemStack)this.grill.get(i)).m_41619_() || !(level.f_46441_.m_188501_() < 0.1f)) continue;
                double posX = (double)pos.m_123341_() + 0.3 + 0.4 * (double)(i % 2);
                double posY = (double)pos.m_123342_() + 1.0;
                double posZ = (double)pos.m_123343_() + 0.3 + 0.4 * (double)(i / 2);
                if (this.flipped[i] || this.cookingTimes[i] != this.cookingTotalTimes[i]) continue;
                for (int j = 0; j < 4; ++j) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, posX, posY, posZ, 0.0, 5.0E-4, 0.0);
                }
            }
        }
    }

    private boolean isCooking() {
        for (int i = 0; i < this.grill.size(); ++i) {
            if (((ItemStack)this.grill.get(i)).m_41619_() || this.cookingTimes[i] == this.cookingTotalTimes[i] && this.flipped[i]) continue;
            return true;
        }
        return false;
    }

    public Optional<GrillCookingRecipe> findMatchingRecipe(ItemStack input) {
        return this.grill.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.GRILL_COOKING.get(), (Container)new SimpleContainer(new ItemStack[]{input}), this.f_58857_);
    }

    public int m_6643_() {
        return this.fuel.size() + this.grill.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.fuel) {
            if (stack.m_41619_()) continue;
            return false;
        }
        for (ItemStack stack : this.grill) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        if (index - this.fuel.size() >= 0) {
            return (ItemStack)this.grill.get(index - this.fuel.size());
        }
        return (ItemStack)this.fuel.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (index - this.fuel.size() >= 0) {
            ItemStack result = ContainerHelper.m_18969_(this.grill, (int)(index -= this.fuel.size()), (int)count);
            if (((ItemStack)this.grill.get(index)).m_41619_() && this.flipped[index] && this.cookingTimes[index] == this.cookingTotalTimes[index]) {
                int splitAmount;
                double posX = (double)this.f_58858_.m_123341_() + 0.3 + 0.4 * (double)(index % 2);
                double posY = (double)this.f_58858_.m_123342_() + 1.0;
                double posZ = (double)this.f_58858_.m_123343_() + 0.3 + 0.4 * (double)(index / 2);
                for (int amount = (int)this.experience[index]; amount > 0; amount -= splitAmount) {
                    splitAmount = ExperienceOrb.m_20782_((int)amount);
                    this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, posX, posY, posZ, splitAmount));
                }
            }
            CompoundTag compound = new CompoundTag();
            this.writeItems(compound);
            BlockEntityUtil.sendUpdatePacket(this, compound);
            return result;
        }
        ItemStack result = ContainerHelper.m_18969_(this.fuel, (int)index, (int)count);
        CompoundTag compound = new CompoundTag();
        this.writeFuel(compound);
        BlockEntityUtil.sendUpdatePacket(this, compound);
        return result;
    }

    public ItemStack m_8016_(int index) {
        if (index - this.fuel.size() >= 0) {
            return ContainerHelper.m_18966_(this.grill, (int)(index - this.fuel.size()));
        }
        return ContainerHelper.m_18966_(this.fuel, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        NonNullList<ItemStack> inventory = this.fuel;
        if (index - this.fuel.size() >= 0) {
            inventory = this.grill;
            int finalIndex = index -= this.fuel.size();
            Optional optional = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.GRILL_COOKING.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_);
            if (optional.isPresent()) {
                GrillCookingRecipe recipe = (GrillCookingRecipe)((Object)optional.get());
                this.resetPosition(finalIndex, recipe.m_43753_(), recipe.m_43750_(), (byte)0);
            }
        }
        inventory.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        CompoundTag compound = new CompoundTag();
        this.writeItems(compound);
        this.writeFuel(compound);
        BlockEntityUtil.sendUpdatePacket(this, compound);
    }

    public int m_6893_() {
        return 1;
    }

    public void m_6211_() {
        this.fuel.clear();
        this.grill.clear();
    }

    public void m_142466_(CompoundTag compound) {
        int i;
        int[] cookingTimes;
        super.m_142466_(compound);
        if (compound.m_128425_("Grill", 9)) {
            this.grill.clear();
            ItemStackHelper.loadAllItems("Grill", compound, this.grill);
        }
        if (compound.m_128425_("Fuel", 9)) {
            this.fuel.clear();
            ItemStackHelper.loadAllItems("Fuel", compound, this.fuel);
        }
        if (compound.m_128425_("RemainingFuel", 3)) {
            this.remainingFuel = compound.m_128451_("RemainingFuel");
        }
        if (compound.m_128425_("CookingTimes", 11)) {
            cookingTimes = compound.m_128465_("CookingTimes");
            System.arraycopy(cookingTimes, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, cookingTimes.length));
        }
        if (compound.m_128425_("CookingTotalTimes", 11)) {
            cookingTimes = compound.m_128465_("CookingTotalTimes");
            System.arraycopy(cookingTimes, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, cookingTimes.length));
        }
        if (compound.m_128425_("Flipped", 7)) {
            byte[] flipped = compound.m_128463_("Flipped");
            for (i = 0; i < Math.min(this.flipped.length, flipped.length); ++i) {
                this.flipped[i] = flipped[i] == 1;
            }
        }
        if (compound.m_128425_("Experience", 11)) {
            int[] experience = compound.m_128465_("Experience");
            for (i = 0; i < Math.min(this.experience.length, experience.length); ++i) {
                this.experience[i] = Float.intBitsToFloat(experience[i]);
            }
        }
        if (compound.m_128425_("Rotations", 7)) {
            byte[] rotations = compound.m_128463_("Rotations");
            System.arraycopy(rotations, 0, this.rotations, 0, Math.min(this.rotations.length, rotations.length));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeItems(tag);
        this.writeFuel(tag);
        this.writeCookingTimes(tag);
        this.writeCookingTotalTimes(tag);
        this.writeFlipped(tag);
        this.writeExperience(tag);
        this.writeRemainingFuel(tag);
        this.writeRotations(tag);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        ItemStackHelper.saveAllItems("Grill", compound, this.grill, true);
        return compound;
    }

    private CompoundTag writeFuel(CompoundTag compound) {
        ItemStackHelper.saveAllItems("Fuel", compound, this.fuel, true);
        return compound;
    }

    private CompoundTag writeRemainingFuel(CompoundTag compound) {
        compound.m_128405_("RemainingFuel", this.remainingFuel);
        return compound;
    }

    private CompoundTag writeCookingTimes(CompoundTag compound) {
        compound.m_128385_("CookingTimes", this.cookingTimes);
        return compound;
    }

    private CompoundTag writeCookingTotalTimes(CompoundTag compound) {
        compound.m_128385_("CookingTotalTimes", this.cookingTotalTimes);
        return compound;
    }

    private CompoundTag writeFlipped(CompoundTag compound) {
        byte[] flipped = new byte[this.flipped.length];
        for (int i = 0; i < this.flipped.length; ++i) {
            flipped[i] = (byte)(this.flipped[i] ? 1 : 0);
        }
        compound.m_128382_("Flipped", flipped);
        return compound;
    }

    private CompoundTag writeExperience(CompoundTag compound) {
        int[] experience = new int[this.experience.length];
        for (int i = 0; i < this.experience.length; ++i) {
            experience[i] = Float.floatToIntBits(experience[i]);
        }
        compound.m_128385_("Experience", experience);
        return compound;
    }

    private CompoundTag writeRotations(CompoundTag compound) {
        compound.m_128382_("Rotations", this.rotations);
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compound = pkt.m_131708_();
        this.m_142466_(compound);
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public int[] m_7071_(Direction side) {
        return side == Direction.DOWN ? GRILL_SLOTS : ALL_SLOTS;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        if (!this.m_8020_(index).m_41619_()) {
            return false;
        }
        if (index - this.fuel.size() >= 0) {
            return this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.GRILL_COOKING.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_).isPresent();
        }
        return stack.m_41720_() == Items.f_42413_ || stack.m_41720_() == Items.f_42414_;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index - this.fuel.size() >= 0 && this.flipped[index -= this.fuel.size()] && this.cookingTimes[index] == this.cookingTotalTimes[index]) {
            Optional optional = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.GRILL_COOKING.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_);
            return !optional.isPresent();
        }
        return false;
    }
}

