/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.common.mail;

import com.mrcrayfish.furniture.FurnitureConfig;
import com.mrcrayfish.furniture.common.mail.Mail;
import com.mrcrayfish.furniture.common.mail.MailBox;
import com.mrcrayfish.furniture.tileentity.MailBoxBlockEntity;
import com.mrcrayfish.furniture.util.BlockEntityUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="cfm")
public class PostOffice
extends SavedData {
    private static final String ID = "cfm_post_office";
    private final Map<UUID, Map<UUID, MailBox>> playerMailboxMap = new HashMap<UUID, Map<UUID, MailBox>>();

    public static PostOffice load(CompoundTag tag) {
        PostOffice postOffice = new PostOffice();
        postOffice.read(tag);
        return postOffice;
    }

    public void read(CompoundTag compound) {
        this.playerMailboxMap.clear();
        if (compound.m_128425_("PlayerMailBoxes", 9)) {
            ListTag playerMailBoxesList = compound.m_128437_("PlayerMailBoxes", 10);
            playerMailBoxesList.forEach(nbt -> {
                CompoundTag playerMailBoxesCompound = (CompoundTag)nbt;
                UUID playerId = playerMailBoxesCompound.m_128342_("PlayerUUID");
                if (playerMailBoxesCompound.m_128425_("MailBoxes", 9)) {
                    HashMap mailBoxMap = new HashMap();
                    ListTag mailBoxList = playerMailBoxesCompound.m_128437_("MailBoxes", 10);
                    mailBoxList.forEach(nbt2 -> {
                        CompoundTag mailBoxCompound = (CompoundTag)nbt2;
                        UUID mailBoxId = mailBoxCompound.m_128342_("MailBoxUUID");
                        MailBox mailBox = new MailBox(mailBoxCompound.m_128469_("MailBox"));
                        mailBoxMap.put(mailBoxId, mailBox);
                    });
                    this.playerMailboxMap.put(playerId, mailBoxMap);
                }
            });
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag playerMailBoxesList = new ListTag();
        this.playerMailboxMap.forEach((playerId, mailStorage) -> {
            if (!mailStorage.isEmpty()) {
                CompoundTag playerMailBoxesCompound = new CompoundTag();
                playerMailBoxesCompound.m_128362_("PlayerUUID", playerId);
                ListTag mailBoxList = new ListTag();
                mailStorage.forEach((mailBoxId, mailBox) -> {
                    CompoundTag mailBoxCompound = new CompoundTag();
                    mailBoxCompound.m_128362_("MailBoxUUID", mailBoxId);
                    mailBoxCompound.m_128365_("MailBox", (Tag)mailBox.serializeNBT());
                    mailBoxList.add((Object)mailBoxCompound);
                });
                playerMailBoxesCompound.m_128365_("MailBoxes", (Tag)mailBoxList);
                playerMailBoxesList.add((Object)playerMailBoxesCompound);
            }
        });
        compound.m_128365_("PlayerMailBoxes", (Tag)playerMailBoxesList);
        return compound;
    }

    public static void registerMailBox(ServerPlayer player, UUID mailBoxId, String name, BlockPos pos) {
        PostOffice office = PostOffice.get(player.f_8924_);
        Map mailBoxMap = office.playerMailboxMap.computeIfAbsent(player.m_20148_(), uuid -> new HashMap());
        mailBoxMap.put(mailBoxId, new MailBox(mailBoxId, name, player.m_20148_(), player.m_7755_().getString(), pos, (ResourceKey<Level>)player.f_19853_.m_46472_()));
        office.m_77762_();
    }

    public static void unregisterMailBox(UUID playerId, UUID mailBoxId) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            PostOffice office = PostOffice.get(server);
            Map mailBoxMap = office.playerMailboxMap.computeIfAbsent(playerId, uuid -> new HashMap());
            mailBoxMap.remove(mailBoxId);
            office.m_77762_();
        }
    }

    public static List<MailBox> getMailBoxes(ServerPlayer playerEntity) {
        PostOffice office = PostOffice.get(playerEntity.f_8924_);
        return office.playerMailboxMap.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
    }

    public static boolean sendMailToPlayer(UUID playerId, UUID mailBoxId, Mail mail) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            PostOffice office = PostOffice.get(server);
            Map mailBoxMap = office.playerMailboxMap.computeIfAbsent(playerId, uuid -> new HashMap());
            if (mailBoxMap.containsKey(mailBoxId) && ((MailBox)mailBoxMap.get(mailBoxId)).getMailCount() < (Integer)FurnitureConfig.COMMON.maxMailQueue.get()) {
                ((MailBox)mailBoxMap.get(mailBoxId)).addMail(mail);
                office.m_77762_();
                return true;
            }
        }
        return false;
    }

    public static Supplier<Mail> getMailForPlayerMailBox(UUID playerId, UUID mailBoxId) {
        return () -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                MailBox mailBox;
                List<Mail> mailStorage;
                Map<UUID, MailBox> mailBoxMap;
                PostOffice office = PostOffice.get(server);
                if (office.playerMailboxMap.containsKey(playerId) && (mailBoxMap = office.playerMailboxMap.get(playerId)).containsKey(mailBoxId) && !(mailStorage = (mailBox = mailBoxMap.get(mailBoxId)).getMailStorage()).isEmpty()) {
                    office.m_77762_();
                    return mailStorage.remove(0);
                }
            }
            return null;
        };
    }

    public static boolean setMailBoxName(UUID playerId, UUID mailBoxId, String name) {
        if ((name = name.trim()).trim().isEmpty()) {
            return false;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            PostOffice office = PostOffice.get(server);
            if (!office.playerMailboxMap.containsKey(playerId)) {
                return false;
            }
            Map<UUID, MailBox> mailBoxMap = office.playerMailboxMap.get(playerId);
            if (!mailBoxMap.containsKey(mailBoxId)) {
                return false;
            }
            MailBox mailBox = mailBoxMap.get(mailBoxId);
            mailBox.setName(name);
            ServerLevel level = server.m_129880_(mailBox.getLevelResourceKey());
            if (level == null || !level.isAreaLoaded(mailBox.getPos(), 0)) {
                return false;
            }
            BlockEntity blockEntity = level.m_7702_(mailBox.getPos());
            if (!(blockEntity instanceof MailBoxBlockEntity)) {
                return false;
            }
            MailBoxBlockEntity mailBoxBlockEntity = (MailBoxBlockEntity)blockEntity;
            mailBoxBlockEntity.setMailBoxName(name);
            BlockEntityUtil.sendUpdatePacket((BlockEntity)mailBoxBlockEntity);
            return true;
        }
        return false;
    }

    public static boolean isRegistered(UUID playerId, UUID mailBoxId) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            PostOffice office = PostOffice.get(server);
            if (office.playerMailboxMap.containsKey(playerId)) {
                return office.playerMailboxMap.get(playerId).containsKey(mailBoxId);
            }
        }
        return false;
    }

    private static PostOffice get(MinecraftServer server) {
        ServerLevel level = server.m_129880_(Level.f_46428_);
        return (PostOffice)Objects.requireNonNull(level).m_8895_().m_164861_(PostOffice::load, PostOffice::new, ID);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        MinecraftServer server = event.level.m_7654_();
        if (server != null && server.m_129921_() % 1200 == 0) {
            PostOffice office = PostOffice.get(server);
            office.playerMailboxMap.values().forEach(map -> {
                Predicate<MailBox> removePredicate = mailBox -> {
                    BlockPos pos = mailBox.getPos();
                    ServerLevel level = server.m_129880_(mailBox.getLevelResourceKey());
                    if (level != null) {
                        if (level.isAreaLoaded(pos, 0)) {
                            BlockEntity patt10355$temp = level.m_7702_(pos);
                            if (patt10355$temp instanceof MailBoxBlockEntity) {
                                MailBoxBlockEntity mailBoxBlockEntity = (MailBoxBlockEntity)patt10355$temp;
                                return mailBoxBlockEntity.getId() == null || !Objects.equals(mailBoxBlockEntity.getId(), mailBox.getId());
                            }
                            return true;
                        }
                        return false;
                    }
                    return true;
                };
                if (map.values().removeIf(removePredicate)) {
                    office.m_77762_();
                }
            });
        }
    }
}

