/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client;

import com.mrcrayfish.furniture.client.event.CreativeScreenEvents;
import com.mrcrayfish.furniture.client.gui.screen.DoorMatScreen;
import com.mrcrayfish.furniture.client.gui.screen.inventory.CrateScreen;
import com.mrcrayfish.furniture.client.gui.screen.inventory.FreezerScreen;
import com.mrcrayfish.furniture.client.gui.screen.inventory.MailBoxScreen;
import com.mrcrayfish.furniture.client.gui.screen.inventory.PostBoxScreen;
import com.mrcrayfish.furniture.client.renderer.SeatRenderer;
import com.mrcrayfish.furniture.client.renderer.tileentity.DoorMatBlockEntityRenderer;
import com.mrcrayfish.furniture.client.renderer.tileentity.GrillBlockEntityRenderer;
import com.mrcrayfish.furniture.client.renderer.tileentity.KitchenSinkBlockEntityRenderer;
import com.mrcrayfish.furniture.core.ModBlockEntities;
import com.mrcrayfish.furniture.core.ModBlocks;
import com.mrcrayfish.furniture.core.ModContainers;
import com.mrcrayfish.furniture.core.ModEntities;
import com.mrcrayfish.furniture.tileentity.DoorMatBlockEntity;
import com.mrcrayfish.furniture.tileentity.TrampolineBlockEntity;
import java.util.function.Predicate;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;

public class ClientHandler {
    public static void setup() {
        ClientHandler.registerBlockEntityRenderers();
        ClientHandler.registerEntityRenderers();
        ClientHandler.registerScreenFactories();
        ClientHandler.registerLayers();
        ClientHandler.registerColors();
        MinecraftForge.EVENT_BUS.register((Object)new CreativeScreenEvents());
    }

    private static void registerBlockEntityRenderers() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.GRILL.get()), GrillBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.DOOR_MAT.get()), DoorMatBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.KITCHEN_SINK.get()), KitchenSinkBlockEntityRenderer::new);
    }

    private static void registerEntityRenderers() {
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SEAT.get()), SeatRenderer::new);
    }

    private static void registerScreenFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.CRATE.get()), CrateScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.POST_BOX.get()), PostBoxScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.MAIL_BOX.get()), MailBoxScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.FREEZER.get()), FreezerScreen::new);
    }

    private static void registerLayers() {
        Predicate<RenderType> leavesPredicate = renderType -> ClientHandler.useFancyGraphics() ? renderType == RenderType.m_110457_() : renderType == RenderType.m_110451_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HEDGE_OAK.get()), leavesPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HEDGE_SPRUCE.get()), leavesPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HEDGE_BIRCH.get()), leavesPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HEDGE_JUNGLE.get()), leavesPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HEDGE_ACACIA.get()), leavesPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HEDGE_DARK_OAK.get()), leavesPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HEDGE_MANGROVE.get()), leavesPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HEDGE_AZALEA.get()), leavesPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HEDGE_FLOWERING_AZALEA.get()), leavesPredicate);
        Predicate<RenderType> cutoutPredicate = renderType -> renderType == RenderType.m_110463_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.TRAMPOLINE.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_WHITE.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_ORANGE.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_MAGENTA.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_LIGHT_BLUE.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_YELLOW.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_LIME.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_PINK.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_GRAY.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_LIGHT_GRAY.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_CYAN.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_PURPLE.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_BLUE.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_BROWN.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_GREEN.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_RED.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GRILL_BLACK.get()), cutoutPredicate);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.POST_BOX.get()), cutoutPredicate);
    }

    private static void registerColors() {
        Minecraft.m_91087_().m_91298_().m_92589_((state, reader, pos, i) -> i == 1 ? -3355444 : -1, new Block[]{(Block)ModBlocks.PICKET_FENCE_WHITE.get(), (Block)ModBlocks.PICKET_FENCE_ORANGE.get(), (Block)ModBlocks.PICKET_FENCE_MAGENTA.get(), (Block)ModBlocks.PICKET_FENCE_LIGHT_BLUE.get(), (Block)ModBlocks.PICKET_FENCE_YELLOW.get(), (Block)ModBlocks.PICKET_FENCE_LIME.get(), (Block)ModBlocks.PICKET_FENCE_PINK.get(), (Block)ModBlocks.PICKET_FENCE_GRAY.get(), (Block)ModBlocks.PICKET_FENCE_LIGHT_GRAY.get(), (Block)ModBlocks.PICKET_FENCE_CYAN.get(), (Block)ModBlocks.PICKET_FENCE_PURPLE.get(), (Block)ModBlocks.PICKET_FENCE_BLUE.get(), (Block)ModBlocks.PICKET_FENCE_BROWN.get(), (Block)ModBlocks.PICKET_FENCE_GREEN.get(), (Block)ModBlocks.PICKET_FENCE_RED.get(), (Block)ModBlocks.PICKET_FENCE_BLACK.get(), (Block)ModBlocks.PICKET_GATE_WHITE.get(), (Block)ModBlocks.PICKET_GATE_ORANGE.get(), (Block)ModBlocks.PICKET_GATE_MAGENTA.get(), (Block)ModBlocks.PICKET_GATE_LIGHT_BLUE.get(), (Block)ModBlocks.PICKET_GATE_YELLOW.get(), (Block)ModBlocks.PICKET_GATE_LIME.get(), (Block)ModBlocks.PICKET_GATE_PINK.get(), (Block)ModBlocks.PICKET_GATE_GRAY.get(), (Block)ModBlocks.PICKET_GATE_LIGHT_GRAY.get(), (Block)ModBlocks.PICKET_GATE_CYAN.get(), (Block)ModBlocks.PICKET_GATE_PURPLE.get(), (Block)ModBlocks.PICKET_GATE_BLUE.get(), (Block)ModBlocks.PICKET_GATE_BROWN.get(), (Block)ModBlocks.PICKET_GATE_GREEN.get(), (Block)ModBlocks.PICKET_GATE_RED.get(), (Block)ModBlocks.PICKET_GATE_BLACK.get(), (Block)ModBlocks.POST_BOX.get()});
        Minecraft.m_91087_().getItemColors().m_92689_((stack, i) -> i == 1 ? 0xCCCCCC : -1, new ItemLike[]{(ItemLike)ModBlocks.PICKET_FENCE_WHITE.get(), (ItemLike)ModBlocks.PICKET_FENCE_ORANGE.get(), (ItemLike)ModBlocks.PICKET_FENCE_MAGENTA.get(), (ItemLike)ModBlocks.PICKET_FENCE_LIGHT_BLUE.get(), (ItemLike)ModBlocks.PICKET_FENCE_YELLOW.get(), (ItemLike)ModBlocks.PICKET_FENCE_LIME.get(), (ItemLike)ModBlocks.PICKET_FENCE_PINK.get(), (ItemLike)ModBlocks.PICKET_FENCE_GRAY.get(), (ItemLike)ModBlocks.PICKET_FENCE_LIGHT_GRAY.get(), (ItemLike)ModBlocks.PICKET_FENCE_CYAN.get(), (ItemLike)ModBlocks.PICKET_FENCE_PURPLE.get(), (ItemLike)ModBlocks.PICKET_FENCE_BLUE.get(), (ItemLike)ModBlocks.PICKET_FENCE_BROWN.get(), (ItemLike)ModBlocks.PICKET_FENCE_GREEN.get(), (ItemLike)ModBlocks.PICKET_FENCE_RED.get(), (ItemLike)ModBlocks.PICKET_FENCE_BLACK.get(), (ItemLike)ModBlocks.PICKET_GATE_WHITE.get(), (ItemLike)ModBlocks.PICKET_GATE_ORANGE.get(), (ItemLike)ModBlocks.PICKET_GATE_MAGENTA.get(), (ItemLike)ModBlocks.PICKET_GATE_LIGHT_BLUE.get(), (ItemLike)ModBlocks.PICKET_GATE_YELLOW.get(), (ItemLike)ModBlocks.PICKET_GATE_LIME.get(), (ItemLike)ModBlocks.PICKET_GATE_PINK.get(), (ItemLike)ModBlocks.PICKET_GATE_GRAY.get(), (ItemLike)ModBlocks.PICKET_GATE_LIGHT_GRAY.get(), (ItemLike)ModBlocks.PICKET_GATE_CYAN.get(), (ItemLike)ModBlocks.PICKET_GATE_PURPLE.get(), (ItemLike)ModBlocks.PICKET_GATE_BLUE.get(), (ItemLike)ModBlocks.PICKET_GATE_BROWN.get(), (ItemLike)ModBlocks.PICKET_GATE_GREEN.get(), (ItemLike)ModBlocks.PICKET_GATE_RED.get(), (ItemLike)ModBlocks.PICKET_GATE_BLACK.get(), (ItemLike)ModBlocks.POST_BOX.get()});
        Minecraft.m_91087_().m_91298_().m_92589_((state, reader, pos, i) -> i == 1 ? 0xBBBBBB : -1, new Block[]{(Block)ModBlocks.CRATE_STRIPPED_OAK.get(), (Block)ModBlocks.CRATE_STRIPPED_SPRUCE.get(), (Block)ModBlocks.CRATE_STRIPPED_BIRCH.get(), (Block)ModBlocks.CRATE_STRIPPED_JUNGLE.get(), (Block)ModBlocks.CRATE_STRIPPED_ACACIA.get(), (Block)ModBlocks.CRATE_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.CRATE_STRIPPED_CRIMSON.get(), (Block)ModBlocks.CRATE_STRIPPED_WARPED.get(), (Block)ModBlocks.CRATE_STRIPPED_MANGROVE.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_OAK.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_SPRUCE.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_BIRCH.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_JUNGLE.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_ACACIA.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_CRIMSON.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_WARPED.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_MANGROVE.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_OAK.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_SPRUCE.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_BIRCH.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_JUNGLE.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_ACACIA.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_CRIMSON.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_WARPED.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_MANGROVE.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_OAK.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_SPRUCE.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_BIRCH.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_JUNGLE.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_ACACIA.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_CRIMSON.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_WARPED.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_MANGROVE.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_OAK.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_SPRUCE.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_BIRCH.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_JUNGLE.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_ACACIA.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_CRIMSON.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_WARPED.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_MANGROVE.get()});
        Minecraft.m_91087_().getItemColors().m_92689_((stack, i) -> i == 1 ? 0xBBBBBB : -1, new ItemLike[]{(ItemLike)ModBlocks.CRATE_STRIPPED_OAK.get(), (ItemLike)ModBlocks.CRATE_STRIPPED_SPRUCE.get(), (ItemLike)ModBlocks.CRATE_STRIPPED_BIRCH.get(), (ItemLike)ModBlocks.CRATE_STRIPPED_JUNGLE.get(), (ItemLike)ModBlocks.CRATE_STRIPPED_ACACIA.get(), (ItemLike)ModBlocks.CRATE_STRIPPED_DARK_OAK.get(), (ItemLike)ModBlocks.CRATE_STRIPPED_CRIMSON.get(), (ItemLike)ModBlocks.CRATE_STRIPPED_WARPED.get(), (ItemLike)ModBlocks.CRATE_STRIPPED_MANGROVE.get(), (ItemLike)ModBlocks.KITCHEN_COUNTER_STRIPPED_OAK.get(), (ItemLike)ModBlocks.KITCHEN_COUNTER_STRIPPED_SPRUCE.get(), (ItemLike)ModBlocks.KITCHEN_COUNTER_STRIPPED_BIRCH.get(), (ItemLike)ModBlocks.KITCHEN_COUNTER_STRIPPED_JUNGLE.get(), (ItemLike)ModBlocks.KITCHEN_COUNTER_STRIPPED_ACACIA.get(), (ItemLike)ModBlocks.KITCHEN_COUNTER_STRIPPED_DARK_OAK.get(), (ItemLike)ModBlocks.KITCHEN_COUNTER_STRIPPED_CRIMSON.get(), (ItemLike)ModBlocks.KITCHEN_COUNTER_STRIPPED_WARPED.get(), (ItemLike)ModBlocks.KITCHEN_COUNTER_STRIPPED_MANGROVE.get(), (ItemLike)ModBlocks.KITCHEN_DRAWER_STRIPPED_OAK.get(), (ItemLike)ModBlocks.KITCHEN_DRAWER_STRIPPED_SPRUCE.get(), (ItemLike)ModBlocks.KITCHEN_DRAWER_STRIPPED_BIRCH.get(), (ItemLike)ModBlocks.KITCHEN_DRAWER_STRIPPED_JUNGLE.get(), (ItemLike)ModBlocks.KITCHEN_DRAWER_STRIPPED_ACACIA.get(), (ItemLike)ModBlocks.KITCHEN_DRAWER_STRIPPED_DARK_OAK.get(), (ItemLike)ModBlocks.KITCHEN_DRAWER_STRIPPED_CRIMSON.get(), (ItemLike)ModBlocks.KITCHEN_DRAWER_STRIPPED_WARPED.get(), (ItemLike)ModBlocks.KITCHEN_DRAWER_STRIPPED_MANGROVE.get(), (ItemLike)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_OAK.get(), (ItemLike)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_SPRUCE.get(), (ItemLike)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_BIRCH.get(), (ItemLike)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_JUNGLE.get(), (ItemLike)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_ACACIA.get(), (ItemLike)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_DARK_OAK.get(), (ItemLike)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_CRIMSON.get(), (ItemLike)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_WARPED.get(), (ItemLike)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_MANGROVE.get(), (ItemLike)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_OAK.get(), (ItemLike)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_SPRUCE.get(), (ItemLike)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_BIRCH.get(), (ItemLike)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_JUNGLE.get(), (ItemLike)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_ACACIA.get(), (ItemLike)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_DARK_OAK.get(), (ItemLike)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_CRIMSON.get(), (ItemLike)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_WARPED.get(), (ItemLike)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_MANGROVE.get()});
        Minecraft.m_91087_().m_91298_().m_92589_((state, reader, pos, i) -> i == 1 ? 0x999999 : -1, new Block[]{(Block)ModBlocks.PARK_BENCH_STRIPPED_OAK.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_SPRUCE.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_BIRCH.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_JUNGLE.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_ACACIA.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_CRIMSON.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_WARPED.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_MANGROVE.get()});
        Minecraft.m_91087_().getItemColors().m_92689_((stack, i) -> i == 1 ? 0x999999 : -1, new ItemLike[]{(ItemLike)ModBlocks.PARK_BENCH_STRIPPED_OAK.get(), (ItemLike)ModBlocks.PARK_BENCH_STRIPPED_SPRUCE.get(), (ItemLike)ModBlocks.PARK_BENCH_STRIPPED_BIRCH.get(), (ItemLike)ModBlocks.PARK_BENCH_STRIPPED_JUNGLE.get(), (ItemLike)ModBlocks.PARK_BENCH_STRIPPED_ACACIA.get(), (ItemLike)ModBlocks.PARK_BENCH_STRIPPED_DARK_OAK.get(), (ItemLike)ModBlocks.PARK_BENCH_STRIPPED_CRIMSON.get(), (ItemLike)ModBlocks.PARK_BENCH_STRIPPED_WARPED.get(), (ItemLike)ModBlocks.PARK_BENCH_STRIPPED_MANGROVE.get()});
        Minecraft.m_91087_().m_91298_().m_92589_((state, reader, pos, i) -> i == 1 ? 0xCCCCCC : -1, new Block[]{(Block)ModBlocks.FRIDGE_LIGHT.get(), (Block)ModBlocks.FREEZER_LIGHT.get(), (Block)ModBlocks.FRIDGE_DARK.get(), (Block)ModBlocks.FREEZER_DARK.get()});
        Minecraft.m_91087_().getItemColors().m_92689_((stack, i) -> i == 1 ? 0xCCCCCC : -1, new ItemLike[]{(ItemLike)ModBlocks.FRIDGE_LIGHT.get(), (ItemLike)ModBlocks.FREEZER_LIGHT.get(), (ItemLike)ModBlocks.FRIDGE_DARK.get(), (ItemLike)ModBlocks.FREEZER_DARK.get()});
        Minecraft.m_91087_().m_91298_().m_92589_((state, reader, pos, i) -> FoliageColor.m_46106_(), new Block[]{(Block)ModBlocks.HEDGE_SPRUCE.get()});
        Minecraft.m_91087_().m_91298_().m_92589_((state, reader, pos, i) -> FoliageColor.m_46112_(), new Block[]{(Block)ModBlocks.HEDGE_BIRCH.get()});
        Minecraft.m_91087_().m_91298_().m_92589_((state, reader, pos, i) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)ModBlocks.HEDGE_OAK.get(), (Block)ModBlocks.HEDGE_JUNGLE.get(), (Block)ModBlocks.HEDGE_ACACIA.get(), (Block)ModBlocks.HEDGE_DARK_OAK.get()});
        Minecraft.m_91087_().m_91298_().m_92589_((state, reader, pos, i) -> FoliageColor.m_220346_(), new Block[]{(Block)ModBlocks.HEDGE_MANGROVE.get()});
        Minecraft.m_91087_().getItemColors().m_92689_((stack, i) -> {
            BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return Minecraft.m_91087_().m_91298_().m_92577_(state, null, null, i);
        }, new ItemLike[]{(ItemLike)ModBlocks.HEDGE_OAK.get(), (ItemLike)ModBlocks.HEDGE_SPRUCE.get(), (ItemLike)ModBlocks.HEDGE_BIRCH.get(), (ItemLike)ModBlocks.HEDGE_JUNGLE.get(), (ItemLike)ModBlocks.HEDGE_ACACIA.get(), (ItemLike)ModBlocks.HEDGE_DARK_OAK.get(), (ItemLike)ModBlocks.HEDGE_MANGROVE.get()});
        Minecraft.m_91087_().m_91298_().m_92589_((state, reader, pos, i) -> {
            BlockEntity tileEntity;
            if (reader != null && pos != null && (tileEntity = reader.m_7702_(pos)) instanceof TrampolineBlockEntity) {
                return ((TrampolineBlockEntity)tileEntity).getColour().m_41069_().f_76396_;
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.TRAMPOLINE.get()});
        Minecraft.m_91087_().getItemColors().m_92689_((stack, i) -> {
            CompoundTag blockEntityTag;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && (blockEntityTag = tag.m_128469_("BlockEntityTag")).m_128425_("Color", 3)) {
                return DyeColor.m_41053_((int)blockEntityTag.m_128451_((String)"Color")).m_41069_().f_76396_;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModBlocks.TRAMPOLINE.get()});
    }

    private static boolean useFancyGraphics() {
        Minecraft mc = Minecraft.m_91087_();
        return ((GraphicsStatus)mc.f_91066_.m_232060_().m_231551_()).m_35965_() > 0;
    }

    public static void showDoorMatScreen(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DoorMatBlockEntity) {
            DoorMatBlockEntity blockEntity2 = (DoorMatBlockEntity)blockEntity;
            Minecraft.m_91087_().m_91152_((Screen)new DoorMatScreen(blockEntity2));
        }
    }
}

