/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FurnitureBlock;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.tileentity.TrampolineBlockEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrampolineBlock
extends FurnitureBlock
implements EntityBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty CORNER_NORTH_WEST = BooleanProperty.m_61465_((String)"corner_north_west");
    public static final BooleanProperty CORNER_NORTH_EAST = BooleanProperty.m_61465_((String)"corner_north_east");
    public static final BooleanProperty CORNER_SOUTH_EAST = BooleanProperty.m_61465_((String)"corner_south_east");
    public static final BooleanProperty CORNER_SOUTH_WEST = BooleanProperty.m_61465_((String)"corner_south_west");
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public TrampolineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CORNER_NORTH_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CORNER_NORTH_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CORNER_SOUTH_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CORNER_SOUTH_WEST, (Comparable)Boolean.valueOf(false)));
    }

    private VoxelShape getShape(BlockState state) {
        if (this.SHAPES.containsKey(state)) {
            return this.SHAPES.get(state);
        }
        VoxelShape BOTTOM_LEFT_SUPPORT_SHORT = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)3.0, (double)15.0);
        VoxelShape BOTTOM_LEFT_SUPPORT_LONG = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)16.0);
        VoxelShape BOTTOM_LEFT_SUPPORT_NORTH = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)15.0);
        VoxelShape BOTTOM_LEFT_SUPPORT_SOUTH = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)3.0, (double)16.0);
        VoxelShape BACK_LEFT_LEG = Block.m_49796_((double)1.0, (double)3.0, (double)1.0, (double)4.0, (double)13.0, (double)4.0);
        VoxelShape FRONT_LEFT_LEG = Block.m_49796_((double)1.0, (double)3.0, (double)12.0, (double)4.0, (double)13.0, (double)15.0);
        VoxelShape TOP = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape BOTTOM_RIGHT_SUPPORT_SHORT = Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
        VoxelShape BOTTOM_RIGHT_SUPPORT_LONG = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)16.0);
        VoxelShape BOTTOM_RIGHT_SUPPORT_NORTH = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)15.0);
        VoxelShape BOTTOM_RIGHT_SUPPORT_SOUTH = Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)16.0);
        VoxelShape FRONT_RIGHT_LEG = Block.m_49796_((double)12.0, (double)3.0, (double)12.0, (double)15.0, (double)13.0, (double)15.0);
        VoxelShape BACK_RIGHT_LEG = Block.m_49796_((double)12.0, (double)3.0, (double)1.0, (double)15.0, (double)13.0, (double)4.0);
        VoxelShape NORTH_WEST_CORNER_SUPPORT = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)4.0);
        VoxelShape NORTH_EAST_CORNER_SUPPORT = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)4.0);
        VoxelShape SOUTH_EAST_CORNER_SUPPORT = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)16.0);
        VoxelShape SOUTH_WEST_CORNER_SUPPORT = Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)3.0, (double)16.0);
        boolean north = (Boolean)state.m_61143_((Property)NORTH);
        boolean east = (Boolean)state.m_61143_((Property)EAST);
        boolean south = (Boolean)state.m_61143_((Property)SOUTH);
        boolean west = (Boolean)state.m_61143_((Property)WEST);
        boolean cornerNorthWest = (Boolean)state.m_61143_((Property)CORNER_NORTH_WEST);
        boolean cornerNorthEast = (Boolean)state.m_61143_((Property)CORNER_NORTH_EAST);
        boolean cornerSouthEast = (Boolean)state.m_61143_((Property)CORNER_SOUTH_EAST);
        boolean cornerSouthWest = (Boolean)state.m_61143_((Property)CORNER_SOUTH_WEST);
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(TOP);
        int count = 0;
        count += north ? 1 : 0;
        count += east ? 1 : 0;
        count += south ? 1 : 0;
        if ((count += west ? 1 : 0) >= 2) {
            if (north && !east && south && !west) {
                shapes.add(BOTTOM_LEFT_SUPPORT_LONG);
                shapes.add(BOTTOM_RIGHT_SUPPORT_LONG);
                VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
                this.SHAPES.put(state, shape);
                return shape;
            }
            if (!north && east && !south && west) {
                VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
                this.SHAPES.put(state, shape);
                return shape;
            }
        }
        if (north && east && !south && !west) {
            shapes.add(FRONT_LEFT_LEG);
        }
        if (north && !east && !south && west) {
            shapes.add(FRONT_RIGHT_LEG);
        }
        if (!north && east && south && !west) {
            shapes.add(BACK_LEFT_LEG);
        }
        if (!north && !east && south && west) {
            shapes.add(BACK_RIGHT_LEG);
        }
        if (!west) {
            if (south) {
                if (!north) {
                    shapes.add(BACK_LEFT_LEG);
                }
                shapes.add(BOTTOM_LEFT_SUPPORT_SOUTH);
            } else if (north) {
                shapes.add(FRONT_LEFT_LEG);
                shapes.add(BOTTOM_LEFT_SUPPORT_NORTH);
            } else {
                shapes.add(FRONT_LEFT_LEG);
                shapes.add(BACK_LEFT_LEG);
                shapes.add(BOTTOM_LEFT_SUPPORT_SHORT);
            }
        }
        if (!east) {
            if (south) {
                if (!north) {
                    shapes.add(BACK_RIGHT_LEG);
                }
                shapes.add(BOTTOM_RIGHT_SUPPORT_SOUTH);
            } else if (north) {
                shapes.add(FRONT_RIGHT_LEG);
                shapes.add(BOTTOM_RIGHT_SUPPORT_NORTH);
            } else {
                shapes.add(FRONT_RIGHT_LEG);
                shapes.add(BACK_RIGHT_LEG);
                shapes.add(BOTTOM_RIGHT_SUPPORT_SHORT);
            }
        }
        if (cornerNorthWest) {
            shapes.add(NORTH_WEST_CORNER_SUPPORT);
            shapes.add(BACK_LEFT_LEG);
        }
        if (cornerNorthEast) {
            shapes.add(NORTH_EAST_CORNER_SUPPORT);
            shapes.add(BACK_RIGHT_LEG);
        }
        if (cornerSouthEast) {
            shapes.add(SOUTH_EAST_CORNER_SUPPORT);
            shapes.add(FRONT_RIGHT_LEG);
        }
        if (cornerSouthWest) {
            shapes.add(SOUTH_WEST_CORNER_SUPPORT);
            shapes.add(FRONT_LEFT_LEG);
        }
        VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
        this.SHAPES.put(state, shape);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getShape(state);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity instanceof LivingEntity) {
            float height;
            float strength = 1.0f;
            float maxHeight = 0.0f;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof TrampolineBlockEntity) {
                TrampolineBlockEntity trampoline = (TrampolineBlockEntity)tileEntity;
                strength += (float)trampoline.getCount() / 100.0f;
                maxHeight = (float)trampoline.getCount() * 0.25f;
            }
            if ((height = entity.f_19789_ * strength) > 0.0f && !entity.m_6144_()) {
                if (height > maxHeight - 0.25f) {
                    height = maxHeight - 0.25f;
                }
                entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
                entity.m_5997_(0.0, Math.sqrt(0.22 * (double)(height + 0.25f)), 0.0);
                if (level.f_46443_) {
                    for (int i = 0; i < 5; ++i) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, entity.f_19854_, entity.f_19855_, entity.f_19856_, 1.0, 1.0, 1.0);
                    }
                } else {
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.BLOCK_TRAMPOLINE_BOUNCE.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.2f + 0.9f);
                }
            }
            entity.f_19789_ = 0.0f;
        }
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tileEntity;
        if (!level.m_5776_() && (tileEntity = level.m_7702_(pos)) instanceof TrampolineBlockEntity) {
            ((TrampolineBlockEntity)tileEntity).updateCount();
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getTrampolineState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getTrampolineState(state, level, pos);
    }

    private BlockState getTrampolineState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean north = level.m_8055_(pos.m_122012_()).m_60734_() == this;
        boolean east = level.m_8055_(pos.m_122029_()).m_60734_() == this;
        boolean south = level.m_8055_(pos.m_122019_()).m_60734_() == this;
        boolean west = level.m_8055_(pos.m_122024_()).m_60734_() == this;
        boolean cornerNorthWest = north && west && level.m_8055_(pos.m_122012_().m_122024_()).m_60734_() != this;
        boolean cornerNorthEast = north && east && level.m_8055_(pos.m_122012_().m_122029_()).m_60734_() != this;
        boolean cornerSouthEast = south && east && level.m_8055_(pos.m_122019_().m_122029_()).m_60734_() != this;
        boolean cornerSouthWest = south && west && level.m_8055_(pos.m_122019_().m_122024_()).m_60734_() != this;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)CORNER_NORTH_WEST, (Comparable)Boolean.valueOf(cornerNorthWest))).m_61124_((Property)CORNER_NORTH_EAST, (Comparable)Boolean.valueOf(cornerNorthEast))).m_61124_((Property)CORNER_SOUTH_EAST, (Comparable)Boolean.valueOf(cornerSouthEast))).m_61124_((Property)CORNER_SOUTH_WEST, (Comparable)Boolean.valueOf(cornerSouthWest));
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH});
        builder.m_61104_(new Property[]{EAST});
        builder.m_61104_(new Property[]{SOUTH});
        builder.m_61104_(new Property[]{WEST});
        builder.m_61104_(new Property[]{CORNER_NORTH_WEST});
        builder.m_61104_(new Property[]{CORNER_NORTH_EAST});
        builder.m_61104_(new Property[]{CORNER_SOUTH_EAST});
        builder.m_61104_(new Property[]{CORNER_SOUTH_WEST});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrampolineBlockEntity(pos, state);
    }
}

