/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mixin;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.quark.content.client.hax.PseudoAccessorItemStack;
import vazkii.quark.content.client.resources.AttributeSlot;
import vazkii.quark.content.client.tooltip.AttributeTooltips;
import vazkii.quark.content.management.module.ItemSharingModule;
import vazkii.quark.content.tools.module.AncientTomesModule;

@Mixin(value={ItemStack.class})
public class ItemStackMixin
implements PseudoAccessorItemStack {
    @Unique
    private Map<AttributeSlot, Multimap<Attribute, AttributeModifier>> capturedAttributes = new HashMap<AttributeSlot, Multimap<Attribute, AttributeModifier>>();
    @Unique
    private EquipmentSlot capturedSlot;

    @Inject(method={"getDisplayName"}, at={@At(value="RETURN")}, cancellable=true)
    private void getHoverName(CallbackInfoReturnable<Component> callbackInfoReturnable) {
        callbackInfoReturnable.setReturnValue((Object)ItemSharingModule.createStackComponent((ItemStack)this, (MutableComponent)callbackInfoReturnable.getReturnValue()));
    }

    @Inject(method={"getRarity"}, at={@At(value="RETURN")}, cancellable=true)
    private void getRarity(CallbackInfoReturnable<Rarity> callbackInfoReturnable) {
        callbackInfoReturnable.setReturnValue((Object)AncientTomesModule.shiftRarity((ItemStack)this, (Rarity)callbackInfoReturnable.getReturnValue()));
    }

    @Override
    public Map<AttributeSlot, Multimap<Attribute, AttributeModifier>> quark$getCapturedAttributes() {
        return this.capturedAttributes;
    }

    @Override
    public void quark$capturePotionAttributes(List<Pair<Attribute, AttributeModifier>> attributes) {
        LinkedHashMultimap attributeContainer = LinkedHashMultimap.create();
        for (Pair<Attribute, AttributeModifier> pair : attributes) {
            attributeContainer.put((Object)((Attribute)pair.getFirst()), (Object)((AttributeModifier)pair.getSecond()));
        }
        this.capturedAttributes.put(AttributeSlot.POTION, (Multimap<Attribute, AttributeModifier>)attributeContainer);
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="HEAD")})
    private void clearCapturedTooltip(Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir) {
        this.capturedAttributes = new HashMap<AttributeSlot, Multimap<Attribute, AttributeModifier>>();
    }

    @ModifyArg(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getAttributeModifiers(Lnet/minecraft/world/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;"))
    private EquipmentSlot captureTooltipSlot(EquipmentSlot slot) {
        this.capturedSlot = slot;
        return slot;
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Multimap;isEmpty()Z", shift=At.Shift.BEFORE))
    private Multimap<Attribute, AttributeModifier> overrideAttributeTooltips(Multimap<Attribute, AttributeModifier> attributes) {
        if (AttributeTooltips.shouldHideAttributes()) {
            this.capturedAttributes.put(AttributeSlot.fromCanonicalSlot(this.capturedSlot), (Multimap<Attribute, AttributeModifier>)LinkedHashMultimap.create(attributes));
            return ImmutableMultimap.of();
        }
        return attributes;
    }
}

