/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.CompoundBiomeConfig;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.content.world.block.MyaliteCrystalBlock;
import vazkii.quark.content.world.gen.SpiralSpireGenerator;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class SpiralSpiresModule
extends QuarkModule {
    @Config
    public static DimensionConfig dimensions = DimensionConfig.end(false);
    @Config
    public static CompoundBiomeConfig biomes = CompoundBiomeConfig.fromBiomeReslocs(false, "minecraft:end_highlands");
    @Config
    public static int rarity = 200;
    @Config
    public static int radius = 15;
    @Config(description="Set to 0 to turn off Myalite Conduits")
    public static int myaliteConduitDistance = 24;
    @Config
    public static boolean renewableMyalite = true;
    public static Block dusky_myalite;
    public static Block myalite_crystal;

    @Override
    public void register() {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76382_).m_60999_().m_60913_(1.5f, 6.0f);
        dusky_myalite = new QuarkBlock("dusky_myalite", this, CreativeModeTab.f_40749_, props);
        myalite_crystal = new MyaliteCrystalBlock(this);
    }

    @Override
    public void setup() {
        WorldGenHandler.addGenerator(this, new SpiralSpireGenerator(dimensions), GenerationStep.Decoration.SURFACE_STRUCTURES, 0);
    }

    @SubscribeEvent
    public void onTeleport(EntityTeleportEvent event) {
        if (myaliteConduitDistance <= 0) {
            return;
        }
        Entity entity = event.getEntity();
        Level world = entity.f_19853_;
        BlockPos pos = new BlockPos(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        List<BlockPos> myalite = SpiralSpiresModule.getAdjacentMyalite(null, world, pos, null);
        if (myalite == null || myalite.isEmpty()) {
            pos = pos.m_7495_();
            myalite = SpiralSpiresModule.getAdjacentMyalite(null, world, pos, null);
        }
        if (myalite != null && !myalite.isEmpty()) {
            BlockPos test;
            ArrayList<BlockPos> found;
            block9: {
                BlockPos prev;
                BlockPos cond = pos;
                found = new ArrayList<BlockPos>();
                int moves = 0;
                do {
                    prev = cond;
                    cond = myalite.get(world.f_46441_.m_188503_(myalite.size()));
                    found.add(cond);
                    myalite = SpiralSpiresModule.getAdjacentMyalite(found, world, cond, null);
                    if (myalite != null && ++moves <= myaliteConduitDistance) continue;
                    return;
                } while (!myalite.isEmpty());
                test = cond.m_7918_(cond.m_123341_() - prev.m_123341_(), cond.m_123342_() - prev.m_123342_(), cond.m_123343_() - prev.m_123343_());
                if (!world.m_8055_(test).m_60795_()) {
                    for (Direction d : Direction.values()) {
                        test = cond.m_121945_(d);
                        if (!world.m_8055_(test).m_60795_()) continue;
                        if (d.m_122434_() == Direction.Axis.Y) {
                            test = test.m_121945_(d);
                        }
                        break block9;
                    }
                    return;
                }
            }
            event.setTargetX((double)test.m_123341_() + 0.5);
            event.setTargetY((double)test.m_123342_() + 0.5);
            event.setTargetZ((double)test.m_123343_() + 0.5);
            if (world instanceof ServerLevel) {
                ServerLevel sworld = (ServerLevel)world;
                for (BlockPos f : found) {
                    sworld.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, myalite_crystal.m_49966_()), (double)f.m_123341_() + 0.5, (double)f.m_123342_() + 0.5, (double)f.m_123343_() + 0.5, 30, 0.25, 0.25, 0.25, 0.0);
                }
            }
        }
    }

    private static List<BlockPos> getAdjacentMyalite(List<BlockPos> found, Level world, BlockPos pos, Direction ignore) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>(6);
        ArrayList<BlockPos> collisions = new ArrayList<BlockPos>();
        for (Direction d : Direction.values()) {
            BlockPos off;
            if (d == ignore || world.m_8055_(off = pos.m_121945_(d)).m_60734_() != myalite_crystal) continue;
            if (found != null && found.contains(off)) {
                collisions.add(off);
                continue;
            }
            ret.add(off);
        }
        if (ret.isEmpty() && collisions.size() > 1) {
            return null;
        }
        return ret;
    }
}

