/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.generator.multichunk.MultiChunkFeatureGenerator;
import vazkii.quark.content.world.module.NewStoneTypesModule;
import vazkii.quark.content.world.module.SpiralSpiresModule;

public class SpiralSpireGenerator
extends MultiChunkFeatureGenerator {
    public SpiralSpireGenerator(DimensionConfig dimConfig) {
        super(dimConfig, NO_COND, 1892L);
    }

    @Override
    public int getFeatureRadius() {
        return SpiralSpiresModule.radius;
    }

    @Override
    public void generateChunkPart(BlockPos src, ChunkGenerator generator, Random random, BlockPos chunkCorner, WorldGenRegion world) {
        double dist = chunkCorner.m_123331_((Vec3i)src) / (double)(16 * SpiralSpiresModule.radius * (16 * SpiralSpiresModule.radius));
        if (dist > 0.5 && random.nextDouble() < 1.5 - dist) {
            return;
        }
        BlockPos pos = chunkCorner.m_7918_(random.nextInt(16), 256, random.nextInt(16));
        Holder<Biome> biome = this.getBiome((LevelAccessor)world, pos, false);
        if (!SpiralSpiresModule.biomes.canSpawn(biome)) {
            return;
        }
        while (world.m_8055_(pos).m_60734_() != Blocks.f_50259_) {
            if ((pos = pos.m_7495_()).m_123342_() >= 10) continue;
            return;
        }
        this.makeSpike(world, generator, random, pos);
    }

    @Override
    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkCorner) {
        if (!chunkCorner.m_123314_(Vec3i.f_123288_, 1050.0) && SpiralSpiresModule.rarity > 0 && random.nextInt(SpiralSpiresModule.rarity) == 0) {
            return new BlockPos[]{chunkCorner};
        }
        return new BlockPos[0];
    }

    public void makeSpike(WorldGenRegion world, ChunkGenerator chunk, Random rand, BlockPos pos) {
        int start;
        int y;
        int height = 50 + rand.nextInt(20);
        double heightComposition = 5.0 + rand.nextDouble() * 1.0;
        for (y = start = -5; y < height; ++y) {
            BlockPos test = pos.m_6630_(y);
            BlockState state = world.m_8055_(test);
            if (state.m_60795_() || state.m_60734_() == Blocks.f_50259_ || state.m_60734_() == Blocks.f_50723_ || state.m_60734_() == Blocks.f_50080_ || state.m_60734_() == SpiralSpiresModule.myalite_crystal) continue;
            return;
        }
        for (y = start; y < height; ++y) {
            if (y < 0 && !world.m_8055_(pos.m_6630_(y)).m_60815_()) continue;
            double r = Math.abs((1.5707963267948966 - Math.atan(((double)Math.max(0, y) + 0.5) / ((double)height / heightComposition))) * 4.0);
            int ri = (int)Math.ceil(r);
            for (int i = -ri + 1; i < ri; ++i) {
                for (int j = -ri + 1; j < ri; ++j) {
                    if (i * i + j * j > ri * ri) continue;
                    boolean edge = i == -ri + 1 || i == ri - 1 || j == -ri + 1 || j == ri - 1;
                    BlockState state = (edge && (double)rand.nextFloat() < 0.2 ? NewStoneTypesModule.myaliteBlock : SpiralSpiresModule.dusky_myalite).m_49966_();
                    world.m_7731_(pos.m_7918_(i, y, j), state, 2);
                }
            }
        }
        int steps = 80 + rand.nextInt(30);
        int substeps = 10;
        int fullSteps = steps * substeps;
        int deteroirate = (int)((0.5 + rand.nextDouble() * 0.3) * (double)fullSteps);
        double spin = 0.12 + rand.nextDouble() * 0.16;
        double spread = 0.12 + rand.nextDouble() * 0.04;
        double upwardMotion = rand.nextDouble() * 0.2;
        if (rand.nextBoolean()) {
            spin *= -1.0;
        }
        BlockState state = SpiralSpiresModule.myalite_crystal.m_49966_();
        for (int i = 0; i < fullSteps; ++i) {
            double t = (double)i * spin;
            int x = (int)(Math.sin(t / (double)substeps) * (double)i * spread / (double)substeps);
            int z = (int)(Math.cos(t / (double)substeps) * (double)i * spread / (double)substeps);
            int yp = y + (int)Math.round((double)i / (double)substeps * upwardMotion);
            BlockPos next = pos.m_7918_(x, yp, z);
            float chance = 1.0f;
            if (i > deteroirate) {
                int deterStep = i - deteroirate;
                int maxSteps = fullSteps - deteroirate;
                chance -= (float)deterStep / (float)maxSteps;
            }
            if (!(rand.nextFloat() < chance)) continue;
            world.m_7731_(next, state, 2);
        }
    }
}

