/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen;

import java.util.Objects;
import java.util.Random;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.world.generator.multichunk.ClusterBasedGenerator;
import vazkii.quark.content.world.config.AirStoneClusterConfig;
import vazkii.quark.content.world.config.BigStoneClusterConfig;
import vazkii.quark.content.world.module.BigStoneClustersModule;

public class BigStoneClusterGenerator
extends ClusterBasedGenerator {
    private final BigStoneClusterConfig config;
    private final BlockState placeState;

    public BigStoneClusterGenerator(BigStoneClusterConfig config, BlockState placeState, BooleanSupplier condition) {
        super(config.dimensions, () -> config.enabled && condition.getAsBoolean(), config, Objects.toString(RegistryHelper.getRegistryName((Object)placeState.m_60734_(), (Registry)Registry.f_122824_)).hashCode());
        this.config = config;
        this.placeState = placeState;
    }

    @Override
    public boolean isSourceValid(WorldGenRegion world, ChunkGenerator generator, BlockPos pos) {
        return this.config.biomes.canSpawn(this.getBiome((LevelAccessor)world, pos, true));
    }

    @Override
    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkLeft) {
        BlockPos[] sources;
        int chance = this.config.rarity;
        if (chance > 0 && random.nextInt(chance) == 0) {
            BlockPos pos;
            sources = new BlockPos[1];
            int lower = Math.abs(this.config.minYLevel);
            int range = Math.abs(this.config.maxYLevel - this.config.minYLevel);
            sources[0] = pos = chunkLeft.m_7918_(random.nextInt(16), random.nextInt(range) + lower, random.nextInt(16));
        } else {
            sources = new BlockPos[]{};
        }
        return sources;
    }

    public String toString() {
        return "BigStoneClusterGenerator[" + this.placeState + "]";
    }

    @Override
    public ClusterBasedGenerator.IGenerationContext createContext(BlockPos src, ChunkGenerator generator, Random random, BlockPos chunkCorner, WorldGenRegion world) {
        return (pos, noise) -> {
            if (this.canPlaceBlock((ServerLevelAccessor)world, pos)) {
                world.m_7731_(pos, this.placeState, 0);
            }
        };
    }

    private boolean canPlaceBlock(ServerLevelAccessor world, BlockPos pos) {
        BigStoneClusterConfig bigStoneClusterConfig = this.config;
        if (bigStoneClusterConfig instanceof AirStoneClusterConfig) {
            AirStoneClusterConfig clusterConfig = (AirStoneClusterConfig)bigStoneClusterConfig;
            if (clusterConfig.generateInAir) {
                return world.m_8055_(pos).m_60795_();
            }
        }
        return BigStoneClustersModule.blockReplacePredicate.test((Level)world.m_6018_(), world.m_8055_(pos).m_60734_());
    }
}

