/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block.be;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.arl.block.be.ARLBlockEntity;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.content.world.module.MonsterBoxModule;

public class MonsterBoxBlockEntity
extends ARLBlockEntity {
    private int breakProgress;

    public MonsterBoxBlockEntity(BlockPos pos, BlockState state) {
        super(MonsterBoxModule.blockEntityType, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MonsterBoxBlockEntity be) {
        boolean doBreak;
        if (level.m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (level.f_46443_) {
            level.m_7106_((ParticleOptions)(be.breakProgress == 0 ? ParticleTypes.f_123744_ : ParticleTypes.f_123755_), (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
        }
        boolean bl = doBreak = be.breakProgress > 0;
        if (!doBreak) {
            List players = level.m_6907_();
            for (Player p : players) {
                if (!(p.m_20275_((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 6.25) || p.m_5833_()) continue;
                doBreak = true;
                break;
            }
        }
        if (doBreak) {
            if (be.breakProgress == 0) {
                level.m_5594_(null, pos, QuarkSounds.BLOCK_MONSTER_BOX_GROWL, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            ++be.breakProgress;
            if (be.breakProgress > 40) {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)level.m_8055_(pos)));
                level.m_7471_(pos, false);
                be.spawnMobs();
            }
        }
    }

    private void spawnMobs() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockPos pos = this.m_58899_();
        int mobCount = MonsterBoxModule.minMobCount + this.f_58857_.f_46441_.m_188503_(Math.max(MonsterBoxModule.maxMobCount - MonsterBoxModule.minMobCount + 1, 1));
        for (int i = 0; i < mobCount; ++i) {
            float r = this.f_58857_.f_46441_.m_188501_();
            Object e = (double)r < 0.1 ? new Witch(EntityType.f_20495_, this.f_58857_) : ((double)r < 0.3 ? new CaveSpider(EntityType.f_20554_, this.f_58857_) : new Zombie(this.f_58857_));
            double motionMultiplier = 0.4;
            e.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            double mx = ((double)this.f_58857_.f_46441_.m_188501_() - 0.5) * motionMultiplier;
            double my = ((double)this.f_58857_.f_46441_.m_188501_() - 0.5) * motionMultiplier;
            double mz = ((double)this.f_58857_.f_46441_.m_188501_() - 0.5) * motionMultiplier;
            e.m_20334_(mx, my, mz);
            e.getPersistentData().m_128379_("quark:monster_box_spawned", true);
            this.f_58857_.m_7967_((Entity)e);
        }
    }
}

