/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.HarvestMessage;
import vazkii.quark.content.tweaks.module.HoeHarvestingModule;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class SimpleHarvestModule
extends QuarkModule {
    @Config(description="Can players harvest crops with empty hand clicks?")
    public static boolean emptyHandHarvest = true;
    @Config(description="Does harvesting crops with a hoe cost durability?")
    public static boolean harvestingCostsDurability = false;
    @Config(description="Should Quark look for (nonvanilla) crops, and handle them?")
    public static boolean doHarvestingSearch = true;
    @Config(description="Which crops can be harvested?\nFormat is: \"harvestState[,afterHarvest]\", i.e. \"minecraft:wheat[age=7]\" or \"minecraft:cocoa[age=2,facing=north],minecraft:cocoa[age=0,facing=north]\"")
    public static List<String> harvestableBlocks = Lists.newArrayList((Object[])new String[]{"minecraft:wheat[age=7]", "minecraft:carrots[age=7]", "minecraft:potatoes[age=7]", "minecraft:beetroots[age=3]", "minecraft:nether_wart[age=3]", "minecraft:cocoa[age=2,facing=north],minecraft:cocoa[age=0,facing=north]", "minecraft:cocoa[age=2,facing=south],minecraft:cocoa[age=0,facing=south]", "minecraft:cocoa[age=2,facing=east],minecraft:cocoa[age=0,facing=east]", "minecraft:cocoa[age=2,facing=west],minecraft:cocoa[age=0,facing=west]"});
    @Config(description="Which blocks should right click harvesting simulate a click on instead of breaking?\nThis is for blocks like sweet berry bushes, which have right click harvesting built in.")
    public static List<String> rightClickableBlocks = Lists.newArrayList((Object[])new String[]{"minecraft:sweet_berry_bush", "minecraft:cave_vines"});
    public static final Map<BlockState, BlockState> crops = Maps.newHashMap();
    public static final Set<Block> rightClickCrops = Sets.newHashSet();
    private boolean isHarvesting = false;

    @Override
    public void configChanged() {
        crops.clear();
        rightClickCrops.clear();
        if (doHarvestingSearch) {
            ForgeRegistries.BLOCKS.getValues().stream().filter(b -> !this.isVanilla((Block)b) && b instanceof CropBlock).map(b -> (CropBlock)b).forEach(b -> crops.put((BlockState)b.m_49966_().m_61124_((Property)b.m_7959_(), (Comparable)Integer.valueOf(this.last(b.m_7959_().m_6908_()))), b.m_49966_()));
            ForgeRegistries.BLOCKS.getValues().stream().filter(b -> !this.isVanilla((Block)b) && (b instanceof BushBlock || b instanceof GrowingPlantBlock) && b instanceof BonemealableBlock && !(b instanceof CropBlock)).forEach(rightClickCrops::add);
        }
        for (String harvestKey : harvestableBlocks) {
            String[] split = this.tokenize(harvestKey);
            BlockState initial = MiscUtil.fromString(split[0]);
            BlockState result = split.length > 1 ? MiscUtil.fromString(split[1]) : initial.m_60734_().m_49966_();
            if (initial.m_60734_() == Blocks.f_50016_) continue;
            crops.put(initial, result);
        }
        for (String blockName : rightClickableBlocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
            if (block == null) continue;
            rightClickCrops.add(block);
        }
    }

    private int last(Collection<Integer> vals) {
        return vals.stream().max(Integer::compare).orElse(0);
    }

    private String[] tokenize(String harvestKey) {
        boolean inBracket = false;
        for (int i = 0; i < harvestKey.length(); ++i) {
            char charAt = harvestKey.charAt(i);
            if (charAt == '[') {
                inBracket = true;
                continue;
            }
            if (charAt == ']') {
                inBracket = false;
                continue;
            }
            if (charAt != ',' || inBracket) continue;
            return new String[]{harvestKey.substring(0, i), harvestKey.substring(i + 1)};
        }
        return new String[]{harvestKey};
    }

    private boolean isVanilla(Block entry) {
        ResourceLocation loc = Registry.f_122824_.m_7981_((Object)entry);
        if (loc == null) {
            return true;
        }
        return loc.m_135827_().equals("minecraft");
    }

    private static void harvestAndReplant(Level world, BlockPos pos, BlockState inWorld, Player player) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        ItemStack mainHand = player.m_21205_();
        int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)mainHand);
        ItemStack copy = mainHand.m_41777_();
        if (copy.m_41619_()) {
            copy = new ItemStack((ItemLike)Items.f_42398_);
        }
        Map enchMap = EnchantmentHelper.m_44831_((ItemStack)copy);
        enchMap.put(Enchantments.f_44987_, fortune);
        EnchantmentHelper.m_44865_((Map)enchMap, (ItemStack)copy);
        Item blockItem = inWorld.m_60734_().m_5456_();
        Block.m_49874_((BlockState)inWorld, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)copy).forEach(stack -> {
            if (stack.m_41720_() == blockItem) {
                stack.m_41774_(1);
            }
            if (!stack.m_41619_()) {
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
            }
        });
        inWorld.m_222967_(serverLevel, pos, copy, true);
        if (!world.f_46443_) {
            BlockState newBlock = crops.get(inWorld);
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)newBlock));
            world.m_46597_(pos, newBlock);
        }
    }

    @SubscribeEvent
    public void onClick(PlayerInteractEvent.RightClickBlock event) {
        if (this.isHarvesting) {
            return;
        }
        this.isHarvesting = true;
        if (SimpleHarvestModule.click(event.getEntity(), event.getHand(), event.getPos(), event.getHitVec())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)event.getLevel().f_46443_));
        }
        this.isHarvesting = false;
    }

    private static boolean handle(Player player, InteractionHand hand, BlockPos pos, boolean doRightClick) {
        if (!player.f_19853_.m_7966_(player, pos)) {
            return false;
        }
        BlockState worldBlock = player.f_19853_.m_8055_(pos);
        if (crops.containsKey(worldBlock)) {
            SimpleHarvestModule.harvestAndReplant(player.f_19853_, pos, worldBlock, player);
            return true;
        }
        if (doRightClick && rightClickCrops.contains(worldBlock.m_60734_())) {
            if (!player.f_19853_.f_46443_) {
                return true;
            }
            return Quark.proxy.clientUseItem(player, player.f_19853_, hand, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, true)).m_19077_();
        }
        return false;
    }

    public static boolean click(Player player, InteractionHand hand, BlockPos pos, BlockHitResult pick) {
        if (player == null || hand == null) {
            return false;
        }
        if (pick.m_6662_() != HitResult.Type.BLOCK || !pick.m_82425_().equals((Object)pos)) {
            return false;
        }
        BlockState stateAt = player.f_19853_.m_8055_(pos);
        if (stateAt.getToolModifiedState(new UseOnContext(player, hand, pick), ToolActions.HOE_TILL, true) != null) {
            return false;
        }
        ItemStack inHand = player.m_21120_(hand);
        boolean isHoe = HoeHarvestingModule.isHoe(inHand);
        if (!emptyHandHarvest && !isHoe) {
            return false;
        }
        int range = HoeHarvestingModule.getRange(inHand);
        boolean hasHarvested = false;
        for (int x = 1 - range; x < range; ++x) {
            for (int z = 1 - range; z < range; ++z) {
                BlockPos shiftPos = pos.m_7918_(x, 0, z);
                if (!SimpleHarvestModule.handle(player, hand, shiftPos, range > 1)) {
                    if (!SimpleHarvestModule.handle(player, hand, shiftPos = shiftPos.m_7494_(), range > 1)) continue;
                    hasHarvested = true;
                    continue;
                }
                hasHarvested = true;
            }
        }
        if (!hasHarvested) {
            return false;
        }
        if (player.f_19853_.f_46443_) {
            if (inHand.m_41619_()) {
                QuarkNetwork.sendToServer(new HarvestMessage(pos, hand));
            }
        } else if (harvestingCostsDurability && isHoe) {
            inHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        }
        return true;
    }
}

