/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.client.emote;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.base.Quark;
import vazkii.quark.content.tweaks.module.EmotesModule;

@OnlyIn(value=Dist.CLIENT)
public class CustomEmoteIconResourcePack
extends AbstractPackResources {
    private final List<String> verifiedNames = new ArrayList<String>();
    private final List<String> existingNames = new ArrayList<String>();

    public CustomEmoteIconResourcePack() {
        super(EmotesModule.emotesDir);
    }

    @Nonnull
    public Set<String> m_5698_(@Nonnull PackType type) {
        if (type == PackType.CLIENT_RESOURCES) {
            return ImmutableSet.of((Object)"quark_custom");
        }
        return ImmutableSet.of();
    }

    @Nonnull
    protected InputStream m_5541_(@Nonnull String name) throws IOException {
        if (name.equals("pack.mcmeta")) {
            return Quark.class.getResourceAsStream("/proxypack.mcmeta");
        }
        if (name.equals("pack.png")) {
            return Quark.class.getResourceAsStream("/proxypack.png");
        }
        File file = this.getFile(name);
        if (!file.exists()) {
            throw new FileNotFoundException(name);
        }
        return new FileInputStream(file);
    }

    @Nonnull
    public Collection<ResourceLocation> m_214146_(@Nonnull PackType type, @Nonnull String pathIn, @Nonnull String idk, @Nonnull Predicate<ResourceLocation> filter) {
        File rootPath = new File(this.f_10203_, type.m_10305_());
        ArrayList allResources = Lists.newArrayList();
        for (String namespace : this.m_5698_(type)) {
            this.crawl(new File(new File(rootPath, namespace), pathIn), 32, namespace, allResources, pathIn + "/", filter);
        }
        return allResources;
    }

    private void crawl(File rootPath, int maxDepth, String namespace, List<ResourceLocation> allResources, String path, Predicate<ResourceLocation> filter) {
        File[] files = rootPath.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (maxDepth <= 0) continue;
                    this.crawl(file, maxDepth - 1, namespace, allResources, path + file.getName() + "/", filter);
                    continue;
                }
                if (file.getName().endsWith(".mcmeta") || !filter.test(new ResourceLocation(namespace, path + file.getName()))) continue;
                try {
                    allResources.add(new ResourceLocation(namespace, path + file.getName()));
                }
                catch (ResourceLocationException e) {
                    Quark.LOG.error(e.getMessage());
                }
            }
        }
    }

    public void close() {
    }

    protected boolean m_6105_(@Nonnull String name) {
        if (!this.verifiedNames.contains(name)) {
            File file = this.getFile(name);
            if (file.exists()) {
                this.existingNames.add(name);
            }
            this.verifiedNames.add(name);
        }
        return this.existingNames.contains(name);
    }

    private File getFile(String name) {
        String filename = name.substring(name.indexOf(":") + 1) + ".png";
        return new File(EmotesModule.emotesDir, filename);
    }

    public boolean isHidden() {
        return true;
    }

    @Nonnull
    public String m_8017_() {
        return "quark-emote-pack";
    }
}

