/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.tools.entity.ParrotEgg;
import vazkii.quark.content.tools.item.ParrotEggItem;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class ParrotEggsModule
extends QuarkModule {
    private static final ResourceLocation KOTO = new ResourceLocation("quark", "textures/model/entity/kotobirb.png");
    private static final String EGG_TIMER = "quark:parrot_egg_timer";
    private static final List<String> NAMES = List.of("red_blue", "blue", "green", "yellow_blue", "grey");
    public static EntityType<ParrotEgg> parrotEggType;
    public static TagKey<Item> feedTag;
    public static List<Item> parrotEggs;
    @Config(description="The chance feeding a parrot will produce an egg")
    public static double chance;
    @Config(description="How long it takes to create an egg")
    public static int eggTime;
    @Config(name="Enable Special Awesome Parrot")
    public static boolean enableKotobirb;
    private static boolean isEnabled;

    @Override
    public void register() {
        parrotEggType = EntityType.Builder.m_20704_(ParrotEgg::new, (MobCategory)MobCategory.MISC).m_20699_(0.4f, 0.4f).m_20702_(64).m_20717_(10).setCustomClientFactory((spawnEntity, world) -> new ParrotEgg(parrotEggType, (Level)world)).m_20712_("parrot_egg");
        RegistryHelper.register(parrotEggType, (String)"parrot_egg", (ResourceKey)Registry.f_122903_);
        parrotEggs = new ArrayList<Item>();
        int i = 0;
        while (i < 5) {
            final int variant = i++;
            ParrotEggItem parrotEgg = new ParrotEggItem(NAMES.get(variant), variant, this);
            parrotEggs.add((Item)parrotEgg);
            DispenserBlock.m_52672_((ItemLike)parrotEgg, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                @Nonnull
                protected Projectile m_6895_(@Nonnull Level world, @Nonnull Position pos, @Nonnull ItemStack stack) {
                    return (Projectile)Util.m_137469_((Object)((Object)new ParrotEgg(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_())), parrotEgg -> {
                        parrotEgg.m_37446_(stack);
                        parrotEgg.setVariant(variant);
                    });
                }
            });
        }
    }

    @Override
    public void setup() {
        feedTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "parrot_feed"));
    }

    @Override
    public void configChanged() {
        isEnabled = this.enabled;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        EntityRenderers.m_174036_(parrotEggType, ThrownItemRenderer::new);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation getTextureForParrot(Parrot parrot) {
        if (!isEnabled || !enableKotobirb) {
            return null;
        }
        UUID uuid = parrot.m_20148_();
        if (parrot.m_29440_() == 4 && uuid.getLeastSignificantBits() % 20L == 0L) {
            return KOTO;
        }
        return null;
    }

    @SubscribeEvent
    public void entityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity e = event.getTarget();
        Player player = event.getEntity();
        if (e instanceof Parrot) {
            Parrot parrot = (Parrot)e;
            ItemStack stack = player.m_21205_();
            if (stack.m_41619_() || !stack.m_204117_(feedTag)) {
                stack = player.m_21206_();
            }
            if (!stack.m_41619_() && stack.m_204117_(feedTag)) {
                if (e.getPersistentData().m_128451_(EGG_TIMER) <= 0) {
                    Level level;
                    if (!parrot.m_21824_()) {
                        return;
                    }
                    event.setCanceled(true);
                    if (parrot.f_19853_.f_46443_ || event.getHand() == InteractionHand.OFF_HAND) {
                        return;
                    }
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    if ((level = parrot.f_19853_) instanceof ServerLevel) {
                        ServerLevel ws = (ServerLevel)level;
                        ws.m_6263_(null, parrot.m_20185_(), parrot.m_20186_(), parrot.m_20189_(), SoundEvents.f_12190_, SoundSource.NEUTRAL, 1.0f, 1.0f + (ws.f_46441_.m_188501_() - ws.f_46441_.m_188501_()) * 0.2f);
                        if (ws.f_46441_.m_188500_() < chance) {
                            parrot.getPersistentData().m_128405_(EGG_TIMER, eggTime);
                            ws.m_8767_((ParticleOptions)ParticleTypes.f_123748_, parrot.m_20185_(), parrot.m_20186_(), parrot.m_20189_(), 10, (double)parrot.m_20205_(), (double)parrot.m_20206_(), (double)parrot.m_20205_(), 0.0);
                        } else {
                            ws.m_8767_((ParticleOptions)ParticleTypes.f_123762_, parrot.m_20185_(), parrot.m_20186_(), parrot.m_20189_(), 10, (double)parrot.m_20205_(), (double)parrot.m_20206_(), (double)parrot.m_20205_(), 0.0);
                        }
                    }
                } else {
                    Level level = parrot.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel ws = (ServerLevel)level;
                        ws.m_8767_((ParticleOptions)ParticleTypes.f_123750_, parrot.m_20185_(), parrot.m_20186_(), parrot.m_20189_(), 1, (double)parrot.m_20205_(), (double)parrot.m_20206_(), (double)parrot.m_20205_(), 0.0);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void entityUpdate(LivingEvent.LivingTickEvent event) {
        Parrot parrot;
        int time;
        LivingEntity e = event.getEntity();
        if (e instanceof Parrot && (time = (parrot = (Parrot)e).getPersistentData().m_128451_(EGG_TIMER)) > 0) {
            if (time == 1) {
                e.m_5496_(QuarkSounds.ENTITY_PARROT_EGG, 1.0f, (parrot.f_19853_.f_46441_.m_188501_() - parrot.f_19853_.f_46441_.m_188501_()) * 0.2f + 1.0f);
                e.m_5552_(new ItemStack((ItemLike)parrotEggs.get(this.getResultingEggColor(parrot))), 0.0f);
            }
            e.getPersistentData().m_128405_(EGG_TIMER, time - 1);
        }
    }

    private int getResultingEggColor(Parrot parrot) {
        int color = parrot.m_29440_();
        RandomSource rand = parrot.f_19853_.f_46441_;
        if (rand.m_188499_()) {
            return color;
        }
        return rand.m_188503_(5);
    }

    static {
        chance = 0.05;
        eggTime = 12000;
        enableKotobirb = true;
    }
}

