/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.addons.oddities.module.TinyPotatoModule;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.content.mobs.ai.FindPlaceToSleepGoal;
import vazkii.quark.content.mobs.ai.SleepGoal;
import vazkii.quark.content.mobs.module.FoxhoundModule;
import vazkii.quark.content.tweaks.ai.WantLoveGoal;

public class Foxhound
extends Wolf
implements Enemy {
    public static final ResourceLocation FOXHOUND_LOOT_TABLE = new ResourceLocation("quark", "entities/foxhound");
    private static final EntityDataAccessor<Boolean> TEMPTATION = SynchedEntityData.m_135353_(Foxhound.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_BLUE = SynchedEntityData.m_135353_(Foxhound.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TATERING = SynchedEntityData.m_135353_(Foxhound.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int timeUntilPotatoEmerges = 0;
    protected SleepGoal sleepGoal;

    public Foxhound(EntityType<? extends Foxhound> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_30397_(DyeColor.ORANGE);
        this.f_19804_.m_135372_(TEMPTATION, (Object)false);
        this.f_19804_.m_135372_(IS_BLUE, (Object)false);
        this.f_19804_.m_135372_(TATERING, (Object)false);
    }

    public int m_5792_() {
        return 4;
    }

    public boolean m_21532_() {
        return super.m_21532_();
    }

    public boolean m_8023_() {
        return this.m_21824_();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_21824_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        Holder biome = worldIn.m_204166_(new BlockPos(this.m_20182_()));
        if (biome.m_203373_(Biomes.f_48199_.m_135782_())) {
            this.setBlue(true);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_8119_() {
        BlockPos below;
        BlockEntity tile;
        block23: {
            LivingEntity owner;
            block24: {
                super.m_8119_();
                Pose pose = this.m_20089_();
                if (this.m_5803_()) {
                    if (pose != Pose.SLEEPING) {
                        this.m_20124_(Pose.SLEEPING);
                    }
                } else if (pose == Pose.SLEEPING) {
                    this.m_20124_(Pose.STANDING);
                }
                if (!this.f_19853_.f_46443_ && this.f_19853_.m_46791_() == Difficulty.PEACEFUL && !this.m_21824_()) {
                    this.m_146870_();
                    return;
                }
                if (!this.f_19853_.f_46443_ && this.timeUntilPotatoEmerges > 0) {
                    if (--this.timeUntilPotatoEmerges == 0) {
                        this.setTatering(false);
                        ItemStack stack = new ItemStack((ItemLike)TinyPotatoModule.tiny_potato);
                        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"angery", (boolean)true);
                        this.m_19983_(stack);
                        this.m_5496_(QuarkSounds.BLOCK_POTATO_HURT, 1.0f, 1.0f);
                    } else if (!this.isTatering()) {
                        this.setTatering(true);
                    }
                }
                if (this.m_5803_()) {
                    AABB aabb;
                    BlockPos pos;
                    Optional sleepPos = this.m_21257_();
                    if (sleepPos.isPresent() && this.m_20275_((double)(pos = (BlockPos)sleepPos.get()).m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) > 1.0) {
                        this.m_5796_();
                    }
                    if ((aabb = this.m_20191_()).m_82376_() < 0.21) {
                        this.m_20011_(new AABB(aabb.f_82288_ - 0.2, aabb.f_82289_, aabb.f_82290_ - 0.2, aabb.f_82291_ + 0.2, aabb.f_82292_ + 0.5, aabb.f_82293_ + 0.2));
                    }
                }
                if (!WantLoveGoal.needsPets((TamableAnimal)this) || (owner = this.m_21826_()) == null || !(owner.m_20280_((Entity)this) < 1.0) || owner.m_20069_() || owner.m_5825_()) break block23;
                if (!(owner instanceof Player)) break block24;
                Player player = (Player)owner;
                if (player.m_150110_().f_35934_) break block23;
            }
            owner.m_20254_(5);
        }
        Vec3 pos = this.m_20182_();
        if (this.f_19853_.f_46443_) {
            SimpleParticleType particle = ParticleTypes.f_123744_;
            if (this.m_5803_()) {
                particle = ParticleTypes.f_123762_;
            } else if (this.isBlue()) {
                particle = ParticleTypes.f_123745_;
            }
            this.f_19853_.m_7106_((ParticleOptions)particle, pos.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), pos.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20206_(), pos.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
            if (this.isTatering() && this.f_19796_.m_188500_() < 0.1) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), pos.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20206_(), pos.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
                this.f_19853_.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, QuarkSounds.ENTITY_FOXHOUND_CRACKLE, this.m_5720_(), 1.0f, 1.0f, false);
            }
        }
        if (this.m_21824_() && (tile = this.f_19853_.m_7702_(below = this.m_20183_().m_7495_())) instanceof AbstractFurnaceBlockEntity) {
            List foxhounds;
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)tile;
            int cookTime = furnace.f_58318_;
            if (cookTime > 0 && cookTime % 3 == 0 && !(foxhounds = this.f_19853_.m_6443_(Foxhound.class, new AABB(this.m_20183_()), fox -> fox != null && fox.m_21824_())).isEmpty() && foxhounds.get(0) == this) {
                furnace.f_58318_ = furnace.f_58318_ == 3 ? 5 : Math.min(furnace.f_58319_ - 1, cookTime + 1);
            }
        }
    }

    public boolean m_20070_() {
        return false;
    }

    @Nonnull
    protected ResourceLocation m_7582_() {
        return FOXHOUND_LOOT_TABLE;
    }

    protected void m_8099_() {
        this.sleepGoal = new SleepGoal(this);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.sleepGoal);
        this.f_21345_.m_25352_(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new FindPlaceToSleepGoal(this, 0.8, FindPlaceToSleepGoal.Target.LIT_FURNACE));
        this.f_21345_.m_25352_(9, (Goal)new FindPlaceToSleepGoal(this, 0.8, FindPlaceToSleepGoal.Target.FURNACE));
        this.f_21345_.m_25352_(10, (Goal)new FindPlaceToSleepGoal(this, 0.8, FindPlaceToSleepGoal.Target.GLOWING));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(12, (Goal)new BegGoal((Wolf)this, 8.0f));
        this.f_21345_.m_25352_(13, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(14, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, target -> target instanceof Sheep || target instanceof Rabbit));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, target -> !this.m_21824_()));
    }

    public int m_6784_() {
        if (!this.m_21824_() && this.f_19853_.m_46791_() != Difficulty.PEACEFUL) {
            return 0;
        }
        return super.m_6784_();
    }

    public boolean m_7327_(Entity entityIn) {
        if (entityIn.m_6095_().m_20672_()) {
            if (entityIn instanceof Player) {
                return false;
            }
            return super.m_7327_(entityIn);
        }
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this).m_19383_(), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            entityIn.m_20254_(5);
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        this.setWoke();
        return super.m_6469_(source, amount);
    }

    @Nonnull
    public InteractionResult m_6071_(Player player, @Nonnull InteractionHand hand) {
        InteractionResult res;
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42500_ && !this.m_21824_()) {
            return InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.timeUntilPotatoEmerges <= 0 && itemstack.m_150930_(TinyPotatoModule.tiny_potato.m_5456_())) {
                this.timeUntilPotatoEmerges = 600;
                this.m_5496_(QuarkSounds.ENTITY_FOXHOUND_EAT, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (!(itemstack.m_41619_() || itemstack.m_41720_() != Items.f_42413_ || this.f_19853_.m_46791_() != Difficulty.PEACEFUL && !player.m_150110_().f_35934_ && player.m_21124_(MobEffects.f_19607_) == null || this.f_19853_.f_46443_)) {
            if (this.f_19796_.m_188500_() < FoxhoundModule.tameChance) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_21153_(20.0f);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if ((res = super.m_6071_(player, hand)) == InteractionResult.SUCCESS && !this.f_19853_.f_46443_) {
            this.setWoke();
        }
        return res;
    }

    public boolean m_7848_(@Nonnull Animal otherAnimal) {
        return super.m_7848_(otherAnimal) && otherAnimal instanceof Foxhound;
    }

    public Wolf m_142606_(@Nonnull ServerLevel sworld, @Nonnull AgeableMob otherParent) {
        Foxhound kid = new Foxhound(FoxhoundModule.foxhoundType, this.f_19853_);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            kid.m_21816_(uuid);
            kid.m_7105_(true);
        }
        if (this.isBlue()) {
            kid.setBlue(true);
        }
        return kid;
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("OhLawdHeComin", this.timeUntilPotatoEmerges);
        compound.m_128379_("IsSlep", this.m_5803_());
        compound.m_128379_("IsBlue", this.isBlue());
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.timeUntilPotatoEmerges = compound.m_128451_("OhLawdHeComin");
        this.m_21837_(compound.m_128471_("IsSlep"));
        this.setBlue(compound.m_128471_("IsBlue"));
    }

    protected SoundEvent m_7515_() {
        if (this.m_5803_()) {
            return null;
        }
        if (this.m_21660_()) {
            return QuarkSounds.ENTITY_FOXHOUND_GROWL;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? QuarkSounds.ENTITY_FOXHOUND_WHINE : QuarkSounds.ENTITY_FOXHOUND_PANT;
        }
        return QuarkSounds.ENTITY_FOXHOUND_IDLE;
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_FOXHOUND_HURT;
    }

    protected SoundEvent m_5592_() {
        return QuarkSounds.ENTITY_FOXHOUND_DIE;
    }

    public boolean isBlue() {
        return (Boolean)this.f_19804_.m_135370_(IS_BLUE);
    }

    public void setBlue(boolean blue) {
        this.f_19804_.m_135381_(IS_BLUE, (Object)blue);
    }

    public boolean isTatering() {
        return (Boolean)this.f_19804_.m_135370_(TATERING);
    }

    public void setTatering(boolean tatering) {
        this.f_19804_.m_135381_(TATERING, (Object)tatering);
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_8055_(pos.m_7495_()).m_204336_(FoxhoundModule.foxhoundSpawnableTag) ? 10.0f : (float)worldIn.m_45524_(pos, 0) - 0.5f;
    }

    public static boolean spawnPredicate(EntityType<? extends Foxhound> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return world.m_46791_() != Difficulty.PEACEFUL && world.m_8055_(pos.m_7495_()).m_204336_(FoxhoundModule.foxhoundSpawnableTag);
    }

    public SleepGoal getSleepGoal() {
        return this.sleepGoal;
    }

    private void setWoke() {
        SleepGoal sleep = this.getSleepGoal();
        if (sleep != null) {
            this.m_21837_(false);
            sleep.setSleeping(false);
        }
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

