/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import vazkii.quark.content.mobs.entity.Wraith;

public class WraithModel
extends EntityModel<Wraith> {
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    private double offset;
    private float alphaMult;

    public WraithModel(ModelPart root) {
        super(RenderType::m_110473_);
        this.body = root.m_171324_("body");
        this.rightArm = root.m_171324_("rightArm");
        this.leftArm = root.m_171324_("leftArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 24.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171480_().m_171514_(32, 16).m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        root.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(Wraith entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Random rng = new Random(entity.m_19879_());
        float time = ageInTicks + (float)rng.nextInt(10000000);
        this.leftArm.f_104203_ = (float)Math.toRadians(-50.0f + rng.nextFloat() * 20.0f);
        this.rightArm.f_104203_ = (float)Math.toRadians(-50.0f + rng.nextFloat() * 20.0f);
        this.leftArm.f_104205_ = (float)Math.toRadians(-110.0f + (float)Math.cos(time / (float)(8 + rng.nextInt(2))) * (8.0f + rng.nextFloat() * 8.0f));
        this.rightArm.f_104205_ = (float)Math.toRadians(110.0f + (float)Math.cos((time + 300.0f) / (float)(8 + rng.nextInt(2))) * (8.0f + rng.nextFloat() * 8.0f));
        this.offset = Math.sin(time / 16.0f) * 0.1 + 0.15;
        this.alphaMult = 0.5f + (float)Math.sin(time / 20.0f) * 0.3f;
    }

    public void m_7695_(PoseStack matrix, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrix.m_85836_();
        matrix.m_85837_(0.0, this.offset, 0.0);
        this.body.m_104306_(matrix, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha *= this.alphaMult);
        this.leftArm.m_104306_(matrix, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.rightArm.m_104306_(matrix, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        for (int i = 0; i < 6; ++i) {
            alpha = (float)((double)alpha * 0.6);
            matrix.m_85837_(0.0, 0.0, 1.5 * this.offset + 0.1);
            matrix.m_85841_(0.8f, 0.8f, 0.8f);
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(60.0f * (float)this.offset));
            this.body.m_104306_(matrix, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.leftArm.m_104306_(matrix, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.rightArm.m_104306_(matrix, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
        matrix.m_85849_();
    }
}

